/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclEntity;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntityField;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityFieldMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.MapObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.MetadataParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataPropertyLogicalFk;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.uitl.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10EntityObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10EntityObjectServiceImpl.class);
    @Autowired
    private E10Properties e10Properties;
    @Autowired
    private SclEntityMapper sclEntityMapper;
    @Autowired
    private SclEntityFieldMapper sclEntityFieldMapper;
    @Autowired
    private ObjectProvider<MetadataParser> metadataParserProvider;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.ENTITY;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        try {
            Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
            MetadataParser object = (MetadataParser)this.metadataParserProvider.getObject();
            object.parser();
            context.setDicPropertyMap(object.getDicPropertyMap());
            context.setEntityMap(object.getEntityMap());
            List<DataEntity> allDataEntitys = object.getAllDataEntitys();
            if (CollectionUtils.isNotEmpty(allDataEntitys)) {
                Map<String, Long> dicCodeIdRel = context.getDicCodeIdRel();
                Map<String, DataEntity> entityMap = object.getEntityMap();
                HashMap<String, Long> entityFieldIdsRel = new HashMap<String, Long>();
                HashMap<String, Long> entityIdsRel = new HashMap<String, Long>();
                E10EntityObjectServiceImpl.entityParentFill(allDataEntitys, entityMap, entityFieldIdsRel);
                List<Map<String, DataEntity>> maps = MapObjectUtil.groupMapByKeyCountWithStreams(entityMap, 100);
                for (Map<String, DataEntity> entity : maps) {
                    ArrayList sclEntities = new ArrayList();
                    ArrayList entityFields = new ArrayList();
                    entity.forEach((name, dataEntity) -> {
                        if (!name.equals("ReferToEntity") && !ObjectUtils.isEmpty(businessObjectsRel.get(dataEntity.getBusinessCode()))) {
                            E10EntityObjectServiceImpl.entity(context, dataEntity, entityIdsRel, businessObjectsRel, sclEntities);
                            List<DataProperty> columns = dataEntity.getColumns();
                            E10EntityObjectServiceImpl.columns(context, dataEntity, columns, entityMap, dicCodeIdRel, entityFieldIdsRel, entityFields);
                        }
                    });
                    this.sclEntityMapper.insert(sclEntities);
                    this.sclEntityFieldMapper.insert(entityFields);
                }
                context.setEntityFieldIdsRel(entityFieldIdsRel);
                context.setEntityIdsRel(entityIdsRel);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void entityParentFill(List<DataEntity> allDataEntitys, Map<String, DataEntity> entityMap, Map<String, Long> entityFieldIdsRel) {
        List distinct = allDataEntitys.stream().distinct().collect(Collectors.toList());
        for (DataEntity allDataEntity : distinct) {
            List<DataProperty> columns = allDataEntity.getColumns();
            String tableName = allDataEntity.getName();
            List<DataProperty> collect = columns.stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                collect.forEach(res -> {
                    String columName = res.getName();
                    if (entityFieldIdsRel.containsKey(tableName + "&" + columName)) {
                        log.info("tableName:{},key:==>{}", (Object)tableName, (Object)(tableName + "&" + columName));
                    } else {
                        entityFieldIdsRel.put(tableName + "&" + columName, IdUtil.getId());
                    }
                });
            }
            List<String> itemDataEntityTypeNames = allDataEntity.getItemDataEntityTypeNames();
            DataEntity dataEntity = entityMap.get(allDataEntity.getName());
            if (CollectionUtils.isNotEmpty(itemDataEntityTypeNames)) {
                if (ObjectUtils.isEmpty((Object)dataEntity.getId())) {
                    dataEntity.setId(IdUtil.getId());
                }
                for (String itemDataEntityTypeName : itemDataEntityTypeNames) {
                    DataEntity child = entityMap.get(itemDataEntityTypeName);
                    if (ObjectUtils.isEmpty((Object)child.getParentId())) {
                        child.setParentId(dataEntity.getId());
                    }
                    if (!ObjectUtils.isEmpty((Object)child.getId())) continue;
                    child.setId(IdUtil.getId());
                }
                continue;
            }
            if (!ObjectUtils.isEmpty((Object)dataEntity.getId())) continue;
            allDataEntity.setId(IdUtil.getId());
        }
    }

    private static void entity(E10ExecuteContext context, DataEntity dataEntity, Map<String, Long> entityIdsRel, Map<String, Long> businessObjectsRel, List<SclEntity> sclEntities) {
        SclEntity sclEntity = new SclEntity();
        sclEntity.setId(dataEntity.getId());
        entityIdsRel.put(ObjectUtils.isEmpty((Object)dataEntity.getAlias()) ? dataEntity.getName() : dataEntity.getAlias(), sclEntity.getId());
        sclEntity.setProductVersionId(context.getSclProductVersion().getId());
        sclEntity.setName(ObjectUtils.isEmpty((Object)dataEntity.getAlias()) ? dataEntity.getName() : dataEntity.getAlias());
        if (!ObjectUtils.isEmpty((Object)dataEntity.getDisplayName())) {
            sclEntity.setDisplayName(dataEntity.getDisplayName());
        } else {
            sclEntity.setDisplayName(dataEntity.getName());
        }
        sclEntity.setDescription(dataEntity.getDescription());
        Long parentId = dataEntity.getParentId();
        sclEntity.setParentId(Long.valueOf(parentId == null ? 0L : parentId));
        sclEntity.setBusinessObjectId(businessObjectsRel.get(dataEntity.getBusinessCode()));
        sclEntities.add(sclEntity);
    }

    private static void columns(E10ExecuteContext context, DataEntity dataEntity, List<DataProperty> columns, Map<String, DataEntity> entityMap, Map<String, Long> dicCodeIdRel, Map<String, Long> entityFieldIdsRel, List<SclEntityField> entityFields) {
        if (CollectionUtils.isNotEmpty(columns)) {
            List list = columns.stream().filter(res -> !"CollectionProperty".equals(res.getPropertyType())).collect(Collectors.toList());
            List complexProperty = columns.stream().filter(res -> "ComplexProperty".equals(res.getPropertyType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(complexProperty)) {
                DataEntity dataEntity1 = entityMap.get("ReferToEntity");
                ArrayList<DataProperty> refCol = new ArrayList<DataProperty>();
                for (DataProperty dataProperty : complexProperty) {
                    for (DataProperty referToEntityColumn : dataEntity1.getColumns()) {
                        String columName = (ObjectUtils.isEmpty((Object)dataProperty.getAlias()) ? dataProperty.getName() : dataProperty.getAlias()) + "_" + referToEntityColumn.getName();
                        DataProperty dataProperty1 = new DataProperty();
                        BeanUtils.copyProperties((Object)referToEntityColumn, (Object)dataProperty1);
                        dataProperty1.setAlias(columName);
                        String tableName = dataEntity.getName();
                        entityFieldIdsRel.put(tableName + "&" + referToEntityColumn.getName(), IdUtil.getId());
                        refCol.add(dataProperty1);
                    }
                }
                list.removeIf(res -> "ComplexProperty".equals(res.getPropertyType()));
                list.addAll(refCol);
            }
            List columList = list.stream().distinct().collect(Collectors.toList());
            for (DataProperty column : columList) {
                Long id = entityFieldIdsRel.get(dataEntity.getName() + "&" + column.getName());
                SclEntityField sclEntityField = new SclEntityField();
                sclEntityField.setEntityId(dataEntity.getId());
                sclEntityField.setId(id);
                sclEntityField.setProductVersionId(context.getSclProductVersion().getId());
                sclEntityField.setName(ObjectUtils.isEmpty((Object)column.getAlias()) ? column.getName() : column.getAlias());
                sclEntityField.setDisplayName(ObjectUtils.isEmpty((Object)column.getDisplayName()) ? column.getName() : column.getDisplayName());
                sclEntityField.setDescription(column.getDescription());
                sclEntityField.setDataType(ObjectUtils.isEmpty((Object)column.getDbType()) ? "String" : column.getDbType());
                sclEntityField.setDefaultValue(column.getDefaultValue());
                sclEntityField.setDigit(column.getScale());
                String primaryKey = dataEntity.getPrimaryKey();
                if (!ObjectUtils.isEmpty((Object)primaryKey) && primaryKey.equals(column.getAlias())) {
                    sclEntityField.setIsPrimaryKey(Boolean.valueOf(true));
                } else {
                    sclEntityField.setIsPrimaryKey(Boolean.valueOf(false));
                }
                sclEntityField.setDictId(dicCodeIdRel.get(column.getPickListType()));
                DataPropertyLogicalFk logicalFk = column.getLogicalFk();
                if (!ObjectUtils.isEmpty((Object)logicalFk)) {
                    sclEntityField.setRelationFieldId(entityFieldIdsRel.get(logicalFk.getTableName() + "_" + logicalFk.getColumnName()));
                }
                sclEntityField.setLength(column.getSize());
                entityFields.add(sclEntityField);
            }
        }
    }

    public Integer stepIndex() {
        return 5;
    }

    public String desc() {
        return "\u5b9e\u4f53";
    }
}

