/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclModule;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProduct;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductVersionMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.module.ModuleTypeKeyMappingParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.module.dto.Item;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.module.dto.MappingInfo;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.module.dto.Module;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.module.dto.ModuleTypeKeyMappingInfo;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.uitl.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10ModuleObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10ModuleObjectServiceImpl.class);
    @Autowired
    private SclModuleMapper sclModuleMapper;
    @Autowired
    private SclProductMapper sclProductMapper;
    @Autowired
    private SclProductVersionMapper sclProductVersionMapper;
    @Autowired
    private E10Properties e10Properties;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.MODULE;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        String name = generateRequestDTO.getProductNo();
        String version = generateRequestDTO.getVersion();
        SclProduct sclProduct = this.sclProductMapper.selectByName(name);
        if (sclProduct == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1", name));
        }
        SclProductVersion sclProductVersion = this.sclProductVersionMapper.selectByProductIdAndVersion(sclProduct.getId(), version);
        if (sclProductVersion == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1\u7684\u3010%s\u3011\u7248\u672c", name, version));
        }
        context.setSclProduct(sclProduct);
        context.setSclProductVersion(sclProductVersion);
        String modulePath = this.e10Properties.getModulePath();
        try {
            MappingInfo mappingInfo;
            List<Module> moduleList;
            Optional<MappingInfo> first;
            ModuleTypeKeyMappingInfo moduleTypeKeyMappingInfo = ModuleTypeKeyMappingParser.parser(modulePath);
            List<MappingInfo> mappingInfoList = moduleTypeKeyMappingInfo.getMappingInfoList();
            if (CollectionUtils.isNotEmpty(mappingInfoList) && (first = mappingInfoList.stream().sorted(Comparator.comparing(res -> Integer.valueOf(res.getId().replace("E10_", "").replace(".", "").replace("_", "")), Comparator.reverseOrder())).findFirst()).isPresent() && !CollectionUtils.isEmpty(moduleList = (mappingInfo = first.get()).getModuleList())) {
                ArrayList sclModuleList = new ArrayList();
                moduleList.forEach(module -> {
                    SclModule sclModule = new SclModule();
                    sclModule.setCode(module.getId());
                    sclModule.setId(IdUtil.getId());
                    sclModule.setName(module.getName());
                    sclModule.setDescription(module.getName());
                    sclModule.setProductVersionId(sclProductVersion.getId());
                    sclModuleList.add(sclModule);
                });
                this.sclModuleMapper.insert(sclModuleList);
                Map<String, List<Item>> moduleItems = moduleList.stream().filter(res -> CollectionUtils.isNotEmpty(res.getItemList())).collect(Collectors.toMap(Module::getId, Module::getItemList, (existingValue, newValue) -> existingValue));
                context.setModuleItems(moduleItems);
                Map<String, Long> moduleRel = sclModuleList.stream().collect(Collectors.toMap(SclModule::getCode, SclModule::getId, (existingValue, newValue) -> existingValue));
                context.setModuleRel(moduleRel);
            }
        }
        catch (JAXBException jaxbException) {
            log.error("\u89e3\u6790\u6a21\u5757\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)jaxbException);
            throw jaxbException;
        }
    }

    public Integer stepIndex() {
        return 1;
    }

    public String desc() {
        return "\u3010\u6a21\u5757\u3011";
    }
}

