/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclDict;
import com.digiwin.athena.ai.generate.tools.db.bo.SclDictItem;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclDictItemMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclDictMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.picklist.PickListParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.picklist.dto.Items;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.picklist.dto.PickListItem;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.picklist.dto.PickListType;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.uitl.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10PickListObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10PickListObjectServiceImpl.class);
    @Autowired
    private E10Properties e10Properties;
    @Autowired
    private SclDictMapper sclDictMapper;
    @Autowired
    private SclDictItemMapper sclDictItemMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.PICK_LIST;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        String metadataElementDir = this.e10Properties.getMetadataElementDir();
        SclProductVersion sclProductVersion = context.getSclProductVersion();
        List<Path> filePathsWithPrefix = FileLister.getFilePathsWithPrefix(metadataElementDir, "PickListType.", 1);
        List<String> files = filePathsWithPrefix.stream().map(Path::toString).collect(Collectors.toList());
        List<PickListType> parser = PickListParser.parser(files);
        ArrayList<SclDict> sclDicts = new ArrayList<SclDict>();
        ArrayList<SclDictItem> sclDictItems = new ArrayList<SclDictItem>();
        HashMap<String, Long> dicCodeIdRel = new HashMap<String, Long>();
        for (PickListType pickListType : parser) {
            List<PickListItem> pickListItems;
            SclDict sclDict = new SclDict();
            sclDict.setCode(pickListType.getName());
            Long dictId = IdUtil.getId();
            sclDict.setId(dictId);
            dicCodeIdRel.put(pickListType.getName(), dictId);
            sclDict.setName(pickListType.getDisplayName());
            sclDict.setDescription(pickListType.getDescription());
            sclDict.setProductVersionId(sclProductVersion.getId());
            sclDicts.add(sclDict);
            Items items = pickListType.getItems();
            if (null == items || !CollectionUtils.isNotEmpty(pickListItems = items.getPickListItems())) continue;
            for (PickListItem pickListItem : pickListItems) {
                SclDictItem sclDictItem = new SclDictItem();
                sclDictItem.setId(IdUtil.getId());
                sclDictItem.setDictId(dictId);
                sclDictItem.setProductVersionId(context.getSclProductVersion().getId());
                sclDictItem.setName(ObjectUtils.isEmpty((Object)pickListItem.getDisplayName()) ? pickListItem.getId() : pickListItem.getDisplayName());
                sclDictItem.setCode(pickListItem.getId());
                sclDictItem.setDescription(pickListItem.getDisplayName());
                sclDictItem.setSortNum(Integer.valueOf(pickListItem.getSequence()));
                sclDictItems.add(sclDictItem);
            }
        }
        if (CollectionUtils.isNotEmpty(sclDicts)) {
            this.sclDictMapper.insert(sclDicts);
        }
        if (CollectionUtils.isNotEmpty(sclDictItems)) {
            this.sclDictItemMapper.insert(sclDictItems);
        }
        context.setDicCodeIdRel(dicCodeIdRel);
    }

    public Integer stepIndex() {
        return 2;
    }

    public String desc() {
        return "\u3010\u5b57\u5178\u3011";
    }
}

