/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclQueryCase;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclQueryCaseMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.SqlParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.SqlResult;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.covert.SqlResultQueryCaseMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.uitl.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class E10QueryEntityServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10QueryEntityServiceImpl.class);
    @Autowired
    private E10Properties e10Properties;
    @Autowired
    private SclQueryCaseMapper sclQueryCaseMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.QUERY_ENTITY;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        try {
            SqlParser sqlParser = new SqlParser(context.getEntityMap(), context.getDicPropertyMap());
            List<Path> pathList = FileLister.getFilePathsWithFileName(this.e10Properties.getQueryBusinessObjectsRoot(), "QueryProjectContainer.dcxml");
            for (Path p : pathList) {
                sqlParser.parseXmlToSql(p);
            }
            List<SqlResult> sqlResults = sqlParser.getSqlResults();
            Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
            List<SqlResult> filteredResults = sqlResults.stream().filter(sqlResult -> StringUtils.hasText((String)sqlResult.getSqlExample()) && sqlResult.getIsExecutionSuccess() != false).peek(sqlResult -> {
                sqlResult.setId(IdUtil.getId());
                sqlResult.setBusinessObjectId((Long)businessObjectsRel.get(sqlResult.getBusinessCode()));
                sqlResult.setProductVersionId(context.getSclProductVersion().getId());
            }).collect(Collectors.toList());
            List<SclQueryCase> sclQueryCaseList = SqlResultQueryCaseMapper.INSTANCE.to(filteredResults);
            this.sclQueryCaseMapper.insert(sclQueryCaseList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Integer stepIndex() {
        return 6;
    }

    public String desc() {
        return "\u67e5\u8be2\u65b9\u6848";
    }
}

