/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.util;

import com.digiwin.athena.ai.generate.tools.e10.filter.NamespaceFilter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JAXBParserXMLUtil {
    public static <T> List<T> parser(List<String> xmlFile, Class<T> clazz) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ArrayList<Object> list = new ArrayList<Object>();
            for (String file : xmlFile) {
                System.out.println(file);
                Object t = unmarshaller.unmarshal(new File(file));
                list.add(t);
            }
            return list;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> containsNamespaceParser(List<String> xmlFile, Class<T> clazz, String namespace) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            NamespaceFilter filter = new NamespaceFilter(namespace);
            filter.setParent(reader);
            ArrayList<Object> list = new ArrayList<Object>();
            for (String path : xmlFile) {
                try (FileInputStream inputStream = new FileInputStream(new File(path));){
                    InputSource source = new InputSource(inputStream);
                    SAXSource saxSource = new SAXSource(filter, source);
                    Object t = unmarshaller.unmarshal((Source)saxSource);
                    list.add(t);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return list;
        }
        catch (JAXBException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T containsNamespaceParser(JAXBContext context, XMLReader reader, String xmlFile, Class<T> clazz, String namespace) throws JAXBException {
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            NamespaceFilter filter = new NamespaceFilter(namespace);
            filter.setParent(reader);
            try (FileInputStream inputStream = new FileInputStream(xmlFile);){
                Object t;
                InputSource source = new InputSource(inputStream);
                SAXSource saxSource = new SAXSource(filter, source);
                Object object = t = unmarshaller.unmarshal((Source)saxSource);
                return (T)object;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

