/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.util;

import com.digiwin.athena.ai.generate.tools.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathResolverUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonPathResolverUtil.class);
    private static final String ACTIVE_OBJECT_PREFIX = "ActiveObject";
    private static final String RL_PREFIX = "RL_";
    private static final String PARENT_KEYWORD = "Parent";
    private static final String DOT = "\\.";
    private static final String DOT_SEPARATOR = ".";

    public static String resolve(String path, String str) {
        log.debug("path:{}    str:{}", (Object)path, (Object)str);
        if (!str.startsWith(ACTIVE_OBJECT_PREFIX)) {
            throw new BusinessException("\u5b57\u7b26\u4e32\u5fc5\u987b\u4ee5'ActiveObject'\u5f00\u5934");
        }
        String result = JsonPathResolverUtil.handleNormalCase(path, str.split(DOT));
        result = JsonPathResolverUtil.handleRlPrefixCase(result.split(DOT));
        log.debug("result:{}", (Object)result);
        return result;
    }

    private static String handleRlPrefixCase(String[] parts) {
        ArrayList<String> pathParts = new ArrayList<String>();
        for (String part : parts) {
            if (part.startsWith(RL_PREFIX)) {
                pathParts.add(part);
                break;
            }
            pathParts.add(part);
        }
        return String.join((CharSequence)DOT_SEPARATOR, pathParts);
    }

    private static String handleNormalCase(String path, String[] parts) {
        ArrayList<String> pathParts = new ArrayList<String>();
        if (path != null && !path.trim().isEmpty()) {
            pathParts.addAll(Arrays.asList(path.split(DOT)));
        }
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            if (PARENT_KEYWORD.equals(part)) {
                if (pathParts.isEmpty()) continue;
                pathParts.removeLast();
                continue;
            }
            pathParts.add(part);
        }
        return String.join((CharSequence)DOT_SEPARATOR, pathParts);
    }

    public static void main(String[] args) {
        JsonPathResolverUtil.resolve("detail.sub_detail", "ActiveObject.name");
        JsonPathResolverUtil.resolve("detail.sub_detail", "ActiveObject.Parent.id");
        JsonPathResolverUtil.resolve("detail.sub_detail", "ActiveObject.Parent.Parent.code");
        JsonPathResolverUtil.resolve("detail", "ActiveObject.sub_detail");
        JsonPathResolverUtil.resolve("", "ActiveObject.code");
        JsonPathResolverUtil.resolve("", "ActiveObject.RL_SupplierPurchase_03.TAX ID");
        JsonPathResolverUtil.resolve("", "ActiveObject.RL_SupplierPurchase_03.TAX MODE");
        JsonPathResolverUtil.resolve("detail", "ActiveObject.RL_SupplierPurchase_03.TAX MODE");
        JsonPathResolverUtil.resolve("", ACTIVE_OBJECT_PREFIX);
        JsonPathResolverUtil.resolve("a.b.c.d", "ActiveObject.Parent.Parent.e");
    }
}

