/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.event;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.constant.FunctionRuleTypeEnum;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.FunctionRuleEvent;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.E10FunctionRuleServiceImpl;
import com.digiwin.athena.ai.generate.tools.util.ConfigUtils;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class FunctionRuleEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionRuleEventListener.class);
    private final E10FunctionRuleServiceImpl e10FunctionRuleService;

    public FunctionRuleEventListener(E10FunctionRuleServiceImpl e10FunctionRuleService) {
        this.e10FunctionRuleService = e10FunctionRuleService;
    }

    @Async(value="virtualThreadTaskExecutor")
    @EventListener
    public void handleTimeConsumingEvent(FunctionRuleEvent event) {
        if (!ConfigUtils.getBoolean((String)"e10.functionRule.covertSwitch", (Boolean)false).booleanValue()) {
            log.info("\u8f6c\u6362\u4efb\u52a1\u5f00\u5173\u672a\u5f00\u542f");
            return;
        }
        long startTime = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u5904\u7406\u8017\u65f6\u4efb\u52a1\uff0c\u4efb\u52a1ID: {}", (Object)event.getTaskId());
        try {
            Map params = (Map)event.getParams();
            Long productVersionId = MapUtils.getLong((Map)params, (Object)"productVersionId");
            String code = MapUtils.getString((Map)params, (Object)"code");
            this.e10FunctionRuleService.doFunctionRuleCovert(productVersionId, code, FunctionRuleTypeEnum.FORMULA.getType());
            this.e10FunctionRuleService.doFunctionRuleCovert(productVersionId, code, FunctionRuleTypeEnum.VALIDATE.getType());
            long endTime = System.currentTimeMillis();
            log.info("\u8017\u65f6\u4efb\u52a1\u5904\u7406\u5b8c\u6210\uff0c\u4efb\u52a1ID: {}, \u5904\u7406\u65f6\u95f4: {}ms", (Object)event.getTaskId(), (Object)(endTime - startTime));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u8017\u65f6\u4efb\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u4efb\u52a1ID: {}", (Object)event.getTaskId(), (Object)e);
        }
    }
}

