/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataPropertyLogicalFk;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ForeignExtract {
    public void extractForeignKeys(List<DataEntity> entities, Map<String, DataEntity> interfaceEntityMap) {
        entities.forEach(entity -> {
            List<String> itemDataEntityTypeNames = entity.getItemDataEntityTypeNames();
            if (!CollectionUtils.isEmpty(itemDataEntityTypeNames)) {
                itemDataEntityTypeNames.forEach(entityName -> {
                    List<DataProperty> properties;
                    DataEntity entity1 = (DataEntity)interfaceEntityMap.get(entityName);
                    if (entity1 != null && !CollectionUtils.isEmpty(properties = entity1.getColumns())) {
                        try {
                            DataProperty dataProperty1 = entity.getColumns().stream().filter(res -> res.getName().equals(entity.getPrimaryKey())).findFirst().get();
                            dataProperty1.setDbType("Guid");
                            DataPropertyLogicalFk dataPropertyLogicalFk = new DataPropertyLogicalFk();
                            dataPropertyLogicalFk.setTableName(entity.getName());
                            dataPropertyLogicalFk.setColumnName(entity.getPrimaryKey());
                            dataPropertyLogicalFk.setComment("\u5173\u8054\u8868:" + entity.getName());
                            dataProperty1.setLogicalFk(dataPropertyLogicalFk);
                            properties.add(dataProperty1);
                        }
                        catch (Exception e) {
                            System.out.println("entity" + entity.getName() + ":" + entity.getBusinessCode());
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    public void extractFeference2Fk(List<DataEntity> entities, Map<String, DataEntity> entityMap) {
        entities.forEach(entity -> {
            List<DataProperty> columns = entity.getColumns();
            columns.forEach(prp -> {
                String referenceToName = prp.getReferenceToName();
                if (!StringUtils.isEmpty((Object)referenceToName)) {
                    DataPropertyLogicalFk logicalFk = new DataPropertyLogicalFk();
                    DataEntity fkEntity = (DataEntity)entityMap.get(referenceToName);
                    if (fkEntity != null) {
                        List<DataProperty> fkEntityColumns = fkEntity.getColumns();
                        boolean matched = false;
                        for (DataProperty e : fkEntityColumns) {
                            if (!e.getName().equals(prp.getName())) continue;
                            logicalFk.setColumnName(e.getAlias());
                            prp.setDescription(fkEntity.getDisplayName());
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            logicalFk.setColumnName(prp.getReferenceToNameProperty());
                        }
                    } else {
                        logicalFk.setColumnName(prp.getReferenceToNameProperty());
                    }
                    String lastPart = ForeignExtract.getLastPart(referenceToName);
                    logicalFk.setComment("\u5173\u8054\u8868:" + lastPart);
                    logicalFk.setTableName(lastPart);
                    prp.setLogicalFk(logicalFk);
                }
            });
        });
    }

    public static String getLastPart(String tableName) {
        if (tableName == null || !tableName.contains(".")) {
            return tableName;
        }
        return tableName.substring(tableName.lastIndexOf(46) + 1);
    }
}

