/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata;

import cn.hutool.core.lang.Tuple;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.util.XmlUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.ForeignExtract;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DicProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.utils.DicPropertyUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.utils.DocExtract;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.utils.NamespaceContextMap;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MetadataParser {
    private E10Properties e10Properties;
    private final Map<String, Map<String, DataEntity>> parsedFiles = new ConcurrentHashMap<String, Map<String, DataEntity>>();
    private final Map<String, Collection<DataProperty>> functionPackageCache = new ConcurrentHashMap<String, Collection<DataProperty>>();
    private final Map<String, Collection<DataProperty>> featureEntityCache = new ConcurrentHashMap<String, Collection<DataProperty>>();
    private final ThreadLocal<Set<String>> parsingStack = ThreadLocal.withInitial(HashSet::new);
    private final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private final XPathFactory xpf = XPathFactory.newInstance();
    private final Map<String, DataProperty> complexPropertyMap = new HashMap<String, DataProperty>();
    private final Map<String, DataEntity> entityMap = new HashMap<String, DataEntity>();
    private final Map<String, DataEntity> interfaceEntityMap = new HashMap<String, DataEntity>();
    private final Map<String, List<String>> interfaceReferencesMap = new HashMap<String, List<String>>();
    private final List<DataEntity> allDataEntitys = new ArrayList<DataEntity>();
    private final Map<String, List<DicProperty>> dicPropertyMap = new HashMap<String, List<DicProperty>>();
    private static final String MISS_DATA_ENTIRY_URL = "v8/BusinessObjects";
    private static final String MISS_METADATA_CONTAINER_ELEMENT_URL = "v8/BusinessObjects/MetadataContainerElement";

    public MetadataParser(E10Properties e10Properties) {
        this.e10Properties = e10Properties;
    }

    public List<DataEntity> parseAllEntities() {
        ArrayList<DataEntity> entities = new ArrayList<DataEntity>();
        this.fillMissDataEntiry(entities);
        this.scanDirectory(Paths.get(this.e10Properties.getBusinessObjectsRoot(), new String[0]).toFile(), entities);
        entities.forEach(res -> res.getColumns().forEach(property -> {
            try {
                this.parseReferenceToName((DataProperty)property);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        this.initReferToEntity(entities);
        if (this.e10Properties.getEntityStepIsParseDict().booleanValue()) {
            this.dicPropertyMap.putAll(DicPropertyUtil.parsePickListTypes(this.e10Properties.getMetadataElementDir()));
        }
        this.allDataEntitys.addAll(entities);
        for (DataEntity e : entities) {
            this.entityMap.put(e.getName(), e);
        }
        return entities;
    }

    private void fillMissDataEntiry(List<DataEntity> entities) {
        URL resource = MetadataParser.getBusinessObjectsUrl();
        File dir = new File(resource.getFile());
        this.scanDirectory(dir, entities);
    }

    public List<DataEntity> parseEntity(String entityName) {
        ArrayList<DataEntity> entities = new ArrayList<DataEntity>();
        this.scanDirectory(this.e10Properties.getBusinessObjectsRoot(), entityName, entities);
        entities.forEach(res -> res.getColumns().forEach(property -> {
            try {
                this.parseReferenceToName((DataProperty)property);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        this.initReferToEntity(entities);
        if (this.e10Properties.getEntityStepIsParseDict().booleanValue()) {
            this.dicPropertyMap.putAll(DicPropertyUtil.parsePickListTypes(this.e10Properties.getMetadataElementDir()));
        }
        this.allDataEntitys.addAll(entities);
        for (DataEntity e : entities) {
            this.entityMap.put(e.getName(), e);
        }
        return entities;
    }

    public void parseAllDataEntityTypes() {
        List<Path> paths = FileLister.getFilePathsWithPrefix(this.e10Properties.getMetadataElementDir(), "DataEntityType.");
        MetadataParser.fillDataEntityType(paths);
        for (Path path : paths) {
            File file = path.toFile();
            try {
                List<DataEntity> parsed = this.parseFile(file, null, "DataEntityType");
                for (DataEntity e : parsed) {
                    this.interfaceEntityMap.put(e.getName(), e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("[WARN] Failed to parse DataEntityType: " + file.getName() + " => " + e.getMessage());
            }
        }
    }

    private static void fillDataEntityType(List<Path> paths) {
        try {
            List<Path> otherPaths = FileLister.getFilePathsWithPrefix(Paths.get(MetadataParser.getMetadataContainerElementUrl().toURI()), "DataEntityType.");
            paths.addAll(otherPaths);
        }
        catch (Exception e) {
            System.err.println("\u6dfb\u52a0\u989d\u5916\u7684DataEntityType\u6587\u4ef6\u5931\u8d25");
        }
    }

    private void scanDirectory(File dir, List<DataEntity> entities) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.scanDirectory(file, entities);
                continue;
            }
            if (!"MetadataContainer.dcxml".equalsIgnoreCase(file.getName())) continue;
            try {
                List<DataEntity> dataEntities = this.parseFile(file, null, "MetadataContainer");
                if (CollectionUtils.isNotEmpty(dataEntities)) {
                    List collect = dataEntities.stream().filter(entity -> !ObjectUtils.isEmpty(entity.getColumns())).flatMap(entity -> entity.getColumns().stream()).filter(dataProperty -> "CollectionProperty".equals(dataProperty.getPropertyType())).collect(Collectors.toList());
                    Map<Object, Object> map = new HashMap();
                    if (CollectionUtils.isNotEmpty(collect)) {
                        map = collect.stream().collect(Collectors.groupingBy(DataProperty::getItemDataEntityTypeName));
                    }
                    for (DataEntity dataEntity : dataEntities) {
                        dataEntity.setBindingCollectionProperty((List)map.get(dataEntity.getName()));
                    }
                }
                entities.addAll(dataEntities);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("[WARN] Failed to parse file: " + file.getAbsolutePath());
            }
        }
    }

    private void scanDirectory(String dir, String subDir, List<DataEntity> entities) {
        List<Path> paths = FileLister.getFilePathsWithFileName(dir, subDir, "MetadataContainer.dcxml");
        for (Path path : paths) {
            File file = path.toFile();
            try {
                entities.addAll(this.parseFile(file, null, "MetadataContainer"));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("[WARN] Failed to parse file: " + file.getAbsolutePath());
            }
        }
    }

    public Map<String, Collection<DataProperty>> scanFunctionParse(File rootDir) {
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            System.err.println("\u76ee\u5f55\u4e0d\u5b58\u5728: " + rootDir.getAbsolutePath());
            return Collections.emptyMap();
        }
        HashMap<String, Collection<DataProperty>> map = new HashMap<String, Collection<DataProperty>>();
        File[] entityDirs = rootDir.listFiles(File::isDirectory);
        if (entityDirs == null) {
            return map;
        }
        for (File entityDir : entityDirs) {
            File metadataFile = new File(entityDir, "MetadataContainer.dcxml");
            File functionFile = new File(entityDir, "Server.FunctionPackage.dcxml");
            if (!metadataFile.exists() || !functionFile.exists()) continue;
            String entityName = entityDir.getName();
            ArrayList<String> disableFeatureEntity = new ArrayList<String>();
            Collection<DataProperty> props = this.parseFunctionPackageCached(disableFeatureEntity, entityName, functionFile, null);
            this.applyPath(metadataFile, props, map);
        }
        return map;
    }

    private void applyPath(File metadataFile, Collection<DataProperty> props, Map<String, Collection<DataProperty>> map) {
        Map<String, DataEntity> stringDataEntityMap = this.parsedFiles.get(metadataFile.getAbsolutePath().toLowerCase());
        if (MapUtils.isNotEmpty(stringDataEntityMap)) {
            block8: for (String name : stringDataEntityMap.keySet()) {
                String dataEntityTypeType;
                if (!CollectionUtils.isNotEmpty(props)) continue;
                Map<String, List<DataProperty>> collect = props.stream().collect(Collectors.groupingBy(DataProperty::getApplyPath));
                DataEntity dataEntity = this.getEntityMap().get(name);
                switch (dataEntityTypeType = dataEntity.getDataEntityTypeType()) {
                    case "Root": {
                        map.put(name, props);
                        continue block8;
                    }
                    case "CollectionItem": {
                        map.put(name, ObjectUtils.isEmpty(collect.get("All")) ? (Collection)collect.get("ALL") : (Collection)collect.get("All"));
                        continue block8;
                    }
                }
                map.put(name, props);
            }
        }
    }

    public Map<String, Collection<DataProperty>> scanSingleFunctionParse(List<Path> paths) {
        HashMap<String, Collection<DataProperty>> map = new HashMap<String, Collection<DataProperty>>();
        for (Path path : paths) {
            File metadataFile = new File(path.toFile().getParentFile(), "MetadataContainer.dcxml");
            File functionFile = new File(path.toFile().getParentFile(), "Server.FunctionPackage.dcxml");
            if (!metadataFile.exists() || !functionFile.exists()) continue;
            String entityName = path.toFile().getParentFile().getName();
            ArrayList<String> disableFeatureEntity = new ArrayList<String>();
            Collection<DataProperty> props = this.parseFunctionPackageCached(disableFeatureEntity, entityName, functionFile, null);
            this.applyPath(metadataFile, props, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DataProperty> parseFunctionPackageCached(List<String> disableFeatureEntity, String entityName, File file, String id) {
        String cacheKey;
        String string = cacheKey = id != null ? "FP#" + id : entityName + file.getName();
        if (this.functionPackageCache.containsKey(cacheKey)) {
            return this.functionPackageCache.get(cacheKey);
        }
        Set<String> stack = this.parsingStack.get();
        if (stack.contains(cacheKey)) {
            System.err.println("[WARN] \u5faa\u73af\u5f15\u7528\u68c0\u6d4b: " + cacheKey);
            return Collections.emptyList();
        }
        stack.add(cacheKey);
        LinkedHashMap<String, DataProperty> propertyMap = new LinkedHashMap<String, DataProperty>();
        try {
            Document doc = this.parseXml(file);
            XPath xpath = this.xpf.newXPath();
            NodeList featureNodes = (NodeList)xpath.evaluate("/*[local-name()='FunctionPackage']/*[local-name()='Items']", doc, XPathConstants.NODESET);
            if (file.getName().equals("Server.FunctionPackage.dcxml")) {
                disableFeatureEntity.addAll(this.getDisableFeatureEntity(xpath, featureNodes));
            }
            this.functionPackageBaseItems(disableFeatureEntity, entityName, xpath, doc, propertyMap);
            this.dcxmlFeatureEntityFunctionPoint(disableFeatureEntity, xpath, propertyMap, featureNodes);
            DataEntity dataEntity = this.entityMap.get(entityName);
            propertyMap.entrySet().removeIf(res -> disableFeatureEntity.contains(((DataProperty)res.getValue()).getFeatureEntity()));
            for (DataProperty value : propertyMap.values()) {
                value.setEntityName(entityName);
                value.setEntityAlias(dataEntity.getAlias());
                value.setEntityPrimaryKey(dataEntity.getPrimaryKey());
                value.setDataEntityTypeType(dataEntity.getDataEntityTypeType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            stack.remove(cacheKey);
        }
        this.functionPackageCache.put(cacheKey, propertyMap.values());
        return propertyMap.values();
    }

    private void functionPackageBaseItems(List<String> disableFeatureEntity, String entityName, XPath xpath, Document doc, Map<String, DataProperty> propertyMap) throws XPathExpressionException {
        NodeList baseItems = (NodeList)xpath.evaluate("/*[local-name()='FunctionPackage']/*[local-name()='BaseItems']", doc, XPathConstants.NODESET);
        for (int j = 0; j < baseItems.getLength(); ++j) {
            Element el = (Element)baseItems.item(j);
            NodeList all = el.getChildNodes();
            for (int i = 0; i < all.getLength(); ++i) {
                String subId;
                String tag;
                Node n = all.item(i);
                if (n.getNodeType() != 1 || !(tag = n.getNodeName()).equals("DcxmlFunctionPackage")) continue;
                Node idNode = (Node)xpath.evaluate("*[local-name()='Id']", (Element)n, XPathConstants.NODE);
                String string = subId = idNode != null ? idNode.getTextContent().trim() : null;
                if (subId == null || subId.isEmpty()) continue;
                Collection<DataProperty> subProps = this.parseFunctionPackageById(disableFeatureEntity, entityName, subId);
                this.mergeProperties(propertyMap, subProps);
            }
        }
    }

    private List<String> getDisableFeatureEntity(XPath xpath, NodeList featureNodes) throws Exception {
        ArrayList<String> disabledFeatureEntity = new ArrayList<String>();
        for (int j = 0; j < featureNodes.getLength(); ++j) {
            Element el = (Element)featureNodes.item(j);
            NodeList all = el.getChildNodes();
            for (int i = 0; i < all.getLength(); ++i) {
                String featureEntity;
                String tag;
                Node n = all.item(i);
                if (n.getNodeType() != 1 || !(tag = n.getNodeName()).equals("DcxmlFeatureEntityFunctionPoint")) continue;
                Node behaviorNode = (Node)xpath.evaluate("*[local-name()='Behavior']", (Element)n, XPathConstants.NODE);
                String behavior = behaviorNode != null ? behaviorNode.getTextContent().trim() : null;
                Node idNode = (Node)xpath.evaluate("*[local-name()='FeatureEntity']", (Element)n, XPathConstants.NODE);
                String string = featureEntity = idNode != null ? idNode.getTextContent().trim() : null;
                if (!"Disabled".equals(behavior) || featureEntity == null || featureEntity.isEmpty()) continue;
                disabledFeatureEntity.add(featureEntity);
            }
        }
        return disabledFeatureEntity;
    }

    private void dcxmlFeatureEntityFunctionPoint(List<String> disabledFeatureEntity, XPath xpath, Map<String, DataProperty> propertyMap, NodeList featureNodes) throws Exception {
        for (int j = 0; j < featureNodes.getLength(); ++j) {
            Element el = (Element)featureNodes.item(j);
            NodeList all = el.getChildNodes();
            for (int i = 0; i < all.getLength(); ++i) {
                String applyPath;
                String featureEntity;
                String tag;
                Node n = all.item(i);
                if (n.getNodeType() != 1 || !(tag = n.getNodeName()).equals("DcxmlFeatureEntityFunctionPoint")) continue;
                Node behaviorNode = (Node)xpath.evaluate("*[local-name()='Behavior']", (Element)n, XPathConstants.NODE);
                String behavior = behaviorNode != null ? behaviorNode.getTextContent().trim() : null;
                Node idNode = (Node)xpath.evaluate("*[local-name()='FeatureEntity']", (Element)n, XPathConstants.NODE);
                String string = featureEntity = idNode != null ? idNode.getTextContent().trim() : null;
                if ("Disabled".equals(behavior) || disabledFeatureEntity.contains(featureEntity)) continue;
                Node applyPathNode = (Node)xpath.evaluate("*[local-name()='ApplyPath']", (Element)n, XPathConstants.NODE);
                String string2 = applyPath = applyPathNode != null ? applyPathNode.getTextContent().trim() : "All";
                if (featureEntity == null || featureEntity.isEmpty()) continue;
                Collection<DataProperty> featureProps = this.parseFeatureEntityByName(featureEntity, applyPath);
                this.mergeProperties(propertyMap, featureProps);
            }
        }
    }

    private Collection<DataProperty> parseFunctionPackageById(List<String> disableFeatureEntity, String entityName, String id) {
        if (this.functionPackageCache.containsKey("FP#" + id)) {
            return this.functionPackageCache.get("FP#" + id);
        }
        File funcFile = Paths.get(this.e10Properties.getFunctionPackageDir(), new String[0]).resolve("FunctionPackage." + id + ".dcxml").toFile();
        if (!funcFile.exists()) {
            System.err.println("[WARN] FunctionPackage \u6587\u4ef6\u4e0d\u5b58\u5728: " + funcFile.getAbsolutePath());
            return Collections.emptyList();
        }
        return this.parseFunctionPackageCached(disableFeatureEntity, entityName, funcFile, id);
    }

    private Collection<DataProperty> parseFeatureEntityByName(String featureEntity, String applyPath) throws Exception {
        if (this.featureEntityCache.containsKey(featureEntity)) {
            return this.featureEntityCache.get(featureEntity);
        }
        String FEATURE_ENTITY_DIR = Paths.get(this.e10Properties.getMetadataElementDir(), new String[0]).toAbsolutePath().toString();
        File featureFile = Paths.get(FEATURE_ENTITY_DIR, "DataEntityType." + featureEntity + ".dcxml").toFile();
        if (!featureFile.exists() && !(featureFile = Paths.get(MetadataParser.getMetadataContainerElementUrl().toURI()).resolve("DataEntityType." + featureEntity + ".dcxml").toFile()).exists()) {
            System.err.println("[WARN] FeatureEntity \u6587\u4ef6\u4e0d\u5b58\u5728: " + featureFile.getAbsolutePath());
            return Collections.emptyList();
        }
        LinkedHashMap<String, DataProperty> map = new LinkedHashMap<String, DataProperty>();
        try {
            Document doc = this.parseXml(featureFile);
            XPath xpath = this.xpf.newXPath();
            xpath.setNamespaceContext(new NamespaceContextMap("ns", "http://schemas.dcms.com/configuration/DataEntityTypeElement"));
            Node propertiesNode = (Node)xpath.evaluate("/ns:DataEntityType/ns:Properties", doc, XPathConstants.NODE);
            if (propertiesNode != null && propertiesNode.hasChildNodes()) {
                NodeList children = propertiesNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node n = children.item(i);
                    if (n.getNodeType() != 1) continue;
                    DataProperty p = new DataProperty();
                    p.setName(this.text(n, "Name"));
                    p.setDisplayName(this.text(n, "DisplayName"));
                    p.setDescription(this.text(n, "Description"));
                    p.setAlias(this.text(n, "Alias"));
                    p.setAutoSync(this.text(n, "AutoSync"));
                    p.setDbType(this.text(n, "DbType"));
                    p.setIgnoreUpdate(this.text(n, "IgnoreUpdate"));
                    p.setDefaultValue(this.text(n, "DefaultValue"));
                    p.setBusinessTypeName(this.text(n, "BusinessTypeName"));
                    p.setReferenceToName(this.text(n, "ReferenceToName"));
                    p.setFeatureEntity(featureEntity);
                    p.setPropertyType(n.getNodeName());
                    p.setIsUnique(this.getText((Element)n, "IsUnique"));
                    p.setIsNullable(this.getText((Element)n, "IsNullable"));
                    p.setApplyPath(applyPath);
                    String size = this.text(n, "Size");
                    String scale = this.text(n, "Scale");
                    if (!StringUtils.isEmpty((Object)size)) {
                        p.setSize(Integer.valueOf(size));
                    }
                    if (!StringUtils.isEmpty((Object)scale)) {
                        p.setScale(Integer.valueOf(scale));
                    }
                    map.put(p.getName(), p);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.featureEntityCache.put(featureEntity, map.values());
        return map.values();
    }

    private void mergeProperties(Map<String, DataProperty> target, Collection<DataProperty> source) {
        if (source == null) {
            return;
        }
        for (DataProperty p : source) {
            target.putIfAbsent(p.getName(), p);
        }
    }

    private List<DataEntity> parseFile(File xmlFile, String dataEntityType, String mode) throws Exception {
        NodeList nodes;
        ArrayList<DataEntity> result = new ArrayList<DataEntity>();
        if (!xmlFile.exists()) {
            return result;
        }
        String pathKey = xmlFile.getAbsolutePath().toLowerCase();
        if (this.parsedFiles.containsKey(pathKey)) {
            result.addAll(this.parsedFiles.get(pathKey).values());
            return result;
        }
        this.parsedFiles.put(pathKey, new HashMap());
        Document doc = this.parseXml(xmlFile);
        XPath xpath = this.xpf.newXPath();
        if ("MetadataContainer".equals(mode)) {
            xpath.setNamespaceContext(new NamespaceContextMap("ns", "http://schemas.dcms.com/configuration/MetadataContainerElement"));
            nodes = (NodeList)xpath.evaluate("/ns:MetadataContainer/ns:DataEntityTypes/ns:DataEntityType", doc, XPathConstants.NODESET);
        } else {
            xpath.setNamespaceContext(new NamespaceContextMap("ns", "http://schemas.dcms.com/configuration/DataEntityTypeElement"));
            nodes = (NodeList)xpath.evaluate("/ns:DataEntityType", doc, XPathConstants.NODESET);
        }
        HashMap<String, DataEntity> tempMap = new HashMap<String, DataEntity>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element el = (Element)nodes.item(i);
            DataEntity entity = this.parseEntity(el, xpath, dataEntityType);
            if ("MetadataContainer".equals(mode)) {
                entity.setBusinessCode(xmlFile.getParentFile().getName());
                entity.setAlias(this.getText(el, "Alias"));
                entity.setDescription(this.getText(el, "Description"));
            }
            if (entity == null) continue;
            result.add(entity);
            tempMap.put(entity.getName(), entity);
        }
        this.parsedFiles.put(pathKey, tempMap);
        return result;
    }

    public String getText(Element el, String tagName) {
        NodeList childNodes = el.getChildNodes();
        String value = null;
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() != 1 || !tagName.equals(childNode.getNodeName())) continue;
            value = childNode.getTextContent().trim();
            break;
        }
        return value;
    }

    private DataEntity parseEntity(Element el, XPath xpath, String dataEntityType) throws Exception {
        Node interfaceNode;
        DataEntity entity = new DataEntity();
        String name = this.text(el, "Name");
        entity.setName(name);
        entity.setDisplayName(this.text(el, "DisplayName"));
        entity.setDescription(this.text(el, "Description"));
        entity.setPrimaryKey(this.text(el, "PrimaryKey"));
        entity.setDomain(this.text(el, "Domain"));
        entity.setDataEntityTypeType(this.text(el, "DataEntityTypeType"));
        entity.setBusinessPrimaryKey(this.text(el, "BusinessPrimaryKey"));
        Node propsNode = (Node)xpath.evaluate("ns:Properties", el, XPathConstants.NODE);
        if (propsNode != null) {
            List<DataProperty> dataProperties = this.parseProperties(propsNode, entity, null);
            entity.getColumns().addAll(dataProperties);
        }
        if ((interfaceNode = (Node)xpath.evaluate("ns:InterfaceReferences", el, XPathConstants.NODE)) != null) {
            this.parseInterfaceReferences(interfaceNode, entity.getName());
        }
        return entity;
    }

    private static String getTagValue(Element parent, String tagName) {
        NodeList nl = parent.getElementsByTagNameNS("http://schemas.dcms.com/configuration/MetadataContainerElement", tagName);
        if (nl.getLength() > 0) {
            return nl.item(0).getTextContent();
        }
        return "";
    }

    private void parseInterfaceReferences(Node interfaceNode, String entityName) {
        ArrayList<String> refs = new ArrayList<String>();
        NodeList children = interfaceNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String refName;
            Node n = children.item(i);
            if (!"DataEntityTypeReference".equals(n.getNodeName()) || !StringUtils.hasText((String)(refName = this.text(n, "Name")))) continue;
            refs.add(refName);
        }
        this.interfaceReferencesMap.put(entityName, refs);
    }

    private List<DataProperty> parseProperties(Node propsNode, DataEntity entity, Map<String, DataProperty> propertyMap) throws Exception {
        ArrayList<DataProperty> list = new ArrayList<DataProperty>();
        NodeList all = propsNode.getChildNodes();
        String entityName = entity.getName();
        for (int i = 0; i < all.getLength(); ++i) {
            Node n = all.item(i);
            if (n.getNodeType() != 1) continue;
            String tag = n.getNodeName();
            DataProperty p = new DataProperty();
            p.setEntityName(entityName);
            p.setEntityAlias(entity.getAlias());
            p.setEntityPrimaryKey(entity.getPrimaryKey());
            p.setDataEntityTypeType(entity.getDataEntityTypeType());
            p.setName(this.text(n, "Name"));
            p.setAlias(this.text(n, "Alias"));
            String displayName = this.text(n, "DisplayName");
            String description = this.text(n, "Description");
            p.setDisplayName(StringUtils.isEmpty((Object)displayName) ? description : displayName);
            p.setDescription(StringUtils.isEmpty((Object)description) ? displayName : description);
            p.setAlias(this.text(n, "Alias"));
            p.setDataEntityTypeName(this.text(n, "DataEntityTypeName"));
            p.setPickListType(this.text(n, "PickListType"));
            p.setDefaultValue(this.text(n, "DefaultValue"));
            p.setAutoSync(this.text(n, "AutoSync"));
            p.setIgnoreUpdate(this.text(n, "IgnoreUpdate"));
            p.setIsSystem(this.text(n, "IsSystem"));
            p.setDbType(this.text(n, "DbType"));
            p.setIsUnique(this.getText((Element)n, "IsUnique"));
            p.setIsNullable(this.getText((Element)n, "IsNullable"));
            String sizeStr = this.text(n, "Size");
            if (StringUtils.hasText((String)sizeStr)) {
                try {
                    p.setSize(Integer.valueOf(sizeStr));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            switch (tag) {
                case "SimpleProperty": {
                    this.handleSimpleProperty(n, p);
                    break;
                }
                case "ReferenceProperty": {
                    this.handleReferenceProperty(n, p);
                    break;
                }
                case "ComplexProperty": {
                    this.handleComplexProperty(n, p, entityName, list, propertyMap);
                    break;
                }
                case "CollectionProperty": {
                    this.handleCollectionProperty(n, p, entity, list, propertyMap);
                }
            }
            list.add(p);
        }
        return list;
    }

    private void handleCollectionProperty(Node n, DataProperty p, DataEntity entity, List<DataProperty> list, Map<String, DataProperty> propertyMap) {
        List<String> itemDataEntityTypeNames = entity.getItemDataEntityTypeNames();
        String itemDataEntityTypeName = this.text(n, "ItemDataEntityTypeName");
        p.setPropertyType("CollectionProperty");
        if (!StringUtils.isEmpty((Object)itemDataEntityTypeName)) {
            p.setItemDataEntityTypeName(itemDataEntityTypeName);
            p.setBusinessTypeName(itemDataEntityTypeName);
            itemDataEntityTypeNames.add(itemDataEntityTypeName);
        }
    }

    private void handleSimpleProperty(Node n, DataProperty p) throws Exception {
        String referenceToName;
        String pickListType;
        p.setPropertyType("SimpleProperty");
        String businessTypeName = this.text(n, "BusinessTypeName");
        if (StringUtils.hasText((String)businessTypeName)) {
            p.setBusinessTypeName(businessTypeName);
            this.parseBusinessTypeName(p);
        }
        if (StringUtils.hasText((String)(pickListType = this.text(n, "PickListType")))) {
            p.setPickListType(pickListType);
            this.parsePickListType(p);
        }
        if (StringUtils.hasText((String)(referenceToName = this.text(n, "ReferenceToName")))) {
            p.setReferenceToName(referenceToName);
            this.parseReferenceToName(p);
        }
    }

    private void handleReferenceProperty(Node n, DataProperty p) throws Exception {
        String referenceToName;
        p.setPropertyType("ReferenceProperty");
        String businessTypeName = this.text(n, "BusinessTypeName");
        if (StringUtils.hasText((String)businessTypeName)) {
            p.setBusinessTypeName(businessTypeName);
            this.parseBusinessTypeName(p);
        }
        if (StringUtils.hasText((String)(referenceToName = this.text(n, "ReferenceToName")))) {
            p.setReferenceToName(referenceToName);
            this.parseReferenceToName(p);
        }
    }

    private void handleComplexProperty(Node n, DataProperty p, String entityName, List<DataProperty> list, Map<String, DataProperty> propertyMap) throws Exception {
        p.setPropertyType("ComplexProperty");
        String pickListType = this.text(n, "PickListType");
        if (StringUtils.hasText((String)pickListType)) {
            p.setPickListType(pickListType);
            this.parsePickListType(p);
        }
    }

    private void parseBusinessTypeName(DataProperty p) throws Exception {
        File btFile = Paths.get(this.e10Properties.getMetadataElementDir(), new String[0]).resolve("BusinessType." + p.getBusinessTypeName() + ".dcxml").toFile();
        if (!btFile.exists() && !(btFile = Paths.get(MetadataParser.getMetadataContainerElementUrl().toURI()).resolve("BusinessType." + p.getBusinessTypeName() + ".dcxml").toFile()).exists()) {
            System.err.println("[WARN] Missing BusinessType file: " + btFile.getAbsolutePath());
            return;
        }
        Document doc = this.parseXml(btFile);
        XPath xpath = this.xpf.newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("/BusinessType", doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String scale;
            Element el = (Element)nodes.item(i);
            p.setDbType(this.text(el, "DbType"));
            String size = this.text(el, "Size");
            if (StringUtils.hasText((String)size)) {
                p.setSize(Integer.valueOf(size));
            }
            if (!StringUtils.hasText((String)(scale = this.text(el, "Scale")))) continue;
            p.setScale(Integer.valueOf(scale));
        }
    }

    public void parseReferenceToName(DataProperty p) throws Exception {
        Path otherPath;
        String reference = p.getReferenceToName();
        if (!StringUtils.hasText((String)reference)) {
            return;
        }
        List<String> referenceList = Arrays.stream(reference.split("\\.")).toList();
        String end = referenceList.getLast();
        String fix = referenceList.getFirst();
        Path path = Paths.get(this.e10Properties.getBusinessObjectsRoot(), new String[0]).resolve(fix);
        File file = path.resolve("MetadataContainer.dcxml").toFile();
        if (!file.exists() && !(file = (otherPath = Paths.get(MetadataParser.getBusinessObjectsUrl().toURI()).resolve(fix)).resolve("MetadataContainer.dcxml").toFile()).exists()) {
            return;
        }
        List<DataEntity> list = this.parseFile(file, end, "MetadataContainer");
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(e -> {
                if (e.getName().equals(end)) {
                    p.setReferenceToNameProperty(e.getPrimaryKey());
                    p.setDescription(e.getDisplayName());
                }
            });
        }
    }

    private static URL getBusinessObjectsUrl() {
        return MetadataParser.class.getClassLoader().getResource(MISS_DATA_ENTIRY_URL);
    }

    private static URL getMetadataContainerElementUrl() {
        return MetadataParser.class.getClassLoader().getResource(MISS_METADATA_CONTAINER_ELEMENT_URL);
    }

    public void parsePickListType(DataProperty p) throws Exception {
        if (!this.e10Properties.getEntityStepIsParseDict().booleanValue()) {
            return;
        }
        String pickListType = p.getPickListType();
        if (!StringUtils.isEmpty((Object)pickListType)) {
            String fileName = "PickListType." + pickListType + ".dcxml";
            File refFile = Paths.get(this.e10Properties.getMetadataElementDir(), new String[0]).resolve(fileName).toFile();
            if (refFile.exists()) {
                Document doc = this.parseXml(refFile);
                XPath xpath = this.xpf.newXPath();
                Node propertiesNode = (Node)xpath.evaluate("/PickListType/Items", doc, XPathConstants.NODE);
                if (propertiesNode.hasChildNodes()) {
                    ArrayList<DicProperty> list = new ArrayList<DicProperty>();
                    NodeList children = propertiesNode.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node prop = children.item(i);
                        if (prop.getNodeType() != 1) continue;
                        String id = this.text(prop, "Id");
                        String displayName = this.text(prop, "DisplayName");
                        DicProperty dicProperty = new DicProperty();
                        dicProperty.setDisplayName(displayName);
                        dicProperty.setId(id);
                        list.add(dicProperty);
                    }
                    p.setDicPropertyList(list);
                }
            }
        }
    }

    private Document parseXml(File f) throws Exception {
        this.dbf.setNamespaceAware(true);
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        try (FileInputStream fis = new FileInputStream(f);){
            InputSource is = new InputSource(fis);
            is.setEncoding("utf-8");
            Document document = db.parse(is);
            return document;
        }
    }

    public String getValue(String name, XPath xpath, Element el) throws XPathExpressionException {
        String desc = (String)xpath.evaluate("./" + name, el, XPathConstants.STRING);
        return desc != null ? desc.trim() : null;
    }

    public void initReferToEntity(List<DataEntity> entities) {
        DataEntity entity = new DataEntity();
        entity.setName("ReferToEntity");
        entity.setBusinessCode("ReferToEntity");
        entity.setAlias("ReferToEntity");
        entity.setDisplayName("\u591a\u6765\u6e90");
        entity.setIsCreateTable(false);
        DataProperty p1 = new DataProperty();
        p1.setName("RTK");
        p1.setDbType("String");
        p1.setDisplayName("\u5f15\u7528\u5b9e\u4f53TypeKey");
        p1.setPropertyType("SimpleProperty");
        entity.getColumns().add(p1);
        DataProperty p2 = new DataProperty();
        p2.setName("ROid");
        p2.setDbType("PrimaryKey");
        p2.setDisplayName("\u5f15\u7528\u5b9e\u4f53\u7684\u952e\u503c");
        p2.setPropertyType("SimpleProperty");
        entity.getColumns().add(p2);
        entities.add(entity);
    }

    private String text(Node n, String tag) {
        if (!(n instanceof Element)) {
            return null;
        }
        return XmlUtil.elementText((Element)n, tag);
    }

    public Map<String, DataEntity> getEntityMap() {
        return this.entityMap;
    }

    public Map<String, List<String>> getInterfaceReferencesMap() {
        return this.interfaceReferencesMap;
    }

    public Map<String, DataEntity> getInterfaceEntityMap() {
        return this.interfaceEntityMap;
    }

    public Map<String, DataProperty> getComplexPropertyMap() {
        return this.complexPropertyMap;
    }

    public Map<String, List<DicProperty>> getDicPropertyMap() {
        return this.dicPropertyMap;
    }

    public void parser() throws Exception {
        if (ObjectUtils.isEmpty((Object)this.e10Properties)) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6ee10Properties\u5bf9\u8c61");
        }
        this.parseAllDataEntityTypes();
        List<DataEntity> entities = this.parseAllEntities();
        Map<String, DataEntity> entityMap = this.getEntityMap();
        Map<String, DataEntity> interfaceEntityMap = this.getInterfaceEntityMap();
        Map<String, List<String>> interfaceReferencesMap = this.getInterfaceReferencesMap();
        interfaceReferencesMap.forEach((k, v) -> {
            DataEntity entity = (DataEntity)entityMap.get(k);
            if (entity == null) {
                return;
            }
            List<DataProperty> oldProperties = entity.getColumns();
            List<String> dataPropertys = oldProperties.stream().map(DataProperty::getName).toList();
            v.forEach(interfaceName -> {
                DataEntity interfaceEntity = (DataEntity)interfaceEntityMap.get(interfaceName);
                if (interfaceEntity != null) {
                    List<DataProperty> properties = interfaceEntity.getColumns();
                    properties.forEach(p -> {
                        if (!dataPropertys.contains(p.getName())) {
                            DataProperty dataProperty = new DataProperty();
                            BeanUtils.copyProperties((Object)p, (Object)dataProperty);
                            dataProperty.setDescription(interfaceEntity.getDisplayName());
                            oldProperties.add(dataProperty);
                        }
                    });
                }
            });
        });
        Map<String, Collection<DataProperty>> listMap = this.scanFunctionParse(new File(this.e10Properties.getBusinessObjectsRoot()));
        ForeignExtract foreignExtract = new ForeignExtract();
        foreignExtract.extractForeignKeys(entities, entityMap);
        foreignExtract.extractFeference2Fk(entities, entityMap);
        DocExtract.extracted(listMap, entities);
    }

    public void parserByXmlFilePath(String xmlFile) throws Exception {
        File file = new File(xmlFile);
        this.parser(file.getParentFile().getName());
    }

    public void parser(String entityName) throws Exception {
        if (ObjectUtils.isEmpty((Object)this.e10Properties)) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6ee10Properties\u5bf9\u8c61");
        }
        this.parseAllDataEntityTypes();
        List<DataEntity> entities = this.parseEntity(entityName);
        Map<String, DataEntity> entityMap = this.getEntityMap();
        Map<String, DataEntity> interfaceEntityMap = this.getInterfaceEntityMap();
        Map<String, List<String>> interfaceReferencesMap = this.getInterfaceReferencesMap();
        interfaceReferencesMap.forEach((k, v) -> {
            DataEntity entity = (DataEntity)entityMap.get(k);
            if (entity == null) {
                return;
            }
            List<DataProperty> oldProperties = entity.getColumns();
            v.forEach(interfaceName -> {
                DataEntity interfaceEntity = (DataEntity)interfaceEntityMap.get(interfaceName);
                if (interfaceEntity != null) {
                    List<DataProperty> properties = interfaceEntity.getColumns();
                    properties.forEach(p -> {
                        DataProperty dataProperty = new DataProperty();
                        BeanUtils.copyProperties((Object)p, (Object)dataProperty);
                        dataProperty.setDescription(interfaceEntity.getDisplayName());
                        oldProperties.add(dataProperty);
                    });
                }
            });
        });
        List<Path> paths = FileLister.getFilePathsWithFileName(this.e10Properties.getBusinessObjectsRoot(), entityName, "MetadataContainer.dcxml");
        Map<String, Collection<DataProperty>> listMap = this.scanSingleFunctionParse(paths);
        ForeignExtract foreignExtract = new ForeignExtract();
        foreignExtract.extractForeignKeys(entities, entityMap);
        foreignExtract.extractFeference2Fk(entities, entityMap);
        DocExtract.extracted(listMap, entities);
    }

    public List<DataEntity> getAllDataEntitys() {
        return this.allDataEntitys;
    }

    public static Tuple queryReference(Map<String, DataEntity> entityMap, String tableName, String columnName) {
        return MetadataParser.queryReference(entityMap, tableName, columnName, null);
    }

    public static Tuple queryReferToEntity(Map<String, DataEntity> entityMap, String tableName, String columnName) {
        DataEntity dataEntity = entityMap.getOrDefault(tableName, new DataEntity());
        List<DataProperty> columns = dataEntity.getColumns();
        for (DataProperty dataProperty : columns) {
            String name = dataProperty.getName();
            if (!name.equals(columnName) || !"ReferToEntity".equals(dataProperty.getDataEntityTypeName())) continue;
            DataEntity referToEntity = entityMap.getOrDefault("ReferToEntity", new DataEntity());
            List<DataProperty> referToEntityColumns = referToEntity.getColumns();
            Object joinColumn = "";
            Object selectColumn = "";
            for (DataProperty referToEntityColumn : referToEntityColumns) {
                String dbType = referToEntityColumn.getDbType();
                if (dbType.equals("PrimaryKey")) {
                    joinColumn = name + "_" + referToEntityColumn.getName();
                    continue;
                }
                selectColumn = name + "_" + referToEntityColumn.getName();
            }
            return new Tuple(new Object[]{selectColumn, joinColumn});
        }
        return null;
    }

    public static Tuple queryPkByTableName(Map<String, DataEntity> entityMap, String tableName) {
        DataEntity dataEntity = entityMap.getOrDefault(tableName, null);
        if (dataEntity == null) {
            return null;
        }
        String primaryKey = MetadataParser.queryColumnName(entityMap, tableName, dataEntity.getPrimaryKey());
        return new Tuple(new Object[]{tableName, primaryKey});
    }

    public static String queryColumnName(Map<String, DataEntity> entityMap, String tableName, String columnName) {
        DataEntity dataEntity = entityMap.getOrDefault(tableName, new DataEntity());
        List<DataProperty> columns = dataEntity.getColumns();
        for (DataProperty dataProperty : columns) {
            String name = dataProperty.getName();
            if (!name.equals(columnName)) continue;
            return dataProperty.getAlias();
        }
        return columnName;
    }

    public static Tuple queryReferenceByTable(Map<String, DataEntity> entityMap, String joinTableName, String mainTableName) {
        Tuple tuple = MetadataParser.queryReference(entityMap, joinTableName, mainTableName, null);
        if (tuple != null) {
            Tuple queryPkByTableName = MetadataParser.queryPkByTableName(entityMap, joinTableName);
            if (queryPkByTableName == null) {
                throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u7f3a\u5931:" + joinTableName);
            }
            return queryPkByTableName;
        }
        return null;
    }

    public static Tuple queryReference(Map<String, DataEntity> entityMap, String tableName, String columnName, String rules) {
        DataEntity dataEntity = entityMap.get(tableName);
        if (dataEntity == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u7f3a\u5931:" + tableName);
        }
        String finalColumnName = columnName;
        DataProperty targetProperty = dataEntity.getColumns().stream().filter(property -> finalColumnName.equals(property.getName())).findFirst().orElse(null);
        if (targetProperty == null) {
            return null;
        }
        Tuple referenceTableName = MetadataParser.getReferenceTableName(targetProperty, rules);
        if (referenceTableName == null && (referenceTableName = MetadataParser.getItemDataEntityTableName(targetProperty)) == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u6709\u5c5e\u6027\uff0c\u4f46\u8be5\u5c5e\u6027\u7f3a\u5931\u5173\u8054\u5b9e\u4f53\u5bf9\u8c61:" + tableName + "." + targetProperty.getName());
        }
        if (StringUtils.hasText((String)rules)) {
            return new Tuple(new Object[]{(String)referenceTableName.get(0)});
        }
        Tuple tuple = MetadataParser.queryPkByTableName(entityMap, (String)referenceTableName.get(1));
        if (tuple == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u7f3a\u5931:" + String.valueOf(referenceTableName.get(1)));
        }
        String alias = targetProperty.getAlias();
        if (StringUtils.hasText((String)alias)) {
            columnName = alias;
        }
        return new Tuple(new Object[]{referenceTableName.get(0), tuple.get(1), tableName, columnName});
    }

    private static Tuple getReferenceTableName(DataProperty property, String rules) {
        String referenceToName = property.getReferenceToName();
        if (StringUtils.hasText((String)referenceToName)) {
            String s = MetadataParser.extractTableNameFromPath(referenceToName, rules);
            return new Tuple(new Object[]{s, s});
        }
        return null;
    }

    private static Tuple getItemDataEntityTableName(DataProperty property) {
        String itemDataEntityTypeName = property.getItemDataEntityTypeName();
        if (StringUtils.hasText((String)itemDataEntityTypeName)) {
            String tableName = itemDataEntityTypeName;
            String alias = property.getAlias();
            if (StringUtils.hasText((String)alias)) {
                tableName = alias;
            }
            return new Tuple(new Object[]{tableName, itemDataEntityTypeName});
        }
        return null;
    }

    private static String extractTableNameFromPath(String path, String rules) {
        if (!path.contains(".")) {
            return path;
        }
        String[] pathParts = path.split("\\.");
        if (!StringUtils.hasText((String)rules)) {
            return pathParts[pathParts.length - 1];
        }
        return path;
    }
}

