/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.utils;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import io.micrometer.common.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExampleValueFiller {
    private static final String JDBC_URL = "jdbc:sqlserver://172.16.7.64:1433;databaseName=E10_80_KF;encrypt=false";
    private static final String JDBC_USER = "E10";
    private static final String JDBC_PASSWORD = "erpERP123";

    public static void fillExampleValues(List<DataEntity> entities) {
        try (Connection conn = DriverManager.getConnection(JDBC_URL, JDBC_USER, JDBC_PASSWORD);){
            Set<String> dbTables = ExampleValueFiller.getAllTableNames(conn);
            ExampleValueFiller.printMissingEntities(dbTables, entities);
            Iterator<DataEntity> iterator = entities.iterator();
            while (iterator.hasNext()) {
                DataEntity entity = iterator.next();
                String tableName = entity.getName();
                if (!dbTables.contains(tableName.toLowerCase())) {
                    System.out.println("[\u274c \u5b9e\u4f53\u5b58\u5728\u4f46\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8868] " + tableName);
                    iterator.remove();
                    continue;
                }
                ExampleValueFiller.fillEntityExamples(conn, entity);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    private static Set<String> getAllTableNames(Connection conn) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        DatabaseMetaData meta = conn.getMetaData();
        try (ResultSet rs = meta.getTables(null, null, "%", new String[]{"TABLE"});){
            while (rs.next()) {
                tableNames.add(rs.getString("TABLE_NAME").toLowerCase());
            }
        }
        return tableNames;
    }

    private static void printMissingEntities(Set<String> dbTables, List<DataEntity> entities) {
        HashSet<String> entityTables = new HashSet<String>();
        for (DataEntity e : entities) {
            if (e.getName() == null) continue;
            entityTables.add(e.getName().toLowerCase());
        }
        for (String dbTable : dbTables) {
            if (entityTables.contains(dbTable)) continue;
        }
    }

    private static void fillEntityExamples(Connection conn, DataEntity entity) {
        String tableName = entity.getName();
        List<DataProperty> properties = entity.getColumns();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String sql = "SELECT TOP 3 * FROM [" + tableName + "]";
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            HashSet<String> dbColumns = new HashSet<String>();
            for (int i = 1; i <= colCount; ++i) {
                dbColumns.add(meta.getColumnLabel(i).toLowerCase());
            }
            for (String dbCol : dbColumns) {
                boolean found = properties.stream().anyMatch(p -> p.getName().equalsIgnoreCase(dbCol));
                if (found) continue;
            }
            Iterator<DataProperty> it = properties.iterator();
            while (it.hasNext()) {
                DataProperty prop = it.next();
                if (!StringUtils.isBlank((String)prop.getAlias())) {
                    prop.setName(prop.getAlias());
                }
                if (dbColumns.contains(prop.getName().toLowerCase())) continue;
                it.remove();
            }
            HashMap<String, StringBuilder> exampleMap = new HashMap<String, StringBuilder>();
            for (String col : dbColumns) {
                exampleMap.put(col, new StringBuilder());
            }
            for (int rowCount = 0; rs.next() && rowCount < 3; ++rowCount) {
                for (String col : dbColumns) {
                    Object value = null;
                    try {
                        value = rs.getObject(col);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (value == null) continue;
                    StringBuilder sb = (StringBuilder)exampleMap.get(col);
                    if (sb.length() > 0) {
                        sb.append(" | ");
                    }
                    sb.append(value.toString());
                }
            }
            for (DataProperty prop : properties) {
                String key = prop.getName().toLowerCase();
                StringBuilder example = (StringBuilder)exampleMap.get(key);
                if (example == null || example.length() <= 0) continue;
                prop.setExampleValue(example.toString());
            }
        }
        catch (SQLException e) {
            System.err.println("\u67e5\u8be2\u8868 " + tableName + " \u65f6\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

