/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.log.Log;
import com.digiwin.athena.ai.generate.tools.e10.util.TemplateUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GenerateClassUtil {
    private static final String CLASS_FULL_NAME_FORMAT = "com.digiwin.athenai.reactive.delegate.e10.sharedata.E10_%s_R_%s_%s";

    public void generateClassList(List<RelationDefinition> relationDefinitions) {
        if (CollectionUtil.isEmpty(relationDefinitions)) {
            return;
        }
        for (RelationDefinition definition : relationDefinitions) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("TypeKey", definition.getBusinessCode());
            replacements.put("id", definition.getCode().replace("-", "_"));
            replacements.put("counter", "" + definition.getCounter());
            replacements.put("entityName", definition.getFromEntity());
            replacements.put("entityFullName", definition.getFromFullPath());
            replacements.put("name", definition.getName());
            List<String> dependencyItems = definition.getDependencyItems();
            if (CollectionUtil.isNotEmpty(dependencyItems)) {
                ArrayList<String> list = new ArrayList<String>();
                for (String s : dependencyItems) {
                    list.add(String.format("\"%s\"", s));
                }
                replacements.put("dependencyItems", "Arrays.asList(" + String.join((CharSequence)",", list) + ")");
            } else {
                replacements.put("dependencyItems", "null");
            }
            replacements.put("sql", definition.getSql());
            replacements.put("parameter", String.join((CharSequence)"\n        ", definition.getWhereConditions()));
            definition.setTranslate(TemplateUtil.replaceTemplate(TemplateUtil.getShareDataRelationTemplate(), replacements));
            definition.setClassFullName(String.format(CLASS_FULL_NAME_FORMAT, definition.getBusinessCode(), definition.getCode().replace("-", "_"), definition.getCounter()));
            Log.get().debug("\n" + definition.getTranslate(), new Object[0]);
        }
    }
}

