/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChain;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChainLinkedList;
import com.digiwin.athena.ai.generate.tools.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MetadataUtil {
    private final Map<String, DataEntity> entityMap;

    public MetadataUtil(Map<String, DataEntity> entityMap) {
        this.entityMap = entityMap;
    }

    public DataProperty resolveColumnPath(String path) {
        if (StrUtil.isEmpty((CharSequence)path)) {
            return new DataProperty();
        }
        if (!path.contains(".")) {
            DataProperty dataProperty = new DataProperty();
            dataProperty.setItemDataEntityTypeName(path);
            dataProperty.setAlias(path);
            return dataProperty;
        }
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(path.split("\\.")));
        String currentEntityType = null;
        DataProperty currentProperty = null;
        int i = 0;
        while (i < parts.size()) {
            String property = (String)parts.get(i);
            if (i == 0) {
                currentEntityType = property;
                ++i;
                continue;
            }
            if (i == parts.size() - 1 && ("ROid".equals(property) || "RTK".equals(property))) {
                DataProperty dataProperty = new DataProperty();
                dataProperty.setAlias((currentProperty != null ? currentProperty.getAlias() : null) + "_" + property);
                return dataProperty;
            }
            currentProperty = this.findNextEntityType(currentEntityType, property);
            if (null == currentProperty) {
                throw new BusinessException("\u5f53\u524d\u5b9e\u4f53\u65e0\u5173\u8054CollectionProperty\u5c5e\u6027:" + currentEntityType + "." + property);
            }
            String nextEntityType = currentProperty.getItemDataEntityTypeName();
            if (StrUtil.isEmpty((CharSequence)nextEntityType)) {
                throw new BusinessException("CollectionProperty\u65e0\u5173\u8054ItemDataEntityTypeName:" + currentEntityType + "." + property);
            }
            if (currentEntityType.contains(".")) {
                ArrayList<String> resolveds = new ArrayList<String>(Arrays.asList(currentEntityType.split("\\.")));
                parts.addAll(i, resolveds);
                currentEntityType = (String)resolveds.getFirst();
            } else {
                currentEntityType = nextEntityType;
            }
            ++i;
        }
        return currentProperty;
    }

    public TableChainLinkedList tableChainLinkedList(String path, String type) {
        if (StrUtil.isEmpty((CharSequence)path)) {
            throw new BusinessException("\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TableChainLinkedList list = new TableChainLinkedList();
        if (!path.contains(".")) {
            DataEntity dataEntity = this.findDataEntity(path);
            list.add(new TableChain(path, dataEntity.getAlias(), dataEntity.getPrimaryKey(), type));
            return list;
        }
        String[] pathParts = path.split("\\.");
        String currentEntityType = null;
        for (int i = 0; i < pathParts.length; ++i) {
            if (i == 0) {
                currentEntityType = pathParts[i];
                DataEntity dataEntity = this.findDataEntity(currentEntityType);
                list.add(new TableChain(currentEntityType, dataEntity.getAlias(), dataEntity.getPrimaryKey(), type));
                continue;
            }
            String property = pathParts[i];
            DataProperty currentProperty = this.findProperty(currentEntityType, property);
            if (currentProperty == null) {
                throw new BusinessException("\u5f53\u524d\u5b9e\u4f53\u65e0\u5173\u8054CollectionProperty\u5c5e\u6027:" + currentEntityType + "." + property);
            }
            String nextEntityType = currentProperty.getItemDataEntityTypeName();
            if (StrUtil.isEmpty((CharSequence)nextEntityType)) {
                throw new BusinessException("CollectionProperty\u65e0\u5173\u8054ItemDataEntityTypeName:" + currentEntityType + "." + property);
            }
            DataEntity dataEntity = this.findDataEntity(currentProperty.getItemDataEntityTypeName());
            list.add(new TableChain(currentProperty.getItemDataEntityTypeName(), currentProperty.getAlias(), dataEntity.getPrimaryKey(), type));
            currentEntityType = nextEntityType;
        }
        return list;
    }

    public TableChainLinkedList tableChainLinkedList(String path) {
        return this.tableChainLinkedList(path, null);
    }

    private DataProperty findProperty(String entityType, String property) {
        DataEntity dataEntity = this.findDataEntity(entityType);
        return dataEntity.getColumns().stream().filter(p -> property.equals(p.getName())).findFirst().orElse(null);
    }

    public DataProperty findNextEntityType(String entityType, String property) {
        DataProperty p = this.findProperty(entityType, property);
        if (null == p) {
            return null;
        }
        DataProperty dataProperty = new DataProperty();
        dataProperty.setName(p.getName());
        dataProperty.setAlias(StrUtil.isEmpty((CharSequence)p.getAlias()) ? p.getName() : p.getAlias());
        if (StrUtil.isNotEmpty((CharSequence)p.getItemDataEntityTypeName())) {
            dataProperty.setItemDataEntityTypeName(p.getItemDataEntityTypeName());
            return dataProperty;
        }
        if (StrUtil.isNotEmpty((CharSequence)p.getReferenceToName())) {
            dataProperty.setItemDataEntityTypeName(p.getReferenceToName());
            return dataProperty;
        }
        if (StrUtil.isNotEmpty((CharSequence)p.getDataEntityTypeName())) {
            dataProperty.setItemDataEntityTypeName(p.getDataEntityTypeName());
            return dataProperty;
        }
        return null;
    }

    private String findReferenceToName(String entityType, String property) {
        DataProperty p = this.findProperty(entityType, property);
        return p.getReferenceToName();
    }

    private String findItemDataEntityTypeName(String entityType, String property) {
        DataProperty p = this.findProperty(entityType, property);
        return p.getItemDataEntityTypeName();
    }

    public List<DataEntity> findDataEntityListByBizCode(String bizCode) {
        ArrayList<DataEntity> list = new ArrayList<DataEntity>();
        Collection<DataEntity> values = this.entityMap.values();
        for (DataEntity value : values) {
            if (!bizCode.equals(value.getBusinessCode())) continue;
            list.add(value);
        }
        return list;
    }

    public DataEntity findDataEntity(String name) {
        DataEntity dataEntity = this.entityMap.get(name);
        if (dataEntity != null) {
            dataEntity.setAlias(StrUtil.isNotEmpty((CharSequence)dataEntity.getAlias()) ? dataEntity.getAlias() : dataEntity.getName());
        }
        return dataEntity;
    }
}

