/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationNode;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationPair;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChainLinkedList;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChainNode;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.MetadataUtil;
import com.digiwin.athena.ai.generate.tools.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlGeneratorNewUtil {
    private static final String TYPE_JOIN = "TYPE_JOIN";
    private static final String PARAMETER_FORMAT = "parameter.put(\"@P%d\", %s);";
    private final Map<String, String> tableAliasMap = new HashMap<String, String>();
    private final Map<String, TableChainNode> nodeAliasMap = new HashMap<String, TableChainNode>();
    private final MetadataUtil metadataUtil;
    private int aliasIndex = 0;

    public SqlGeneratorNewUtil(MetadataUtil metadataUtil) {
        this.metadataUtil = metadataUtil;
    }

    public void generateSqlList(List<RelationDefinition> relationDefinitions) {
        if (CollectionUtil.isEmpty(relationDefinitions)) {
            return;
        }
        for (RelationDefinition definition : relationDefinitions) {
            this.tableAliasMap.clear();
            this.nodeAliasMap.clear();
            this.aliasIndex = 0;
            String sql = this.generateSingleSql(definition);
            definition.setSql(sql);
        }
    }

    public String generateSingleSql(RelationDefinition definition) {
        StringBuilder sqlBuilder = new StringBuilder("\n");
        this.generateFromAndJoinParts(sqlBuilder, definition);
        this.generateWherePart(sqlBuilder, definition);
        return this.generateSelectPart(sqlBuilder);
    }

    private String generateSelectPart(StringBuilder sqlBuilder) {
        ArrayList<String> selectList = new ArrayList<String>();
        String format = " %s.%s AS \"%s.%s\"";
        int index = 1;
        List<Map.Entry<String, String>> entries = this.sortByNumericSuffix(this.tableAliasMap);
        for (Map.Entry<String, String> entry : entries) {
            TableChainNode tableChainNode = this.nodeAliasMap.get(entry.getKey());
            if (null == tableChainNode || !TYPE_JOIN.equals(tableChainNode.getData().getType())) continue;
            String entityName = tableChainNode.getData().getEntityName();
            DataEntity dataEntity = this.metadataUtil.findDataEntity(entityName);
            if (null == dataEntity) {
                throw new BusinessException("\u67e5\u8be2\u5b9e\u4f53\u4e3a\u7a7a");
            }
            for (DataProperty column : dataEntity.getColumns()) {
                String alias = StrUtil.isEmpty((CharSequence)column.getAlias()) ? column.getName() : column.getAlias();
                String name = column.getName();
                if ("CollectionProperty".equals(column.getPropertyType()) || alias.startsWith("UDF")) continue;
                if ("ComplexProperty".equals(column.getPropertyType()) && "ReferToEntity".equals(column.getDataEntityTypeName())) {
                    selectList.add(String.format(format, entry.getValue(), alias + "_RTK", index, name + ".RTK"));
                    selectList.add(String.format(format, entry.getValue(), alias + "_ROid", index, name + ".ROid"));
                    continue;
                }
                selectList.add(String.format(format, entry.getValue(), alias, index, name));
            }
            ++index;
        }
        return "SELECT \n" + String.join((CharSequence)",\n", selectList) + String.valueOf(sqlBuilder);
    }

    private void generateFromAndJoinParts(StringBuilder sqlBuilder, RelationDefinition definition) {
        TableChainLinkedList toTableChain = this.metadataUtil.tableChainLinkedList(definition.getToFullPath(), TYPE_JOIN);
        TableChainNode current = toTableChain.getTail();
        String currentTable = current.getData().getTableName();
        String currentAlias = this.getAlias(current.getData().getTableName(), current);
        sqlBuilder.append("FROM ").append(currentTable).append(" ").append(currentAlias).append("\n");
        String prevAlias = currentAlias;
        for (current = current.getPrev(); current != null; current = current.getPrev()) {
            String leftTable = current.getData().getTableName();
            String leftAlias = this.getAlias(leftTable, current);
            sqlBuilder.append("LEFT JOIN ").append(leftTable).append(" ").append(leftAlias);
            String defaultCondition = String.format("%s.%s = %s.%s", leftAlias, current.getData().getPrimaryKey(), prevAlias, current.getData().getPrimaryKey());
            sqlBuilder.append(" ON ").append(defaultCondition).append("\n");
            prevAlias = leftAlias;
        }
    }

    private void generateWherePart(StringBuilder sqlBuilder, RelationDefinition definition) {
        TableChainLinkedList toTableChain = this.metadataUtil.tableChainLinkedList(definition.getToFullPath());
        TableChainNode toTail = toTableChain.getTail();
        String toAlias = this.getAlias(toTail.getData().getTableName(), toTail);
        ArrayList<String> whereConditions = new ArrayList<String>();
        ArrayList<String> parameters = new ArrayList<String>();
        int paramIndex = 1;
        List<RelationPair> relations = definition.getRelations();
        if (relations != null) {
            for (RelationPair pair : relations) {
                RelationNode fromNode = pair.getFrom();
                String fromNodeType = fromNode.getType();
                RelationNode toNode = pair.getTo();
                String toNodeType = toNode.getType();
                StringBuilder str = new StringBuilder();
                int i = paramIndex++;
                if ("property".equals(fromNodeType)) {
                    parameters.add(String.format(PARAMETER_FORMAT, i, SqlGeneratorNewUtil.generateReactiveEntityCode(fromNode.getName())));
                } else {
                    parameters.add(String.format(PARAMETER_FORMAT, i, "\"" + String.valueOf(fromNode.getValue()) + "\""));
                }
                str.append("@P").append(i).append(" = ");
                if ("property".equals(toNodeType)) {
                    String toFieldName = this.getProperty(toTail, toNode.getName());
                    str.append(toAlias).append(".").append(toFieldName);
                } else {
                    int j = paramIndex++;
                    parameters.add(String.format(PARAMETER_FORMAT, j, "\"" + String.valueOf(toNode.getValue()) + "\""));
                    str.append("@P").append(j);
                }
                whereConditions.add(str.toString());
            }
        }
        if (!whereConditions.isEmpty()) {
            sqlBuilder.append("WHERE ");
            for (int i = 0; i < whereConditions.size(); ++i) {
                if (i > 0) {
                    sqlBuilder.append("\n AND ");
                }
                sqlBuilder.append((String)whereConditions.get(i));
            }
            definition.setWhereConditions(parameters);
        }
    }

    private String getAlias(String tableName, TableChainNode node) {
        if (this.tableAliasMap.containsKey(tableName)) {
            return this.tableAliasMap.get(tableName);
        }
        String alias = "t" + this.aliasIndex++;
        this.tableAliasMap.put(tableName, alias);
        this.nodeAliasMap.put(tableName, node);
        return alias;
    }

    private String getProperty(TableChainNode tableChainNode, String path) {
        String[] paths = path.split("\\.");
        TableChainNode currentNode = tableChainNode;
        String currentEntityName = currentNode.getData().getEntityName();
        StringBuilder currentFieldName = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            String property = paths[i];
            if ("Parent".equals(property)) {
                currentNode = tableChainNode.getPrev();
                currentEntityName = currentNode.getData().getEntityName();
                continue;
            }
            if (i == paths.length - 1) {
                if ("ROid".equals(property) || "RTK".equals(property)) {
                    currentFieldName.append("_").append(property);
                    return currentFieldName.toString();
                }
                currentFieldName = new StringBuilder(property);
                return currentFieldName.toString();
            }
            DataProperty nextEntityType = this.metadataUtil.findNextEntityType(currentEntityName, property);
            if (null == nextEntityType) {
                throw new BusinessException("\u67e5\u8be2\u5c5e\u6027\u4e3a\u7a7a:" + currentEntityName + "." + property);
            }
            currentFieldName = new StringBuilder(nextEntityType.getAlias());
            currentEntityName = nextEntityType.getItemDataEntityTypeName();
        }
        return currentFieldName.toString();
    }

    public List<Map.Entry<String, String>> sortByNumericSuffix(Map<String, String> map) {
        return map.entrySet().stream().sorted(Comparator.comparingInt(entry -> this.extractNumberFromValue((String)entry.getValue()))).collect(Collectors.toList());
    }

    private int extractNumberFromValue(String value) {
        String numberPart = value.replaceAll("\\D+", "");
        return numberPart.isEmpty() ? 0 : Integer.parseInt(numberPart);
    }

    public static String generateReactiveEntityCode(String input) {
        int i;
        if (input == null || input.isBlank()) {
            throw new IllegalArgumentException("\u8f93\u5165\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] tokens = (String[])Arrays.stream(input.split("\\.")).map(String::trim).toArray(String[]::new);
        int parentCount = 0;
        ArrayList<String> nonParentTokens = new ArrayList<String>();
        for (String token : tokens) {
            if ("Parent".equals(token)) {
                ++parentCount;
                continue;
            }
            nonParentTokens.add(token);
        }
        StringBuilder codeBuilder = new StringBuilder("context.getActiveObject()");
        for (i = 0; i < parentCount; ++i) {
            codeBuilder.append(".parent()");
        }
        if (!nonParentTokens.isEmpty()) {
            for (i = 0; i < nonParentTokens.size(); ++i) {
                String field = (String)nonParentTokens.get(i);
                if (i > 0) {
                    codeBuilder.insert(0, "((ReactiveEntity) ");
                }
                codeBuilder.append(".getValue(\"").append(field).append("\")");
                if (i >= nonParentTokens.size() - 1) continue;
                codeBuilder.append(")");
            }
        }
        return codeBuilder.toString();
    }

    public static void main(String[] args) {
        String input1 = "Parent.RECEIVE_Owner_Org.ROid";
        System.out.println(SqlGeneratorNewUtil.generateReactiveEntityCode(input1));
        String input2 = "Parent.Parent.RECEIVE_Owner_Org.ROid";
        System.out.println(SqlGeneratorNewUtil.generateReactiveEntityCode(input2));
        String input3 = "ABM_ID.RECEIVE_Owner_Org.ROid";
        System.out.println(SqlGeneratorNewUtil.generateReactiveEntityCode(input3));
        String input4 = "Parent.Parent.Parent.Field1.Field2";
        System.out.println(SqlGeneratorNewUtil.generateReactiveEntityCode(input4));
        String input5 = "Field1.Field2.Field3.Field4";
        System.out.println(SqlGeneratorNewUtil.generateReactiveEntityCode(input5));
    }
}

