/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.util.GroupObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.business.RootEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.ProgramInfoParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.programInfo.ProgramInfo;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.module.dto.Item;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10BusinessObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10BusinessObjectServiceImpl.class);
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.BUSINESS;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        E10Properties.ProgramInfoContainerInfo programInfoContainer = context.getE10Properties().getProgramInfoContainer();
        ArrayList programInfoList = new ArrayList();
        List<String> xmlFiles = FileLister.getFilePathsWithSuffix(programInfoContainer.getPath(), programInfoContainer.getRegex());
        if (CollectionUtils.isNotEmpty(xmlFiles)) {
            log.debug("\u627e\u5230{}\u4e2a{}\u6587\u4ef6 ", (Object)xmlFiles.size(), (Object)programInfoContainer.getRegex());
            ArrayList programInfoListTmp = new ArrayList();
            Map<Integer, List<String>> integerListMap = GroupObjectUtil.groupBySizeWithStream(xmlFiles, 20);
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                integerListMap.forEach((groupNo, data) -> executor.submit(() -> ProgramInfoParser.parserJob(data, programInfoListTmp)));
            }
            programInfoList.addAll(programInfoListTmp);
        }
        List<ProgramInfo> businessObjects = programInfoList.stream().filter(res -> !ObjectUtils.isEmpty((Object)res.getCategory()) && Arrays.stream(res.getCategory().split(",")).toList().contains("BusinessObjects")).collect(Collectors.toList());
        context.setProgramInfoList(businessObjects);
        List typeKeyList = businessObjects.stream().map(ProgramInfo::getTypeKey).collect(Collectors.toList());
        Map<String, List<Item>> moduleItems = context.getModuleItems();
        List mergedItems = moduleItems.values().stream().filter(res -> CollectionUtils.isNotEmpty((Collection)res)).flatMap(res -> res.stream().filter(item -> typeKeyList.contains(item.getTypeKey()))).collect(Collectors.toList());
        SclProductVersion sclProductVersion = context.getSclProductVersion();
        List<RootEntity> rootNodeList = FileLister.getRootNodeList(context.getE10Properties().getBusinessObjectsRoot(), context.getE10Properties().getRootEntityFileName());
        context.setRootNodeList(rootNodeList);
        Map<String, List<Item>> collect = mergedItems.stream().collect(Collectors.groupingBy(Item::getTypeKey));
        ArrayList sclBusinessObjects = new ArrayList();
        collect.put("USER", new ArrayList());
        collect.put("ReferToEntity", new ArrayList());
        collect.forEach((k, v) -> {
            SclBusinessObject sclBusinessObject = new SclBusinessObject();
            sclBusinessObject.setProductVersionId(sclProductVersion.getId());
            sclBusinessObject.setCode(k);
            sclBusinessObject.setId(IdUtil.getId());
            if (CollectionUtils.isNotEmpty((Collection)rootNodeList)) {
                Optional<RootEntity> first = rootNodeList.stream().filter(res -> k.equals(res.getFolderName())).findFirst();
                if (first.isPresent()) {
                    RootEntity rootEntity1 = first.get();
                    sclBusinessObject.setName(!ObjectUtils.isEmpty((Object)rootEntity1.getDisplayName()) ? rootEntity1.getDisplayName() : k);
                    sclBusinessObject.setDescription(rootEntity1.getDescription());
                } else {
                    sclBusinessObject.setName(k);
                    sclBusinessObject.setDescription(k);
                }
            } else {
                sclBusinessObject.setName(k);
                sclBusinessObject.setDescription(k);
            }
            sclBusinessObjects.add(sclBusinessObject);
        });
        if (CollectionUtils.isNotEmpty(sclBusinessObjects)) {
            this.sclBusinessObjectMapper.insert(sclBusinessObjects);
            E10BusinessObjectServiceImpl.tranIds(context, moduleItems);
            Map<String, Long> businessObjectsRel = sclBusinessObjects.stream().collect(Collectors.toMap(SclBusinessObject::getCode, SclBusinessObject::getId, (existingValue, newValue) -> existingValue));
            context.setBusinessObjectsRel(businessObjectsRel);
        }
    }

    private static void tranIds(E10ExecuteContext context, Map<String, List<Item>> moduleItems) {
        Map<String, Long> moduleRel = context.getModuleRel();
        HashMap<String, List<Long>> typeKeysModuleIdRel = new HashMap<String, List<Long>>();
        moduleItems.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty((Collection)v)) {
                List typeKeys = v.stream().map(Item::getTypeKey).collect(Collectors.toList());
                for (String typeKey : typeKeys) {
                    List<Long> objects;
                    if (typeKeysModuleIdRel.containsKey(typeKey)) {
                        objects = (List)typeKeysModuleIdRel.get(typeKey);
                        objects.add((Long)moduleRel.get(k));
                        typeKeysModuleIdRel.put(typeKey, objects);
                        continue;
                    }
                    objects = new ArrayList();
                    objects.add((Long)moduleRel.get(k));
                    typeKeysModuleIdRel.put(typeKey, objects);
                }
            }
        });
        context.setTypeKeysModuleIdRel(typeKeysModuleIdRel);
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.BUSINESS.getOrder();
    }

    public String desc() {
        return "\u3010\u4e1a\u52a1\u5bf9\u8c61\u3011";
    }

    @Override
    public void fillSkipData(E10ExecuteContext context) {
        List<RootEntity> rootNodeList = FileLister.getRootNodeList(context.getE10Properties().getBusinessObjectsRoot(), context.getE10Properties().getRootEntityFileName());
        context.setRootNodeList(rootNodeList);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SclBusinessObject::getProductVersionId, (Object)context.getSclProductVersion().getId());
        List sclBusinessObjects = this.sclBusinessObjectMapper.selectList((Wrapper)queryWrapper);
        Map<String, Long> businessObjectsRel = sclBusinessObjects.stream().collect(Collectors.toMap(SclBusinessObject::getCode, SclBusinessObject::getId, (existingValue, newValue) -> existingValue));
        context.setBusinessObjectsRel(businessObjectsRel);
        Map<String, List<Item>> moduleItems = context.getModuleItems();
        E10BusinessObjectServiceImpl.tranIds(context, moduleItems);
    }
}

