/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclCommonInfoConfig;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiInputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiOutputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclCommonInfoConfigMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.util.GroupObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.business.RootEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.ApiObject;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub.APISubObject;
import com.digiwin.athena.ai.generate.tools.enums.CategoryEnum;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10EntityPropertyApiObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10EntityPropertyApiObjectServiceImpl.class);
    @Autowired
    private SclApiInputParamMapper sclApiInputParamMapper;
    @Autowired
    private SclApiOutputParamMapper sclApiOutputParamMapper;
    @Autowired
    private List<APISubObject> apiSubObjects;
    @Autowired
    private SclCommonInfoConfigMapper sclCommonInfoConfigMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.ENTITY_PROPERTY_API;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws Exception {
        List listByCategory = this.sclCommonInfoConfigMapper.getListByCategory(CategoryEnum.E10_API_DATA_TYPE.getCode());
        if (CollectionUtils.isEmpty((Collection)listByCategory)) {
            throw new RuntimeException("\u7f3a\u5c11\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e");
        }
        Map commonInfoConfigMap = listByCategory.stream().collect(Collectors.toMap(SclCommonInfoConfig::getActionName, Function.identity(), (existingValue, newValue) -> existingValue));
        List<RootEntity> rootNodeList = context.getRootNodeList();
        Set<String> businessIds = context.getBusinessObjectsRel().keySet();
        Map<String, DataEntity> entityMap = context.getEntityMap();
        Map<String, Long> dicCodeIdRel = context.getDicCodeIdRel();
        Long productVersionId = context.getSclProductVersion().getId();
        HashMap<String, Long> entityFieldIdsRel = context.getEntityFieldIdsRel();
        if (CollectionUtils.isNotEmpty(rootNodeList)) {
            List filterEntityList = rootNodeList.stream().filter(res -> businessIds.contains(res.getFolderName())).distinct().collect(Collectors.toList());
            Map<String, List<ApiObject>> allApi = context.getAllApi();
            Map<String, List<RootEntity>> collect = filterEntityList.stream().collect(Collectors.groupingBy(RootEntity::getFolderName));
            List<Map<String, List<RootEntity>>> groupList = GroupObjectUtil.groupMapByKeyCountWithStreams(collect, 10);
            for (Map<String, List<RootEntity>> group : groupList) {
                ArrayList sclApiInputParams = new ArrayList();
                ArrayList sclApiOutputParams = new ArrayList();
                group.forEach((businessCode, entities) -> {
                    List apiObjects = (List)allApi.get(businessCode);
                    if (CollectionUtils.isNotEmpty((Collection)apiObjects)) {
                        for (ApiObject apiObject : apiObjects) {
                            Optional<APISubObject> first = this.apiSubObjects.stream().filter(res -> res.type(apiObject.getCode())).findFirst();
                            if (!first.isPresent()) {
                                log.info("\u5bf9\u5e94\u7c7b\u578b\u4e3a\uff1a{}\u751f\u6210API\u51fa\u5165\u53c2\u6570\u636e\uff0c\u6682\u65e0\u652f\u6301", (Object)apiObject.getCode());
                                continue;
                            }
                            log.debug("\u4e1a\u52a1\u5bf9\u8c61\uff1a{}\u5bf9\u5e94\u7c7b\u578b\u4e3a\uff1a{}\u751f\u6210API\u51fa\u5165\u53c2\u6570\u636e", businessCode, (Object)apiObject.getCode());
                            APISubObject apiSubObject = first.get();
                            apiSubObject.process((RootEntity)entities.getFirst(), apiObject, productVersionId, sclApiInputParams, entityMap, entityFieldIdsRel, dicCodeIdRel, sclApiOutputParams, commonInfoConfigMap);
                        }
                    } else {
                        log.info("\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61{}\u4e0d\u5b58\u5728api\u7684\u7ed1\u5b9a", businessCode);
                    }
                });
                this.sclApiInputParamMapper.insert(sclApiInputParams);
                this.sclApiOutputParamMapper.insert(sclApiOutputParams);
            }
        }
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.ENTITY_PROPERTY_API.getOrder();
    }

    public String desc() {
        return "\u901a\u8fc7\u5b9e\u4f53\u8f6c\u5316API";
    }
}

