/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import com.digiwin.athena.ai.generate.tools.common.agent.service.transformation.CodeIntelligentTransformationService;
import com.digiwin.athena.ai.generate.tools.db.bo.ContentData;
import com.digiwin.athena.ai.generate.tools.db.bo.JobFunctionBO;
import com.digiwin.athena.ai.generate.tools.db.bo.SclFunctionRule;
import com.digiwin.athena.ai.generate.tools.db.bo.TranslateData;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclFunctionRuleMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobFunctionMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.dto.PythonCovertJavaDTO;
import com.digiwin.athena.ai.generate.tools.dto.PythonCovertJavaTranslateDTO;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.util.JsonPathResolverUtil;
import com.digiwin.athena.ai.generate.tools.e10.util.TemplateUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.FunctionRuleLoader;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.FunctionRuleXmlParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.constant.FunctionRuleTypeEnum;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.FuctionRule;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.covert.FormulaValidatorFunctionRuleMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.covert.TranslateDataMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.CacheUtil;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class E10FunctionRuleServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10FunctionRuleServiceImpl.class);
    private final SclFunctionRuleMapper sclFunctionRuleMapper;
    private final SclJobFunctionMapper sclJobFunctionMapper;
    private final CodeIntelligentTransformationService codeIntelligentTransformationService;
    private final ApplicationEventPublisher eventPublisher;
    private final List<String> validatePoint = List.of("init", "inSubmit", "dataChanged", "CollectionItemDeleting", "DetailFocused");
    private final List<String> formulaPoint = List.of("init", "inSubmit", "dataChanged", "DataEntityChanged", "ContinuousAdded");

    public E10FunctionRuleServiceImpl(SclFunctionRuleMapper sclFunctionRuleMapper, SclJobFunctionMapper sclJobFunctionMapper, CodeIntelligentTransformationService codeIntelligentTransformationService, ApplicationEventPublisher eventPublisher) {
        this.sclFunctionRuleMapper = sclFunctionRuleMapper;
        this.sclJobFunctionMapper = sclJobFunctionMapper;
        this.codeIntelligentTransformationService = codeIntelligentTransformationService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.FUNCTION_RULE;
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.FUNCTION_RULE.getOrder();
    }

    public String desc() {
        return "\u3010\u89c4\u5219\u3011";
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        try {
            List<String> typeKeys = context.getE10Properties().getTypeKeys();
            if (CollectionUtil.isEmpty(typeKeys)) {
                this.batchFunctionRuleParserInsert(context.getE10Properties().getQueryBusinessObjectsRoot(), null, FunctionRuleTypeEnum.FORMULA, context.getSclProductVersion().getId());
                this.batchFunctionRuleParserInsert(context.getE10Properties().getBusinessObjectsRoot(), null, FunctionRuleTypeEnum.VALIDATE, context.getSclProductVersion().getId());
            } else {
                for (String typeKey : typeKeys) {
                    this.batchFunctionRuleParserInsert(context.getE10Properties().getQueryBusinessObjectsRoot(), typeKey, FunctionRuleTypeEnum.FORMULA, context.getSclProductVersion().getId());
                    this.batchFunctionRuleParserInsert(context.getE10Properties().getBusinessObjectsRoot(), typeKey, FunctionRuleTypeEnum.VALIDATE, context.getSclProductVersion().getId());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void batchFunctionRuleParserInsert(String directoryPath, String code, FunctionRuleTypeEnum functionRuleTypeEnum, Long productVersionId) throws Exception {
        List<Path> pathList;
        log.info("\u89e3\u6790\u89c4\u5219\u5f00\u59cb\uff1a{}", (Object)functionRuleTypeEnum.getType());
        if (StrUtil.isNotEmpty((CharSequence)code)) {
            directoryPath = (String)directoryPath + "\\" + code;
            pathList = FileLister.getFilePathsWithPrefix((String)directoryPath, functionRuleTypeEnum.getPrefix(), 1);
        } else {
            pathList = FileLister.getFilePathsWithPrefix((String)directoryPath, functionRuleTypeEnum.getPrefix(), 2);
        }
        ArrayList<FuctionRule> formulas = new ArrayList<FuctionRule>();
        FunctionRuleXmlParser parser = FunctionRuleLoader.load().stream().filter(t -> t.supportKey(functionRuleTypeEnum.getType())).toList().getFirst();
        for (Path path : pathList) {
            formulas.addAll(parser.parseXml(path));
        }
        List jobFunctions = this.sclJobFunctionMapper.queryByProductVersionIdAndFuncCode(productVersionId, "CREATE");
        List sclFunctionRules = this.sclFunctionRuleMapper.queryListByVersionAndCode(productVersionId, null, null, functionRuleTypeEnum.getType());
        Map sclFunctionRuleMap = sclFunctionRules.stream().collect(Collectors.toMap(this::getRedisKey, Function.identity()));
        Map<String, Long> jobFunctionMap = jobFunctions.stream().collect(Collectors.toMap(t -> String.join((CharSequence)":", t.getCode(), t.getChildCode()), JobFunctionBO::getFuncId));
        for (FuctionRule fuctionRule : formulas) {
            String description = fuctionRule.getDescription();
            if (StrUtil.isBlank((CharSequence)description)) {
                fuctionRule.setDescription(fuctionRule.getDisplayName());
            }
            fuctionRule.setProductVersionId(productVersionId);
            Long funcId = jobFunctionMap.getOrDefault(String.join((CharSequence)":", fuctionRule.getEx2(), fuctionRule.getEx1()), null);
            fuctionRule.setFuncId(funcId);
            SclFunctionRule hisSclFunctionRule = (SclFunctionRule)sclFunctionRuleMap.get(this.getRedisKey(fuctionRule.getType(), fuctionRule.getEx2(), fuctionRule.getEx1(), fuctionRule.getContent().getGroupCode(), fuctionRule.getCode()));
            if (null == hisSclFunctionRule) {
                fuctionRule.setId(IdUtil.getId());
                continue;
            }
            fuctionRule.setId(hisSclFunctionRule.getId());
            String hisExpression = hisSclFunctionRule.getContent().getExpression();
            String hisCondition = hisSclFunctionRule.getContent().getCondition();
            String hisErrorMessage = hisSclFunctionRule.getContent().getErrorMessage();
            String newExpression = fuctionRule.getContent().getExpression();
            String newCondition = fuctionRule.getContent().getCondition();
            String newErrorMessage = fuctionRule.getContent().getErrorMessage();
            if (!DigestUtil.md5Hex((String)(hisExpression + hisCondition + hisErrorMessage)).equals(DigestUtil.md5Hex((String)(newExpression + newCondition + newErrorMessage)))) continue;
            fuctionRule.getContent().setTranslate(TranslateDataMapper.INSTANCE.to(hisSclFunctionRule.getContent().getTranslate()));
            fuctionRule.getContent().setDependencyItems(hisSclFunctionRule.getContent().getDependencyItems());
        }
        formulas.removeIf(element -> null == element.getFuncId());
        List<SclFunctionRule> sclQueryCaseList = FormulaValidatorFunctionRuleMapper.INSTANCE.to(formulas);
        this.sclFunctionRuleMapper.insertOrUpdate(sclQueryCaseList);
        log.info("\u89e3\u6790\u89c4\u5219\u7ed3\u675f\uff1a{}", (Object)functionRuleTypeEnum.getType());
    }

    public void doFunctionRuleCovertRetry(Long productVersionId, String code, String type, int maxRetries) {
        int retryCount = 0;
        boolean doCovert = true;
        while (retryCount < maxRetries) {
            try {
                doCovert = this.doFunctionRuleCovert(productVersionId, code, type);
            }
            catch (Exception e) {
                log.error("\u5403\u6389\u5f02\u5e38", (Throwable)e);
            }
            if (!doCovert) break;
            log.info("\u7b2c {} \u6b21\u91cd\u8bd5\uff0c\u8c03\u7528\u5927\u6a21\u578b", (Object)(++retryCount));
        }
    }

    public boolean doFunctionRuleCovert(Long productVersionId, String code, String type) {
        List sclFunctionRules = this.sclFunctionRuleMapper.queryListByVersionAndCode(productVersionId, code, Boolean.valueOf(false), type);
        if (CollectionUtils.isEmpty((Collection)sclFunctionRules)) {
            log.info("\u5f53\u524d\u6ca1\u6709\u9700\u8981\u8f6c\u6362\u6570\u636e");
            return false;
        }
        int size = 10;
        if (FunctionRuleTypeEnum.VALIDATE.getType().equals(type)) {
            size = 5;
        }
        List sclFunctionRulesParts = ListUtil.partition((List)sclFunctionRules, (int)size);
        log.info("\u8f6c\u6362\u603b\u6279\u6b21\uff1a{}", (Object)sclFunctionRulesParts.size());
        for (List sclFunctionRulesPart : sclFunctionRulesParts) {
            try {
                this.functionRuleHandler(sclFunctionRulesPart, type);
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u62a5\u9519\u7ee7\u7eed\u6267\u884c", (Throwable)e);
            }
        }
        return true;
    }

    private void functionRuleHandler(List<SclFunctionRule> functionRules, String type) {
        ArrayList<SclFunctionRule> lmcFunctionRules = new ArrayList<SclFunctionRule>();
        for (SclFunctionRule rule : functionRules) {
            if (this.isTranslate(rule)) continue;
            this.ensureTranslateData(rule);
            ContentData content = rule.getContent();
            PythonCovertJavaDTO cachedDTO = (PythonCovertJavaDTO)CacheUtil.getData((TypeReference)new TypeReference<PythonCovertJavaDTO>(this){}, (String)this.getRedisKey(rule), (Object[])new Object[]{content.getExpression(), content.getCondition(), content.getErrorMessage()});
            if (cachedDTO != null) {
                this.applyTranslationData(rule.getType(), content.getTranslate(), cachedDTO);
                this.addDependencyItems(content, cachedDTO.getDependencyItems());
                continue;
            }
            lmcFunctionRules.add(rule);
        }
        if (!CollectionUtils.isEmpty(lmcFunctionRules)) {
            this.processLmcFunctionRules(lmcFunctionRules, type);
        }
        this.resolveDependencyItems(functionRules);
        this.generateClassList(functionRules);
        this.sclFunctionRuleMapper.updateById(functionRules);
    }

    private void ensureTranslateData(SclFunctionRule rule) {
        ContentData content = rule.getContent();
        if (content.getTranslate() == null) {
            content.setTranslate(new TranslateData());
        }
    }

    private void applyTranslationData(String type, TranslateData translate, PythonCovertJavaDTO dto) {
        if (dto.getTranslate() != null) {
            PythonCovertJavaTranslateDTO translateDTO = dto.getTranslate();
            translate.setSuccess(dto.getSuccess());
            if ("FORMULA".equals(type)) {
                translate.setExpression(StringUtils.hasText((String)translateDTO.getExecute()) ? translateDTO.getExecute() : null);
            } else if ("VALIDATE".equals(type)) {
                translate.setExpression(StringUtils.hasText((String)translateDTO.getValidate()) ? translateDTO.getValidate() : null);
                translate.setCondition(StringUtils.hasText((String)translateDTO.getCondition()) ? translateDTO.getCondition() : null);
                translate.setErrorMessage(StringUtils.hasText((String)translateDTO.getGetErrorMessage()) ? translateDTO.getGetErrorMessage() : null);
            }
        }
        translate.setError(!CollectionUtils.isEmpty((Collection)dto.getError()) ? dto.getError() : null);
        translate.setRemark(StringUtils.hasText((String)dto.getRemark()) ? dto.getRemark() : null);
    }

    private void addDependencyItems(ContentData content, Set<String> newDependencies) {
        if (!CollectionUtils.isEmpty(newDependencies)) {
            Set existing = content.getDependencyItems();
            if (CollectionUtils.isEmpty((Collection)existing)) {
                content.setDependencyItems(newDependencies);
            } else {
                existing.addAll(newDependencies);
            }
        }
    }

    private void processLmcFunctionRules(List<SclFunctionRule> lmcFunctionRules, String type) {
        List conversionResults = FunctionRuleTypeEnum.VALIDATE.getType().equalsIgnoreCase(type) ? this.codeIntelligentTransformationService.executePythonCovertJavaDialogue(this.getValidatorCode(lmcFunctionRules)) : this.codeIntelligentTransformationService.executePythonCovertJavaDialogue(this.getFormulaCode(lmcFunctionRules));
        Map resultMap = conversionResults.stream().collect(Collectors.toMap(PythonCovertJavaDTO::getBizCode, Function.identity()));
        for (SclFunctionRule rule : lmcFunctionRules) {
            if (this.isTranslate(rule)) continue;
            ContentData content = rule.getContent();
            PythonCovertJavaDTO resultDTO = (PythonCovertJavaDTO)resultMap.get(this.getRedisKey(rule));
            if (resultDTO == null) continue;
            this.applyTranslationData(rule.getType(), content.getTranslate(), resultDTO);
            this.addDependencyItems(content, resultDTO.getDependencyItems());
            if (!resultDTO.getSuccess().booleanValue()) continue;
            CacheUtil.setData((Object)resultDTO, (String)this.getRedisKey(rule), (Object[])new Object[]{content.getExpression(), content.getCondition(), content.getErrorMessage()});
        }
    }

    private String getValidatorCode(List<SclFunctionRule> formulas) {
        List<Map> codeExpressionList = formulas.stream().map(formula -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bizCode", this.getRedisKey((SclFunctionRule)formula));
            map.put("defaultTypeKey", formula.getEx2());
            map.put("validate", formula.getContent().getExpression());
            map.put("condition", formula.getContent().getCondition());
            map.put("getErrorMessage", formula.getContent().getErrorMessage());
            return map;
        }).toList();
        return JSONUtil.toJsonStr(codeExpressionList);
    }

    private String getFormulaCode(List<SclFunctionRule> formulas) {
        List<Map> codeExpressionList = formulas.stream().map(formula -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bizCode", this.getRedisKey((SclFunctionRule)formula));
            map.put("defaultTypeKey", formula.getEx2());
            String fieldSchema = formula.getFieldSchema();
            if (StringUtils.hasText((String)fieldSchema)) {
                map.put("execute", fieldSchema + " = " + formula.getContent().getExpression());
            } else {
                map.put("execute", formula.getContent().getExpression());
            }
            return map;
        }).toList();
        return JSONUtil.toJsonStr(codeExpressionList);
    }

    private String getRedisKey(SclFunctionRule sclFunctionRule) {
        return this.getRedisKey(sclFunctionRule.getType(), sclFunctionRule.getEx2(), sclFunctionRule.getEx1(), sclFunctionRule.getContent().getGroupCode(), sclFunctionRule.getCode());
    }

    private String getRedisKey(String type, String ex2, String ex1, String groupCode, String code) {
        return String.join((CharSequence)":", type, ex2, ex1, StringUtils.hasText((String)groupCode) ? groupCode : "", code);
    }

    public void resolveDependencyItems(Long productVersionId, String code, String type) {
        List sclFunctionRules = this.sclFunctionRuleMapper.queryListByVersionAndCode(productVersionId, code, null, type);
        this.resolveDependencyItems(sclFunctionRules);
        this.sclFunctionRuleMapper.updateById((Collection)sclFunctionRules);
    }

    public void resolveDependencyItems(List<SclFunctionRule> sclFunctionRules) {
        if (CollectionUtils.isEmpty(sclFunctionRules)) {
            log.info("\u5f53\u524d\u6ca1\u6709\u9700\u8981\u8f6c\u6362\u6570\u636e");
            return;
        }
        for (SclFunctionRule rule : sclFunctionRules) {
            Set dependencyItems;
            if (this.isTranslate(rule) || CollectionUtils.isEmpty((Collection)(dependencyItems = rule.getContent().getDependencyItems()))) continue;
            HashSet<String> newDependencyItems = new HashSet<String>();
            for (String dependencyItem : dependencyItems) {
                try {
                    newDependencyItems.add(JsonPathResolverUtil.resolve(rule.getFieldPath(), dependencyItem));
                }
                catch (Exception e) {
                    newDependencyItems.add(dependencyItem);
                    log.error("\u8bb0\u5f55\u8f6c\u6362\u5931\u8d25\u7684id\uff1a{}\uff0ccode\uff1a{}\uff0cdependencyItem\uff1a{}", new Object[]{rule.getId(), this.getRedisKey(rule), dependencyItem});
                }
            }
            rule.getContent().setDependencyItems(newDependencyItems);
        }
    }

    public void generateClassList(List<SclFunctionRule> sclFunctionRules) {
        if (CollectionUtil.isEmpty(sclFunctionRules)) {
            return;
        }
        for (SclFunctionRule rule : sclFunctionRules) {
            if (this.isTranslate(rule)) continue;
            HashMap<String, String> replacements = new HashMap<String, String>();
            if (FunctionRuleTypeEnum.FORMULA.getType().equals(rule.getType())) {
                replacements.put("TypeKey", rule.getEx2());
                replacements.put("Location", rule.getEx1());
                replacements.put("id", rule.getCode());
                replacements.put("path", rule.getFieldPath());
                replacements.put("schema", rule.getFieldSchema());
                replacements.put("groupCode", rule.getContent().getGroupCode() == null ? "" : rule.getContent().getGroupCode());
                dependencyItems = rule.getContent().getDependencyItems();
                if (CollectionUtil.isNotEmpty((Collection)dependencyItems)) {
                    list = new ArrayList();
                    for (Object s : dependencyItems) {
                        list.add(String.format("\"%s\"", s));
                    }
                    replacements.put("dependencyItems", "new String[]{" + String.join((CharSequence)",", list) + "}");
                } else {
                    replacements.put("dependencyItems", "null");
                }
                points = rule.getContent().getPoints();
                if (CollectionUtil.isNotEmpty((Collection)points)) {
                    list = new ArrayList();
                    s = points.iterator();
                    while (s.hasNext()) {
                        String s = (String)s.next();
                        list.add(String.format("\"%s\"", s));
                    }
                    replacements.put("points", "new String[]{" + String.join((CharSequence)",", list) + "}");
                } else {
                    replacements.put("points", "null");
                }
                if ((translate = rule.getContent().getTranslate()) == null || !Boolean.TRUE.equals(rule.getContent().getTranslate().getSuccess())) continue;
                String expression = translate.getExpression();
                replacements.put("execute", expression);
                rule.setTranslate(TemplateUtil.replaceTemplate(TemplateUtil.getTemplate("FORMULA"), replacements));
                rule.setClassFullName(String.format("com.digiwin.athenai.reactive.delegate.e10.formula.E10_%s_%s_%s", rule.getEx2(), rule.getEx1(), rule.getCode()));
            } else if (FunctionRuleTypeEnum.VALIDATE.getType().equals(rule.getType())) {
                replacements.put("TypeKey", rule.getEx2());
                replacements.put("id", rule.getCode());
                replacements.put("path", rule.getFieldPath());
                replacements.put("schema", rule.getFieldSchema());
                dependencyItems = rule.getContent().getDependencyItems();
                if (CollectionUtil.isNotEmpty((Collection)dependencyItems)) {
                    list = new ArrayList<String>();
                    translate = dependencyItems.iterator();
                    while (translate.hasNext()) {
                        s = (String)translate.next();
                        list.add(String.format("\"%s\"", s));
                    }
                    replacements.put("dependencyItems", "new String[]{" + String.join((CharSequence)",", list) + "}");
                } else {
                    replacements.put("dependencyItems", "null");
                }
                points = rule.getContent().getPoints();
                if (CollectionUtil.isNotEmpty((Collection)points)) {
                    list = new ArrayList<String>();
                    for (String s : points) {
                        list.add(String.format("\"%s\"", s));
                    }
                    replacements.put("points", "new String[]{" + String.join((CharSequence)",", list) + "}");
                } else {
                    replacements.put("points", "null");
                }
                if ((translate = rule.getContent().getTranslate()) == null || !Boolean.TRUE.equals(rule.getContent().getTranslate().getSuccess())) continue;
                replacements.put("condition", translate.getCondition());
                replacements.put("validate", translate.getExpression());
                replacements.put("errorMessage", translate.getErrorMessage());
                rule.setTranslate(TemplateUtil.replaceTemplate(TemplateUtil.getTemplate("VALIDATE"), replacements));
                rule.setClassFullName(String.format("com.digiwin.athenai.reactive.delegate.e10.formula.E10_%s_%s", rule.getEx2(), rule.getCode()));
            }
            Log.get().debug("\n" + rule.getTranslate(), new Object[0]);
        }
    }

    private boolean isTranslate(SclFunctionRule rule) {
        if (FunctionRuleTypeEnum.VALIDATE.getType().equals(rule.getType())) {
            if (Collections.disjoint(this.validatePoint, rule.getContent().getPoints())) {
                Log.get().info("\u6821\u9a8c\u4e0d\u9700\u8981\u8fdb\u884c\u7ffb\u8bd1\u6210java\uff0ccode\uff1a{}\uff0cpoint{}", new Object[]{this.getRedisKey(rule), JSONUtil.toJsonStr((Object)rule.getContent().getPoints())});
                return true;
            }
        } else if (Collections.disjoint(this.formulaPoint, rule.getContent().getPoints())) {
            Log.get().info("\u516c\u5f0f\u4e0d\u9700\u8981\u8fdb\u884c\u7ffb\u8bd1\u6210java\uff0ccode\uff1a{}\uff0cpoint{}", new Object[]{this.getRedisKey(rule), JSONUtil.toJsonStr((Object)rule.getContent().getPoints())});
            return true;
        }
        return false;
    }
}

