/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclApi;
import com.digiwin.athena.ai.generate.tools.db.bo.SclCommonInfoConfig;
import com.digiwin.athena.ai.generate.tools.db.bo.SclJobFunction;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclCommonInfoConfigMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobFunctionMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.programInfo.ProgramInfo;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.ApiObject;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.JobFunctionParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.dto.ActionInfo;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.dto.ActionInfos;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.dto.AuthorizationInfos;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.dto.ProgramAuthorizationContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.jobfunction.dto.ProgramAuthorizationInfo;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.CategoryEnum;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10JobAndApiFunctionObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10JobAndApiFunctionObjectServiceImpl.class);
    @Autowired
    private SclApiMapper sclApiMapper;
    @Autowired
    private SclCommonInfoConfigMapper sclCommonInfoConfigMapper;
    @Autowired
    private SclJobFunctionMapper sclJobFunctionMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.JOB_API_FUNCTION;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        Map<String, ProgramAuthorizationContainer> map = JobFunctionParser.singleParser(context.getE10Properties(), true);
        List<ProgramInfo> programInfoList = context.getProgramInfoList();
        List programInfos = programInfoList.stream().distinct().toList();
        Map jobMap = programInfos.stream().collect(Collectors.toMap(ProgramInfo::getId, Function.identity(), (existingValue, newValue) -> existingValue));
        List listByCategory = this.sclCommonInfoConfigMapper.getListByCategory(CategoryEnum.E10_API_FUNCTION.getCode());
        if (CollectionUtils.isEmpty((Collection)listByCategory)) {
            throw new RuntimeException("\u7f3a\u5c11\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e");
        }
        Map commonInfoConfigMap = listByCategory.stream().collect(Collectors.toMap(SclCommonInfoConfig::getActionName, Function.identity(), (existingValue, newValue) -> existingValue));
        HashMap<String, List<ApiObject>> allApi = new HashMap<String, List<ApiObject>>();
        ArrayList sclJobFunctions = new ArrayList();
        Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
        map.forEach((businessCode, programAuthorizationContainer) -> {
            HashMap businessToApiId = new HashMap();
            AuthorizationInfos authorizationInfos = programAuthorizationContainer.getAuthorizationInfos();
            if (!ObjectUtils.isEmpty((Object)authorizationInfos) && CollectionUtils.isNotEmpty(authorizationInfos.getProgramAuthorizationInfoList())) {
                Map<String, Long> jobsRel = context.getJobsRel();
                for (ProgramAuthorizationInfo programAuthorizationInfo : authorizationInfos.getProgramAuthorizationInfoList()) {
                    List<ActionInfo> actionInfoList;
                    String programId = programAuthorizationInfo.getProgramId();
                    ActionInfos actionInfos = programAuthorizationInfo.getActionInfos();
                    if (ObjectUtils.isEmpty((Object)actionInfos) || !CollectionUtils.isNotEmpty(actionInfoList = actionInfos.getActionInfoList()) || ObjectUtils.isEmpty((Object)jobsRel.get(programId))) continue;
                    for (ActionInfo actionInfo : actionInfoList) {
                        SclCommonInfoConfig sclCommonInfoConfig = (SclCommonInfoConfig)commonInfoConfigMap.get(actionInfo.getName());
                        if (ObjectUtils.isEmpty((Object)sclCommonInfoConfig) || ObjectUtils.isEmpty(businessObjectsRel.get(businessCode))) continue;
                        SclJobFunction sclJobFunction = new SclJobFunction();
                        sclJobFunction.setJobId(jobsRel.get(programId));
                        sclJobFunction.setProductVersionId(context.getSclProductVersion().getId());
                        sclJobFunction.setCode(actionInfo.getName());
                        sclJobFunction.setName(actionInfo.getDisplayName());
                        ProgramInfo programInfos1 = (ProgramInfo)jobMap.get(programId);
                        sclJobFunction.setDescription(programInfos1.getDisplayName() + actionInfo.getDisplayName());
                        sclJobFunction.setId(IdUtil.getId());
                        ArrayList<ApiObject> longs = (ArrayList<ApiObject>)businessToApiId.get(businessCode);
                        sclJobFunction.setWrite(sclCommonInfoConfig.isWrite());
                        if (CollectionUtils.isNotEmpty((Collection)longs)) {
                            List stringStream = longs.stream().map(ApiObject::getName).collect(Collectors.toList());
                            if (!stringStream.contains(sclCommonInfoConfig.getCode())) {
                                Long apiId = IdUtil.getId();
                                sclJobFunction.setApiId(apiId);
                                ApiObject apiObject = new ApiObject();
                                apiObject.setApiId(apiId);
                                apiObject.setDisplayName(sclCommonInfoConfig.getActionDesc());
                                apiObject.setName(sclCommonInfoConfig.getCode());
                                apiObject.setCode(sclCommonInfoConfig.getActionName());
                                longs.add(apiObject);
                            } else {
                                Optional<ApiObject> first = longs.stream().filter(res -> res.getName().equals(sclCommonInfoConfig.getCode())).findFirst();
                                sclJobFunction.setApiId(first.get().getApiId());
                            }
                        } else {
                            longs = new ArrayList<ApiObject>();
                            Long apiId = IdUtil.getId();
                            sclJobFunction.setApiId(apiId);
                            ApiObject apiObject = new ApiObject();
                            apiObject.setApiId(apiId);
                            apiObject.setName(sclCommonInfoConfig.getCode());
                            apiObject.setDisplayName(sclCommonInfoConfig.getActionDesc());
                            apiObject.setCode(sclCommonInfoConfig.getActionName());
                            longs.add(apiObject);
                            businessToApiId.put((String)businessCode, longs);
                            allApi.put((String)businessCode, (List<ApiObject>)longs);
                        }
                        sclJobFunctions.add(sclJobFunction);
                    }
                }
            }
        });
        if (!ObjectUtils.isEmpty(allApi)) {
            context.setAllApi(allApi);
            ArrayList sclApiList = new ArrayList();
            allApi.forEach((businessCode, apiList) -> apiList.forEach(apiObject -> {
                if (!ObjectUtils.isEmpty(businessObjectsRel.get(businessCode))) {
                    SclApi sclApi = new SclApi();
                    sclApi.setId(apiObject.getApiId());
                    sclApi.setBusinessObjectId((Long)businessObjectsRel.get(businessCode));
                    sclApi.setName(apiObject.getName());
                    sclApi.setDescription(apiObject.getDisplayName());
                    sclApi.setDisplayName(apiObject.getDisplayName());
                    sclApi.setProductVersionId(context.getSclProductVersion().getId());
                    sclApiList.add(sclApi);
                }
            }));
            this.sclApiMapper.insert(sclApiList);
        }
        if (CollectionUtils.isNotEmpty(sclJobFunctions)) {
            this.sclJobFunctionMapper.insert(sclJobFunctions);
        }
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.JOB_API_FUNCTION.getOrder();
    }

    public String desc() {
        return "\u3010API/\u4f5c\u4e1a\u914d\u7f6e\u3011";
    }
}

