/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.file.FileNameUtil;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntity;
import com.digiwin.athena.ai.generate.tools.db.bo.SclJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclUiEntity;
import com.digiwin.athena.ai.generate.tools.db.bo.SclUiEntityProperty;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityPropertyMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclUiEntityMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclUiEntityPropertyMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.ui.UiEntityParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.ui.dto.MetadataContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10UiEntityObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10UiEntityObjectServiceImpl.class);
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;
    @Autowired
    private SclEntityMapper sclEntityMapper;
    @Autowired
    private SclEntityPropertyMapper sclEntityPropertyMapper;
    @Autowired
    private SclUiEntityMapper sclUiEntityMapper;
    @Autowired
    private SclUiEntityPropertyMapper sclUiEntityPropertyMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.UI_ENTITY;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws Exception {
        List<String> typeKeys = context.getE10Properties().getTypeKeys();
        HashSet<String> businessCodes = new HashSet<String>(context.getBusinessCodeToJobCode().keySet());
        businessCodes.forEach(k -> {
            if (CollectionUtil.isNotEmpty((Collection)typeKeys)) {
                if (typeKeys.contains(k)) {
                    this.extracted(context, (String)k);
                }
            } else {
                this.extracted(context, (String)k);
            }
        });
    }

    private void extracted(E10ExecuteContext context, String k) {
        Long businessObjectId = context.getBusinessObjectsRel().get(k);
        if (businessObjectId != null) {
            List jobs = this.sclJobMapper.selectByBusinessObjectIds(List.of(businessObjectId));
            Set jobEx1CodeSet = jobs.stream().map(sclJob2 -> (String)StringUtils.defaultIfBlank((CharSequence)sclJob2.getEx1(), (CharSequence)sclJob2.getEx2())).collect(Collectors.toSet());
            Map<String, SclJob> sclJobEx1Map = jobs.stream().filter(o -> jobEx1CodeSet.contains(StringUtils.defaultIfBlank((CharSequence)o.getEx1(), (CharSequence)o.getEx2()))).collect(Collectors.toMap(sclJob1 -> (String)StringUtils.defaultIfBlank((CharSequence)sclJob1.getEx1(), (CharSequence)sclJob1.getEx2()), Function.identity()));
            List<Path> pathWithFileNameRoot = FileLister.getFilePathsWithFileName(context.getE10Properties().getUiEntityRoot() + "/" + k, "MetadataContainer.dcxml");
            Path rootPath = null;
            if (CollectionUtils.isNotEmpty(pathWithFileNameRoot)) {
                rootPath = pathWithFileNameRoot.getFirst();
            }
            HashMap<String, List<MetadataContainer.DataEntityType>> allUiDataEntityTypeMap = new HashMap<String, List<MetadataContainer.DataEntityType>>();
            Map<String, List<MetadataContainer.DataEntityType>> rootDataEntityTypeMap = this.parseDataEntityType(rootPath, false);
            for (String jobEx1Code : jobEx1CodeSet) {
                Map<String, List<MetadataContainer.DataEntityType>> uiDataEntityTypeMap = null;
                List<Path> pathWithFileNamePaths = FileLister.getFilePathsWithSuffixFileName(context.getE10Properties().getUiEntityRoot() + "/" + k, null, jobEx1Code + ".MetadataContainer.dcxml");
                if (CollectionUtils.isNotEmpty(pathWithFileNamePaths)) {
                    uiDataEntityTypeMap = this.parseDataEntityType(pathWithFileNamePaths.getFirst(), true);
                }
                if (uiDataEntityTypeMap == null) continue;
                allUiDataEntityTypeMap.putAll(uiDataEntityTypeMap);
            }
            this.parseUiEntity(context, businessObjectId, sclJobEx1Map, rootDataEntityTypeMap, allUiDataEntityTypeMap);
        }
    }

    private void parseUiEntity(E10ExecuteContext context, Long businessObjectId, Map<String, SclJob> sclJobEx1Map, Map<String, List<MetadataContainer.DataEntityType>> rootDataEntityTypeMap, Map<String, List<MetadataContainer.DataEntityType>> allUiDataEntityTypeMap) {
        Set<String> baseTypeNameSet = rootDataEntityTypeMap.values().stream().flatMap(Collection::parallelStream).map(MetadataContainer.DataEntityType::getName).collect(Collectors.toSet());
        for (String jobCodeEx1 : allUiDataEntityTypeMap.keySet()) {
            log.info("\u5f00\u59cb\u89e3\u6790\u4f5c\u4e1aUI\u5b9e\u4f53\uff1a{}", (Object)jobCodeEx1);
            ArrayList jobInsertSclUiEntityList = new ArrayList();
            ArrayList jobInsertSclUiEntityPropertyList = new ArrayList();
            ArrayList dataEntityTypes = new ArrayList(allUiDataEntityTypeMap.get(jobCodeEx1));
            Map<String, List<MetadataContainer.DataEntityType>> baseTypeNameMap = dataEntityTypes.stream().collect(Collectors.groupingBy(o -> (String)StringUtils.defaultIfBlank((CharSequence)o.getBaseTypeName(), (CharSequence)"")));
            baseTypeNameSet.forEach(rootName -> {
                List dataEntityTypeList = (List)baseTypeNameMap.get(rootName);
                if (CollectionUtils.isNotEmpty((Collection)dataEntityTypeList)) {
                    dataEntityTypes.removeAll(dataEntityTypeList);
                    for (MetadataContainer.DataEntityType dataEntityType : dataEntityTypeList) {
                        SclUiEntity sclUiEntity = this.convertUiEntity(jobInsertSclUiEntityList, context, businessObjectId, (SclJob)sclJobEx1Map.get(jobCodeEx1), dataEntityType);
                        List<MetadataContainer.SimpleProperty> simpleProperties = dataEntityType.getProperties().getSimpleProperties();
                        this.saveSimpleProperty(jobInsertSclUiEntityList, jobInsertSclUiEntityPropertyList, sclUiEntity, simpleProperties);
                        List<MetadataContainer.CollectionProperty> collectionProperties = dataEntityType.getProperties().getCollectionProperties();
                        this.saveCollectionProperty(jobInsertSclUiEntityList, jobInsertSclUiEntityPropertyList, context, businessObjectId, (SclJob)sclJobEx1Map.get(jobCodeEx1), sclUiEntity, dataEntityTypes, collectionProperties);
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(jobInsertSclUiEntityList)) {
                jobInsertSclUiEntityList.forEach(item -> {
                    SclEntity sclEntity = this.sclEntityMapper.selectByBusinessObjectIdAndName(businessObjectId, item.getName());
                    if (sclEntity != null) {
                        item.setDisplayName(sclEntity.getDisplayName());
                        item.setDescription(sclEntity.getDescription());
                        item.setEntityType(sclEntity.getEntityType());
                        List sclEntityProperties = this.sclEntityPropertyMapper.selectByEntityId(sclEntity.getId());
                        List<SclUiEntityProperty> sclUiEntityProperties = sclEntityProperties.stream().map(o -> {
                            SclUiEntityProperty sclUiEntityProperty = new SclUiEntityProperty();
                            BeanUtils.copyProperties((Object)o, (Object)sclUiEntityProperty);
                            sclUiEntityProperty.setId(this.getId());
                            sclUiEntityProperty.setEntityId(item.getId());
                            sclUiEntityProperty.setProductVersionId(context.getSclProductVersion().getId());
                            return sclUiEntityProperty;
                        }).toList();
                        jobInsertSclUiEntityPropertyList.addAll(sclUiEntityProperties);
                    }
                });
                this.sclUiEntityMapper.insert(jobInsertSclUiEntityList);
            }
            if (!CollectionUtils.isNotEmpty(jobInsertSclUiEntityPropertyList)) continue;
            List insert = jobInsertSclUiEntityPropertyList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(property -> property.getEntityId() + "_" + property.getName(), property -> property, (existing, replacement) -> replacement), map -> new ArrayList(map.values())));
            this.sclUiEntityPropertyMapper.insert((Collection)insert);
        }
    }

    private SclUiEntity convertUiEntity(List<SclUiEntity> jobInsertSclUiEntityList, E10ExecuteContext context, Long businessObjectId, SclJob sclJob, MetadataContainer.DataEntityType dataEntityType) {
        Optional<SclUiEntity> optionalSclUiEntity = jobInsertSclUiEntityList.stream().filter(o -> o.getJobId().equals(sclJob.getId()) && o.getName().equals(dataEntityType.getBaseTypeName())).findFirst();
        if (optionalSclUiEntity.isPresent()) {
            return optionalSclUiEntity.get();
        }
        SclUiEntity sclUiEntity = new SclUiEntity();
        sclUiEntity.setId(this.getId());
        sclUiEntity.setEntityType(E10UiEntityObjectServiceImpl.convertEntityType(dataEntityType));
        sclUiEntity.setJobId(sclJob.getId());
        sclUiEntity.setDescription(dataEntityType.getDisplayName());
        sclUiEntity.setName(dataEntityType.getBaseTypeName());
        sclUiEntity.setBusinessObjectId(businessObjectId);
        sclUiEntity.setProductVersionId(context.getSclProductVersion().getId());
        sclUiEntity.setDisplayName((String)StringUtils.defaultIfBlank((CharSequence)dataEntityType.getDisplayName(), (CharSequence)dataEntityType.getBaseTypeName()));
        jobInsertSclUiEntityList.add(sclUiEntity);
        return sclUiEntity;
    }

    private void saveCollectionProperty(List<SclUiEntity> jobInsertSclUiEntityList, List<SclUiEntityProperty> jobInsertSclUiEntityPropertyList, E10ExecuteContext context, Long businessObjectId, SclJob sclJob, SclUiEntity sclUiEntity, List<MetadataContainer.DataEntityType> dataEntityTypes, List<MetadataContainer.CollectionProperty> collectionProperties) {
        if (CollectionUtils.isEmpty(collectionProperties)) {
            return;
        }
        Map<String, List<MetadataContainer.DataEntityType>> baseTypeNameMap = dataEntityTypes.stream().collect(Collectors.groupingBy(o -> (String)StringUtils.defaultIfBlank((CharSequence)o.getBaseTypeName(), (CharSequence)"")));
        collectionProperties.forEach(o -> {
            SclUiEntityProperty sclUiEntityProperty = new SclUiEntityProperty();
            sclUiEntityProperty.setId(this.getId());
            sclUiEntityProperty.setPropertyType("collection");
            sclUiEntityProperty.setName(o.getName());
            sclUiEntityProperty.setDisplayName((String)StringUtils.defaultIfBlank((CharSequence)o.getAlias(), (CharSequence)o.getName()));
            sclUiEntityProperty.setRelationEntityName(o.getName());
            sclUiEntityProperty.setProductVersionId(context.getSclProductVersion().getId());
            sclUiEntityProperty.setEntityId(sclUiEntity.getId());
            sclUiEntityProperty.setDataType("array");
            List dataEntityTypeList = (List)baseTypeNameMap.get(o.getName());
            if (dataEntityTypeList != null) {
                dataEntityTypes.removeAll(dataEntityTypeList);
                dataEntityTypeList.forEach(dataEntityType -> {
                    SclUiEntity uiEntity = this.convertUiEntity(jobInsertSclUiEntityList, context, businessObjectId, sclJob, (MetadataContainer.DataEntityType)dataEntityType);
                    this.saveSimpleProperty(jobInsertSclUiEntityList, jobInsertSclUiEntityPropertyList, uiEntity, dataEntityType.getProperties().getSimpleProperties());
                    this.saveCollectionProperty(jobInsertSclUiEntityList, jobInsertSclUiEntityPropertyList, context, businessObjectId, sclJob, uiEntity, dataEntityTypes, dataEntityType.getProperties().getCollectionProperties());
                });
            }
            jobInsertSclUiEntityPropertyList.add(sclUiEntityProperty);
        });
    }

    private void saveSimpleProperty(List<SclUiEntity> jobInsertSclUiEntityList, List<SclUiEntityProperty> jobInsertSclUiEntityPropertyList, SclUiEntity sclUiEntity, List<MetadataContainer.SimpleProperty> simpleProperties) {
        if (CollectionUtils.isEmpty(simpleProperties)) {
            return;
        }
        simpleProperties.forEach(o -> {
            SclUiEntityProperty sclUiEntityProperty = new SclUiEntityProperty();
            sclUiEntityProperty.setEntityId(sclUiEntity.getId());
            sclUiEntityProperty.setDataType((String)StringUtils.defaultIfBlank((CharSequence)o.getDbType(), (CharSequence)"String"));
            sclUiEntityProperty.setDigit(o.getScale());
            sclUiEntityProperty.setAlias(o.getName());
            sclUiEntityProperty.setId(this.getId());
            sclUiEntityProperty.setDescription(o.getDisplayName());
            sclUiEntityProperty.setDefaultValue(o.getDefaultValue());
            sclUiEntityProperty.setPropertyType("simple");
            sclUiEntityProperty.setName(o.getName());
            sclUiEntityProperty.setDisplayName((String)StringUtils.defaultIfBlank((CharSequence)o.getDisplayName(), (CharSequence)o.getName()));
            sclUiEntityProperty.setLength(o.getSize());
            sclUiEntityProperty.setProductVersionId(sclUiEntity.getProductVersionId());
            jobInsertSclUiEntityPropertyList.add(sclUiEntityProperty);
        });
    }

    private static String convertEntityType(MetadataContainer.DataEntityType dataEntityType) {
        String dataEntityTypeType = dataEntityType.getDataEntityTypeType();
        if (StringUtils.isBlank((CharSequence)dataEntityTypeType) || dataEntityTypeType.equals("None") || dataEntityTypeType.equals("Root")) {
            return "Root";
        }
        if (dataEntityTypeType.equals("CollectionItem")) {
            return "CollectionItem";
        }
        if (dataEntityTypeType.equals("Complex")) {
            return "Complex";
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684dataEntityTypeType\uff1a" + dataEntityTypeType);
    }

    private Map<String, List<MetadataContainer.DataEntityType>> parseDataEntityType(Path path, boolean onlyView) {
        List<MetadataContainer.DataEntityType> dataEntityTypes;
        if (path == null) {
            return Map.of();
        }
        MetadataContainer container = UiEntityParser.readMetadataFromXml(path);
        String fileName = FileNameUtil.getName((File)path.toFile());
        String jobCodeEx1 = "";
        if (!fileName.equals("MetadataContainer.dcxml")) {
            jobCodeEx1 = fileName.replace(".MetadataContainer.dcxml", "");
        }
        if ((dataEntityTypes = container.getDataEntityTypes()) != null) {
            List<MetadataContainer.DataEntityType> viewDataEntityTypeList = dataEntityTypes.stream().filter(o -> !onlyView || o.getDomain().equals("View")).toList();
            return Map.of(jobCodeEx1, viewDataEntityTypeList);
        }
        return Map.of();
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.UI_ENTITY.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.UI_ENTITY.getDesc();
    }
}

