/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub;

import com.digiwin.athena.ai.generate.tools.db.bo.SclCommonInfoConfig;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntity;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntityProperty;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclCommonInfoConfigMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityPropertyMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityRelationMapper;
import com.digiwin.athena.ai.generate.tools.e10.util.GroupObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataPropertyLogicalFk;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub.EntitySubObject;
import com.digiwin.athena.ai.generate.tools.enums.CategoryEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10EntityPropertyObjectServiceImpl
implements EntitySubObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10EntityPropertyObjectServiceImpl.class);
    @Autowired
    private SclEntityPropertyMapper sclEntityPropertyMapper;
    @Autowired
    private SclEntityMapper sclEntityMapper;
    @Value(value="${e10.entity.group.size:1}")
    private int groupSize;
    @Autowired
    private SclEntityRelationMapper sclEntityRelationMapper;
    @Autowired
    private SclCommonInfoConfigMapper sclCommonInfoConfigMapper;

    private static void entity(E10ExecuteContext context, DataEntity dataEntity, Map<String, Long> entityIdsRel, Map<String, Long> businessObjectsRel, List<SclEntity> sclEntities) {
        SclEntity sclEntity = new SclEntity();
        sclEntity.setId(dataEntity.getId());
        sclEntity.setEntityType(dataEntity.getDataEntityTypeType());
        entityIdsRel.put(ObjectUtils.isEmpty((Object)dataEntity.getAlias()) ? dataEntity.getName() : dataEntity.getAlias(), sclEntity.getId());
        sclEntity.setProductVersionId(context.getSclProductVersion().getId());
        sclEntity.setName(ObjectUtils.isEmpty((Object)dataEntity.getAlias()) ? dataEntity.getName() : dataEntity.getAlias());
        if (!ObjectUtils.isEmpty((Object)dataEntity.getDisplayName())) {
            sclEntity.setDisplayName(dataEntity.getDisplayName());
        } else {
            sclEntity.setDisplayName(dataEntity.getName());
        }
        sclEntity.setDescription(dataEntity.getDescription());
        Long parentId = dataEntity.getParentId();
        sclEntity.setParentId(Long.valueOf(parentId == null ? 0L : parentId));
        sclEntity.setBusinessObjectId(businessObjectsRel.get(dataEntity.getBusinessCode()));
        sclEntities.add(sclEntity);
    }

    private static void columns(E10ExecuteContext context, DataEntity dataEntity, Map<String, Long> dicCodeIdRel, Map<String, Long> entityFieldIdsRel, List<SclEntityProperty> entityFields, Map<String, SclCommonInfoConfig> commonInfoConfigMap) {
        List<DataProperty> columns = dataEntity.getColumns();
        if (CollectionUtils.isNotEmpty(columns)) {
            List columList = columns.stream().distinct().collect(Collectors.toList());
            for (DataProperty column : columList) {
                Long id = entityFieldIdsRel.get(dataEntity.getName() + "&" + column.getName());
                SclEntityProperty sclEntityProperty = new SclEntityProperty();
                sclEntityProperty.setEntityId(dataEntity.getId());
                sclEntityProperty.setId(id);
                sclEntityProperty.setPropertyType(commonInfoConfigMap.get(column.getPropertyType()).getCode());
                sclEntityProperty.setProductVersionId(context.getSclProductVersion().getId());
                sclEntityProperty.setName(ObjectUtils.isEmpty((Object)column.getAlias()) ? column.getName() : column.getAlias());
                sclEntityProperty.setDisplayName(ObjectUtils.isEmpty((Object)column.getDisplayName()) ? column.getName() : column.getDisplayName());
                sclEntityProperty.setDescription(column.getDescription());
                sclEntityProperty.setDataType(ObjectUtils.isEmpty((Object)column.getDbType()) ? "String" : column.getDbType());
                if ("ComplexProperty".equals(column.getPropertyType())) {
                    sclEntityProperty.setRelationEntityName(column.getDataEntityTypeName());
                    sclEntityProperty.setDataType(ObjectUtils.isEmpty((Object)column.getDbType()) ? "Object" : column.getDbType());
                }
                if ("CollectionProperty".equals(column.getPropertyType())) {
                    sclEntityProperty.setRelationEntityName(column.getItemDataEntityTypeName());
                }
                if ("ReferenceProperty".equals(column.getPropertyType())) {
                    // empty if block
                }
                sclEntityProperty.setDefaultValue(column.getDefaultValue());
                sclEntityProperty.setDigit(column.getScale());
                String primaryKey = dataEntity.getPrimaryKey();
                sclEntityProperty.setIsPrimaryKey(Boolean.valueOf(!ObjectUtils.isEmpty((Object)primaryKey) && primaryKey.equals(column.getAlias())));
                sclEntityProperty.setDictId(dicCodeIdRel.get(column.getPickListType()));
                DataPropertyLogicalFk logicalFk = column.getLogicalFk();
                if (!ObjectUtils.isEmpty((Object)logicalFk)) {
                    sclEntityProperty.setRelationFieldId(entityFieldIdsRel.get(logicalFk.getTableName() + "&" + logicalFk.getColumnName()));
                }
                sclEntityProperty.setIsRequired(Boolean.valueOf(!ObjectUtils.isEmpty((Object)column.getIsNullable())));
                if (ObjectUtils.isEmpty((Object)column.getIsUnique())) {
                    sclEntityProperty.setIsUnique(Boolean.valueOf(false));
                } else {
                    boolean aTrue = column.getIsUnique().equalsIgnoreCase("true");
                    sclEntityProperty.setIsUnique(Boolean.valueOf(aTrue));
                }
                sclEntityProperty.setLength(column.getSize());
                entityFields.add(sclEntityProperty);
            }
        }
    }

    @Override
    public Boolean enable() {
        return true;
    }

    @Override
    public void execute(E10ExecuteContext context, List<DataEntity> allDataEntitys, Map<String, DataEntity> dataEntityMap) {
        try {
            Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
            Map<String, Long> dicCodeIdRel = context.getDicCodeIdRel();
            Map<String, DataEntity> entityMap = dataEntityMap;
            HashMap<String, Long> entityFieldIdsRel = context.getEntityFieldIdsRel();
            HashMap<String, Long> entityIdsRel = new HashMap<String, Long>();
            List listByCategory = this.sclCommonInfoConfigMapper.getListByCategory(CategoryEnum.E10_ENTITY_PROPERTY_TYPE.getCode());
            if (CollectionUtils.isEmpty((Collection)listByCategory)) {
                throw new RuntimeException("\u7f3a\u5c11\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e");
            }
            Map<String, SclCommonInfoConfig> commonInfoConfigMap = listByCategory.stream().collect(Collectors.toMap(SclCommonInfoConfig::getActionName, Function.identity(), (existingValue, newValue) -> existingValue));
            List<Map<String, DataEntity>> maps = GroupObjectUtil.groupMapByKeyCountWithStreams(entityMap, this.groupSize);
            for (Map<String, DataEntity> entity : maps) {
                this.saveData(context, entity, businessObjectsRel, entityIdsRel, dicCodeIdRel, entityFieldIdsRel, commonInfoConfigMap);
            }
            context.setEntityIdsRel(entityIdsRel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveData(E10ExecuteContext context, Map<String, DataEntity> entity, Map<String, Long> businessObjectsRel, Map<String, Long> entityIdsRel, Map<String, Long> dicCodeIdRel, Map<String, Long> entityFieldIdsRel, Map<String, SclCommonInfoConfig> commonInfoConfigMap) {
        try {
            ArrayList sclEntities = new ArrayList();
            ArrayList entityFields = new ArrayList();
            entity.forEach((name, dataEntity) -> {
                if (!ObjectUtils.isEmpty(businessObjectsRel.get(dataEntity.getBusinessCode()))) {
                    E10EntityPropertyObjectServiceImpl.entity(context, dataEntity, entityIdsRel, businessObjectsRel, sclEntities);
                    E10EntityPropertyObjectServiceImpl.columns(context, dataEntity, dicCodeIdRel, entityFieldIdsRel, entityFields, commonInfoConfigMap);
                }
            });
            this.sclEntityMapper.insert(sclEntities);
            this.sclEntityPropertyMapper.insert(entityFields);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Integer stepIndex() {
        return 0;
    }

    public String desc() {
        return "-->\u3010\u5b9e\u4f53-\u5c5e\u6027\u3011<--";
    }
}

