/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntityRelation;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityRelationMapper;
import com.digiwin.athena.ai.generate.tools.e10.util.GroupObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DicProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.InfoDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.RelationDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub.EntitySubObject;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10EntityRelationObjectServiceImpl
implements EntitySubObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10EntityRelationObjectServiceImpl.class);
    @Autowired
    private SclEntityRelationMapper sclEntityRelationMapper;
    @Value(value="${e10.entity.group.size:1}")
    private int groupSize;
    private static String COLLECTION_DESC = "\u4e00\u5f20%s\u53ef\u4ee5\u5305\u542b\u591a\u884c%s";
    private static String SIMPLE_REFERENCE_DESC = "\u6bcf\u5f20%s\u90fd\u901a\u8fc7\u5b57\u6bb5%s\u5173\u8054\u4e00\u4e2a%s";
    private static final String COMPLEX_DESC = "\u5f53\u6765\u6e90\u7c7b\u578b\u4e3a%s\u65f6\uff0c\u5173\u8054%s";

    private static void columns(E10ExecuteContext context, DataEntity dataEntity, Map<String, DataEntity> entityMap, Map<String, Long> entityIdsRel, List<SclEntityRelation> entityRules) {
        List<DataProperty> columns = dataEntity.getColumns();
        if (CollectionUtils.isNotEmpty(columns)) {
            List columList = columns.stream().distinct().collect(Collectors.toList());
            for (DataProperty column : columList) {
                if ("ComplexProperty".equals(column.getPropertyType())) {
                    E10EntityRelationObjectServiceImpl.setComplexReferenceDesc(dataEntity, entityMap, column, entityRules, context, entityIdsRel);
                }
                if ("CollectionProperty".equals(column.getPropertyType())) {
                    if (ObjectUtils.isEmpty((Object)entityMap.get(column.getItemDataEntityTypeName()))) {
                        log.warn("\u5c5e\u6027\u7c7b\u578b\u4e3a\uff1aCollectionProperty\uff0c\u4e1a\u52a1\u5bf9\u8c61{}\u4e0b\u7684\uff0c{}\u5b9e\u4f53\u4e0d\u5b58\u5728", (Object)dataEntity.getBusinessCode(), (Object)column.getItemDataEntityTypeName());
                        continue;
                    }
                    Long id = entityMap.get(column.getItemDataEntityTypeName()).getId();
                    if (entityIdsRel.containsValue(id)) {
                        E10EntityRelationObjectServiceImpl.setCollectionDesc(dataEntity, entityMap, column, entityRules, context.getSclProductVersion().getId());
                    }
                }
                if (!"ReferenceProperty".equals(column.getPropertyType())) continue;
                List<String> list = Arrays.stream(column.getReferenceToName().split("\\.")).toList();
                String entityName = list.getLast();
                DataEntity dataEntity1 = entityMap.get(entityName);
                if (dataEntity1 != null && !entityIdsRel.containsValue(dataEntity1.getId())) {
                    log.warn("\u5c5e\u6027\u7c7b\u578b\u4e3a\uff1aReferenceProperty\uff0c\u4e1a\u52a1\u5bf9\u8c61{}\u4e0b\u7684\uff0c{}\u5b9e\u4f53\uff0c\u7684\u5c5e\u6027{}", new Object[]{dataEntity1.getBusinessCode(), dataEntity1.getName(), column.getName()});
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)dataEntity1) || CollectionUtils.isEmpty(dataEntity1.getColumns())) continue;
                E10EntityRelationObjectServiceImpl.setSimpleReferenceDesc(dataEntity, entityMap, column, entityRules, context.getSclProductVersion().getId());
            }
        }
    }

    private static void setComplexReferenceDesc(DataEntity dataEntity, Map<String, DataEntity> entityMap, DataProperty column, List<SclEntityRelation> entityRules, E10ExecuteContext context, Map<String, Long> entityIdsRel) {
        List<DicProperty> dicProperties = context.getDicPropertyMap().get(column.getPickListType());
        if (CollectionUtils.isNotEmpty(dicProperties)) {
            for (DicProperty res : dicProperties) {
                List<String> list = Arrays.stream(res.getId().split("\\.")).toList();
                String entity = list.getLast();
                DataEntity dataEntity1 = entityMap.get(entity);
                if (dataEntity1 == null) continue;
                if (!entityIdsRel.containsValue(dataEntity1.getId())) {
                    log.warn("\u5c5e\u6027\u7c7b\u578b\u4e3a\uff1aComplexProperty\uff0c\u4e1a\u52a1\u5bf9\u8c61{}\u4e0b\u7684\uff0c{}\u5b9e\u4f53,\u5b57\u5178\u503c{}", new Object[]{dataEntity1.getBusinessCode(), dataEntity1.getName(), res.getId()});
                    continue;
                }
                SclEntityRelation sclEntityRelation = new SclEntityRelation();
                sclEntityRelation.setId(IdUtil.getId());
                sclEntityRelation.setType("reference");
                sclEntityRelation.setEntityId(dataEntity.getId());
                sclEntityRelation.setPropertyName(column.getName());
                sclEntityRelation.setProductVersionId(context.getSclProductVersion().getId());
                InfoDTO fromRtk = new InfoDTO();
                fromRtk.setType("property");
                fromRtk.setName(column.getName() + ".RTK");
                InfoDTO joinRtk = new InfoDTO();
                joinRtk.setType("constant");
                joinRtk.setName(res.getId());
                RelationDTO relationDTORtk = new RelationDTO();
                relationDTORtk.setJoin(joinRtk);
                relationDTORtk.setFrom(fromRtk);
                InfoDTO fromRoid = new InfoDTO();
                fromRoid.setType("property");
                fromRoid.setName(column.getName() + ".ROid");
                InfoDTO joinRoid = new InfoDTO();
                joinRoid.setType("property");
                joinRoid.setValue(dataEntity1.getPrimaryKey());
                String displayName = "";
                if ("CollectionItem".equals(dataEntity1.getDataEntityTypeType())) {
                    Optional<DataProperty> first;
                    List<DataProperty> bindingCollectionProperty = dataEntity1.getBindingCollectionProperty();
                    if (CollectionUtils.isNotEmpty(bindingCollectionProperty) && (first = bindingCollectionProperty.stream().filter(dataProperty -> entity.equals(dataProperty.getName())).findFirst()).isPresent()) {
                        DataProperty dataProperty2 = first.get();
                        displayName = dataProperty2.getDisplayName();
                    }
                } else {
                    displayName = ObjectUtils.isEmpty((Object)dataEntity1.getDisplayName()) ? dataEntity1.getName() : dataEntity1.getDisplayName();
                }
                RelationDTO relationDTORoid = new RelationDTO();
                relationDTORoid.setFrom(fromRoid);
                relationDTORoid.setJoin(joinRoid);
                ArrayList<RelationDTO> arrayList = new ArrayList<RelationDTO>();
                arrayList.add(relationDTORtk);
                arrayList.add(relationDTORoid);
                sclEntityRelation.setJoinEntityId(dataEntity1.getId());
                sclEntityRelation.setRelations(JSON.toJSONString(arrayList));
                sclEntityRelation.setDescription(String.format(COMPLEX_DESC, ObjectUtils.isEmpty((Object)res.getDisplayName()) ? res.getId() : res.getDisplayName(), displayName));
                entityRules.add(sclEntityRelation);
            }
        }
    }

    private static void setSimpleReferenceDesc(DataEntity dataEntity, Map<String, DataEntity> entityMap, DataProperty column, List<SclEntityRelation> entityRules, Long productVersionId) {
        List<String> list = Arrays.stream(column.getReferenceToName().split("\\.")).toList();
        String entityName = list.getLast();
        DataEntity dataEntity1 = entityMap.get(entityName);
        SclEntityRelation sclEntityRelation = new SclEntityRelation();
        sclEntityRelation.setId(IdUtil.getId());
        sclEntityRelation.setType("reference");
        sclEntityRelation.setProductVersionId(productVersionId);
        sclEntityRelation.setEntityId(dataEntity.getId());
        sclEntityRelation.setPropertyName(column.getName());
        InfoDTO from = new InfoDTO();
        from.setType("property");
        from.setName(column.getName());
        InfoDTO join = new InfoDTO();
        join.setType("property");
        join.setName(column.getReferenceToNameProperty());
        RelationDTO relationDTO = new RelationDTO();
        relationDTO.setFrom(from);
        relationDTO.setJoin(join);
        ArrayList<RelationDTO> arrayList = new ArrayList<RelationDTO>();
        arrayList.add(relationDTO);
        sclEntityRelation.setRelations(JSON.toJSONString(arrayList));
        String displayName = "";
        if ("CollectionItem".equals(dataEntity1.getDataEntityTypeType())) {
            Optional<DataProperty> first;
            List<DataProperty> bindingCollectionProperty = dataEntity1.getBindingCollectionProperty();
            if (CollectionUtils.isNotEmpty(bindingCollectionProperty) && (first = bindingCollectionProperty.stream().filter(res -> entityName.equals(res.getName())).findFirst()).isPresent()) {
                DataProperty dataProperty = first.get();
                displayName = dataProperty.getDisplayName();
            }
        } else {
            displayName = ObjectUtils.isEmpty((Object)dataEntity1.getDisplayName()) ? dataEntity1.getName() : dataEntity1.getDisplayName();
        }
        sclEntityRelation.setJoinEntityId(dataEntity1.getId());
        sclEntityRelation.setDescription(String.format(SIMPLE_REFERENCE_DESC, ObjectUtils.isEmpty((Object)dataEntity.getDisplayName()) ? dataEntity.getName() : dataEntity.getDisplayName(), column.getDisplayName(), displayName));
        entityRules.add(sclEntityRelation);
    }

    private static void setCollectionDesc(DataEntity dataEntity, Map<String, DataEntity> entityMap, DataProperty column, List<SclEntityRelation> entityRules, Long productVersionId) {
        SclEntityRelation sclEntityRelation = new SclEntityRelation();
        sclEntityRelation.setId(IdUtil.getId());
        sclEntityRelation.setType("collection");
        sclEntityRelation.setProductVersionId(productVersionId);
        sclEntityRelation.setEntityId(dataEntity.getId());
        sclEntityRelation.setPropertyName(column.getName());
        InfoDTO from = new InfoDTO();
        from.setType("property");
        from.setName(dataEntity.getPrimaryKey());
        InfoDTO join = new InfoDTO();
        join.setType("property");
        join.setName(dataEntity.getPrimaryKey());
        RelationDTO relationDTO = new RelationDTO();
        relationDTO.setFrom(from);
        relationDTO.setJoin(join);
        ArrayList<RelationDTO> arrayList = new ArrayList<RelationDTO>();
        arrayList.add(relationDTO);
        sclEntityRelation.setRelations(JSON.toJSONString(arrayList));
        sclEntityRelation.setJoinEntityId(entityMap.get(column.getItemDataEntityTypeName()).getId());
        sclEntityRelation.setDescription(String.format(COLLECTION_DESC, ObjectUtils.isEmpty((Object)dataEntity.getDisplayName()) ? dataEntity.getName() : dataEntity.getDisplayName(), ObjectUtils.isEmpty((Object)column.getDisplayName()) ? column.getName() : column.getDisplayName()));
        entityRules.add(sclEntityRelation);
    }

    @Override
    public Boolean enable() {
        return true;
    }

    @Override
    public void execute(E10ExecuteContext context, List<DataEntity> allDataEntitys, Map<String, DataEntity> dataEntityMap) {
        try {
            Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
            if (CollectionUtils.isNotEmpty(allDataEntitys)) {
                Map<String, DataEntity> entityMap = dataEntityMap;
                Map<String, Long> entityIdsRel = context.getEntityIdsRel();
                List<Map<String, DataEntity>> maps = GroupObjectUtil.groupMapByKeyCountWithStreams(dataEntityMap, 2);
                for (Map<String, DataEntity> entity : maps) {
                    this.saveData(context, entity, businessObjectsRel, entityMap, entityIdsRel);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveData(E10ExecuteContext context, Map<String, DataEntity> entity, Map<String, Long> businessObjectsRel, Map<String, DataEntity> entityMap, Map<String, Long> entityIdsRel) {
        try {
            ArrayList entityRelations = new ArrayList();
            entity.forEach((name, dataEntity) -> {
                if (!name.equals("ReferToEntity") && !ObjectUtils.isEmpty(businessObjectsRel.get(dataEntity.getBusinessCode()))) {
                    E10EntityRelationObjectServiceImpl.columns(context, dataEntity, entityMap, entityIdsRel, entityRelations);
                }
            });
            this.sclEntityRelationMapper.insert(entityRelations);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Integer stepIndex() {
        return 2;
    }

    public String desc() {
        return "-->\u3010\u5b9e\u4f53-\u5173\u7cfb\u3011<--";
    }
}

