/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub;

import com.digiwin.athena.ai.generate.tools.db.bo.SclCommonInfoConfig;
import com.digiwin.athena.ai.generate.tools.db.bo.SclTable;
import com.digiwin.athena.ai.generate.tools.db.bo.SclTableField;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclCommonInfoConfigMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclTableFieldMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclTableMapper;
import com.digiwin.athena.ai.generate.tools.e10.util.GroupObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataPropertyLogicalFk;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub.EntitySubObject;
import com.digiwin.athena.ai.generate.tools.enums.CategoryEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10TableColumObjectServiceImpl
implements EntitySubObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10TableColumObjectServiceImpl.class);
    @Autowired
    private SclTableMapper sclTableMapper;
    @Autowired
    private SclTableFieldMapper sclTableFieldMapper;
    @Value(value="${e10.entity.group.size:1}")
    private int groupSize;
    @Autowired
    private SclCommonInfoConfigMapper sclCommonInfoConfigMapper;

    private static List<SclTable> entity(E10ExecuteContext context, DataEntity dataEntity, Map<String, Long> entityIdsRel, Map<String, Long> businessObjectsRel, List<SclTable> sclEntities, Map<String, DataEntity> entityMap) {
        List<DataProperty> bindingCollectionProperty = dataEntity.getBindingCollectionProperty();
        ArrayList<SclTable> bindingCollectionPropertySclTable = new ArrayList<SclTable>();
        if (CollectionUtils.isNotEmpty(bindingCollectionProperty) && !"Root".equals(dataEntity.getDataEntityTypeType())) {
            for (DataProperty dataProperty : bindingCollectionProperty) {
                SclTable sclTable = new SclTable();
                sclTable.setId(IdUtil.getId());
                entityIdsRel.put(ObjectUtils.isEmpty((Object)dataProperty.getAlias()) ? dataProperty.getName() : dataProperty.getAlias(), sclTable.getId());
                sclTable.setProductVersionId(context.getSclProductVersion().getId());
                sclTable.setName(ObjectUtils.isEmpty((Object)dataProperty.getAlias()) ? dataProperty.getName() : dataProperty.getAlias());
                if (!ObjectUtils.isEmpty((Object)dataEntity.getDisplayName())) {
                    sclTable.setDisplayName(dataEntity.getDisplayName());
                } else {
                    sclTable.setDisplayName(dataEntity.getName());
                }
                sclTable.setDescription(dataEntity.getDescription());
                String entityName = dataProperty.getEntityName();
                DataEntity dataEntity1 = entityMap.get(entityName);
                Long parentId = dataEntity1.getId();
                sclTable.setParentId(Long.valueOf(parentId == null ? 0L : parentId));
                sclTable.setBusinessObjectId(businessObjectsRel.get(dataEntity.getBusinessCode()));
                sclEntities.add(sclTable);
                bindingCollectionPropertySclTable.add(sclTable);
            }
        } else if ("Root".equals(dataEntity.getDataEntityTypeType())) {
            SclTable sclTable = new SclTable();
            sclTable.setId(dataEntity.getId());
            entityIdsRel.put(ObjectUtils.isEmpty((Object)dataEntity.getAlias()) ? dataEntity.getName() : dataEntity.getAlias(), sclTable.getId());
            sclTable.setProductVersionId(context.getSclProductVersion().getId());
            sclTable.setName(ObjectUtils.isEmpty((Object)dataEntity.getAlias()) ? dataEntity.getName() : dataEntity.getAlias());
            if (!ObjectUtils.isEmpty((Object)dataEntity.getDisplayName())) {
                sclTable.setDisplayName(dataEntity.getDisplayName());
            } else {
                sclTable.setDisplayName(dataEntity.getName());
            }
            sclTable.setDescription(dataEntity.getDescription());
            Long parentId = dataEntity.getParentId();
            sclTable.setParentId(Long.valueOf(parentId == null ? 0L : parentId));
            sclTable.setBusinessObjectId(businessObjectsRel.get(dataEntity.getBusinessCode()));
            sclEntities.add(sclTable);
        } else {
            dataEntity.setIsCreateTable(Boolean.FALSE);
        }
        return bindingCollectionPropertySclTable;
    }

    private static void columns(E10ExecuteContext context, DataEntity dataEntity, Map<String, DataEntity> entityMap, Map<String, Long> dicCodeIdRel, Map<String, Long> entityFieldIdsRel, List<SclTableField> entityFields, List<SclTable> collectionPropertyEntity, Map<String, SclCommonInfoConfig> commonInfoConfigMap) {
        block8: {
            List<DataProperty> columns = dataEntity.getColumns();
            if (!CollectionUtils.isNotEmpty(columns)) break block8;
            List list = columns.stream().filter(res -> !"CollectionProperty".equals(res.getPropertyType())).collect(Collectors.toList());
            List complexProperty = columns.stream().filter(res -> "ComplexProperty".equals(res.getPropertyType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(complexProperty)) {
                DataEntity dataEntity1 = entityMap.get("ReferToEntity");
                ArrayList<DataProperty> refCol = new ArrayList<DataProperty>();
                for (DataProperty dataProperty : complexProperty) {
                    for (DataProperty dataProperty2 : dataEntity1.getColumns()) {
                        String columName = (ObjectUtils.isEmpty((Object)dataProperty.getAlias()) ? dataProperty.getName() : dataProperty.getAlias()) + "_" + dataProperty2.getName();
                        DataProperty dataProperty1 = new DataProperty();
                        BeanUtils.copyProperties((Object)dataProperty2, (Object)dataProperty1);
                        dataProperty1.setAlias(columName);
                        String tableName = dataEntity.getName();
                        entityFieldIdsRel.put(tableName + "&" + dataProperty2.getName(), IdUtil.getId());
                        refCol.add(dataProperty1);
                    }
                }
                list.removeIf(res -> "ComplexProperty".equals(res.getPropertyType()));
                list.addAll(refCol);
            }
            List columList = list.stream().distinct().collect(Collectors.toList());
            List<DataProperty> bindingCollectionProperty = dataEntity.getBindingCollectionProperty();
            if (CollectionUtils.isNotEmpty(bindingCollectionProperty) && !"Root".equals(dataEntity.getDataEntityTypeType())) {
                for (DataProperty dataProperty : bindingCollectionProperty) {
                    ArrayList columnList = new ArrayList();
                    columnList.addAll(columList);
                    for (DataProperty column : columnList) {
                        SclTableField sclTableField = new SclTableField();
                        SclTable sclTable = collectionPropertyEntity.stream().filter(res -> res.getName().equals(ObjectUtils.isEmpty((Object)dataProperty.getAlias()) ? dataProperty.getName() : dataProperty.getAlias())).findFirst().get();
                        sclTableField.setTableId(sclTable.getId());
                        Long id = IdUtil.getId();
                        sclTableField.setId(id);
                        entityFieldIdsRel.put(dataProperty.getName() + "&" + column.getName(), id);
                        E10TableColumObjectServiceImpl.setCommonField(context, dataEntity, dicCodeIdRel, entityFieldIdsRel, entityFields, column, sclTableField, commonInfoConfigMap);
                    }
                }
            } else {
                for (DataProperty column : columList) {
                    SclTableField sclTableField = new SclTableField();
                    Long l = entityFieldIdsRel.get(dataEntity.getName() + "&" + column.getName());
                    sclTableField.setTableId(dataEntity.getId());
                    sclTableField.setId(l);
                    E10TableColumObjectServiceImpl.setCommonField(context, dataEntity, dicCodeIdRel, entityFieldIdsRel, entityFields, column, sclTableField, commonInfoConfigMap);
                }
            }
        }
    }

    private static void setCommonField(E10ExecuteContext context, DataEntity dataEntity, Map<String, Long> dicCodeIdRel, Map<String, Long> entityFieldIdsRel, List<SclTableField> entityFields, DataProperty column, SclTableField sclTableField, Map<String, SclCommonInfoConfig> commonInfoConfigMap) {
        String dataType;
        sclTableField.setProductVersionId(context.getSclProductVersion().getId());
        sclTableField.setName(ObjectUtils.isEmpty((Object)column.getAlias()) ? column.getName() : column.getAlias());
        sclTableField.setDisplayName(ObjectUtils.isEmpty((Object)column.getDisplayName()) ? column.getName() : column.getDisplayName());
        sclTableField.setDescription(column.getDescription());
        String string = dataType = ObjectUtils.isEmpty((Object)column.getDbType()) ? "String" : column.getDbType();
        if (null != commonInfoConfigMap.get(dataType)) {
            sclTableField.setDataType(commonInfoConfigMap.get(dataType).getCode());
        } else {
            sclTableField.setDataType("\u3010" + dataType + "\u3011");
        }
        sclTableField.setDefaultValue(column.getDefaultValue());
        sclTableField.setDigit(column.getScale());
        String primaryKey = dataEntity.getPrimaryKey();
        sclTableField.setIsPrimaryKey(Boolean.valueOf(!ObjectUtils.isEmpty((Object)primaryKey) && primaryKey.equals(column.getAlias())));
        sclTableField.setDictId(dicCodeIdRel.get(column.getPickListType()));
        DataPropertyLogicalFk logicalFk = column.getLogicalFk();
        if (!ObjectUtils.isEmpty((Object)logicalFk)) {
            sclTableField.setRelationFieldId(entityFieldIdsRel.get(logicalFk.getTableName() + "&" + logicalFk.getColumnName()));
        }
        sclTableField.setIsRequired(Boolean.valueOf(!ObjectUtils.isEmpty((Object)column.getIsNullable())));
        if (ObjectUtils.isEmpty((Object)column.getIsUnique())) {
            sclTableField.setIsUnique(Boolean.valueOf(false));
        } else {
            boolean aTrue = column.getIsUnique().equalsIgnoreCase("true");
            sclTableField.setIsUnique(Boolean.valueOf(aTrue));
        }
        sclTableField.setLength(column.getSize());
        entityFields.add(sclTableField);
    }

    @Override
    public Boolean enable() {
        return true;
    }

    @Override
    public void execute(E10ExecuteContext context, List<DataEntity> allDataEntitys, Map<String, DataEntity> dataEntityMap) {
        try {
            Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
            Map<String, Long> dicCodeIdRel = context.getDicCodeIdRel();
            Map<String, DataEntity> entityMap = dataEntityMap;
            Map entityFieldIdsRel = (Map)((Object)SerializationUtils.clone(context.getEntityFieldIdsRel()));
            HashMap entityIdsRel = new HashMap();
            List listByCategory = this.sclCommonInfoConfigMapper.getListByCategory(CategoryEnum.E10_DB_DATA_TYPE.getCode());
            if (CollectionUtils.isEmpty((Collection)listByCategory)) {
                throw new RuntimeException("\u7f3a\u5c11\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e");
            }
            Map commonInfoConfigMap = listByCategory.stream().collect(Collectors.toMap(SclCommonInfoConfig::getActionName, Function.identity(), (existingValue, newValue) -> existingValue));
            List<Map<String, DataEntity>> maps = GroupObjectUtil.groupMapByKeyCountWithStreams(entityMap, this.groupSize);
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                for (Map<String, DataEntity> entity : maps) {
                    executor.submit(() -> this.saveData(context, entity, businessObjectsRel, entityIdsRel, entityMap, dicCodeIdRel, entityFieldIdsRel, commonInfoConfigMap));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveData(E10ExecuteContext context, Map<String, DataEntity> entity, Map<String, Long> businessObjectsRel, Map<String, Long> entityIdsRel, Map<String, DataEntity> entityMap, Map<String, Long> dicCodeIdRel, Map<String, Long> entityFieldIdsRel, Map<String, SclCommonInfoConfig> commonInfoConfigMap) {
        try {
            ArrayList sclEntities = new ArrayList();
            ArrayList entityFields = new ArrayList();
            entity.forEach((name, dataEntity) -> {
                if (!name.equals("ReferToEntity") && !ObjectUtils.isEmpty(businessObjectsRel.get(dataEntity.getBusinessCode()))) {
                    List<SclTable> collectionPropertyEntity = E10TableColumObjectServiceImpl.entity(context, dataEntity, entityIdsRel, businessObjectsRel, sclEntities, entityMap);
                    if (dataEntity.getIsCreateTable().booleanValue()) {
                        E10TableColumObjectServiceImpl.columns(context, dataEntity, entityMap, dicCodeIdRel, entityFieldIdsRel, entityFields, collectionPropertyEntity, commonInfoConfigMap);
                    } else {
                        log.warn("\u5bf9\u5e94\u5b9e\u4f53\uff1a{},\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u65e0\u9700\u751f\u6210\u5bf9\u5e94\u8868\u548c\u8868\u5b57\u6bb5", (Object)dataEntity.getName(), (Object)dataEntity.getDataEntityTypeType());
                    }
                }
            });
            this.sclTableMapper.insert(sclEntities);
            this.sclTableFieldMapper.insert(entityFields);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Integer stepIndex() {
        return 1;
    }

    public String desc() {
        return "-->\u3010\u5b9e\u4f53-\u8868\u548c\u5217\u3011<--";
    }
}

