/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.util;

import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.PropertiesUtil;
import com.digiwin.athena.ai.generate.tools.e10.util.XmlUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.business.RootEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.utils.NamespaceContextMap;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileLister {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private static final String MISS_DATA_ENTIRY_URL = "v8/BusinessObjects";

    public static List<String> getFilePathsWithSuffix(String directoryPath, String fileSuffix) {
        List<String> list;
        block8: {
            Path directory = Paths.get(directoryPath, new String[0]);
            Stream<Path> stream = Files.walk(directory, 1, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(fileSuffix)).map(Path::toString).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<String> getFilePathsWithFileName(String directoryPath, String fileName, int deep) {
        List<String> list;
        block8: {
            Path directory = Paths.get(directoryPath, new String[0]);
            Stream<Path> stream = Files.walk(directory, deep, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equals(fileName)).map(Path::toString).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> getFilePathsWithFileName(String directoryPath, String fileName) {
        return FileLister.getFilePathsWithFileName(directoryPath, null, fileName);
    }

    public static List<Path> getFilePathsWithFileName(String directoryPath, String subDirectory, String fileName) {
        List<Path> list;
        block8: {
            Path directory = subDirectory != null && !subDirectory.trim().isEmpty() ? Paths.get(directoryPath, subDirectory) : Paths.get(directoryPath, new String[0]);
            Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equals(fileName)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> getFilePathsWithSuffixFileName(String directoryPath, String subDirectory, String fileName) {
        List<Path> list;
        block8: {
            Path directory = subDirectory != null && !subDirectory.trim().isEmpty() ? Paths.get(directoryPath, subDirectory) : Paths.get(directoryPath, new String[0]);
            Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(fileName)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> getFilePathsWithPrefix(String directoryPath, String filePrefix) {
        List<Path> list;
        block8: {
            Path directory = Paths.get(directoryPath, new String[0]);
            Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(filePrefix)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> getFilePathsWithPrefix(String directoryPath, String filePrefix, int deep) {
        List<Path> list;
        block8: {
            Path directory = Paths.get(directoryPath, new String[0]);
            Stream<Path> stream = Files.walk(directory, deep, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(filePrefix)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> getFilePathsWithPrefix(Path directory, String filePrefix) {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(filePrefix)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    public static Document parseXml(File f) throws Exception {
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        try (FileInputStream fis = new FileInputStream(f);){
            InputSource is = new InputSource(fis);
            is.setEncoding("utf-8");
            Document document = db.parse(is);
            return document;
        }
    }

    private static URL getBusinessObjectsUrl() {
        return FileLister.class.getClassLoader().getResource(MISS_DATA_ENTIRY_URL);
    }

    public static List<RootEntity> getRootNodeList(String dirPath, String suffix) {
        Document doc;
        List<String> xmlFiles = FileLister.getFilePathsWithFileName(dirPath, suffix, 2);
        ArrayList<RootEntity> dataEntities = new ArrayList<RootEntity>();
        for (String xmlFile : xmlFiles) {
            doc = null;
            try {
                File file = new File(xmlFile);
                doc = FileLister.parseXml(file);
                XPath xpath = xpf.newXPath();
                xpath.setNamespaceContext(new NamespaceContextMap("ns", "http://schemas.dcms.com/configuration/MetadataContainerElement"));
                NodeList nodeList = (NodeList)xpath.evaluate("//ns:DataEntityType[ns:DataEntityTypeType='Root']", doc, XPathConstants.NODESET);
                FileLister.getRootEntity(nodeList, dataEntities, file.getParentFile().getName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Path otherPath = Paths.get(FileLister.getBusinessObjectsUrl().toURI()).resolve("USER");
            File file = otherPath.resolve("MetadataContainer.dcxml").toFile();
            doc = FileLister.parseXml(file);
            XPath xpath = xpf.newXPath();
            xpath.setNamespaceContext(new NamespaceContextMap("ns", "http://schemas.dcms.com/configuration/MetadataContainerElement"));
            NodeList nodeList = (NodeList)xpath.evaluate("//ns:DataEntityType[ns:DataEntityTypeType='Root']", doc, XPathConstants.NODESET);
            FileLister.getRootEntity(nodeList, dataEntities, file.getParentFile().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataEntities;
    }

    private static List<RootEntity> getRootEntity(NodeList nodeList, List<RootEntity> dataEntities, String folderName) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element el = (Element)nodeList.item(i);
            dataEntities.add(FileLister.dataEntity(el, folderName));
        }
        return dataEntities;
    }

    private static String text(Node n, String tag) {
        if (!(n instanceof Element)) {
            return null;
        }
        return XmlUtil.elementText((Element)n, tag);
    }

    private static RootEntity dataEntity(Element el, String folderName) {
        RootEntity entity = new RootEntity();
        String name = FileLister.text(el, "Name");
        entity.setName(name);
        entity.setFolderName(folderName);
        entity.setDisplayName(FileLister.text(el, "DisplayName"));
        entity.setDescription(FileLister.text(el, "Description"));
        entity.setDataEntityTypeType(FileLister.text(el, "DataEntityTypeType"));
        entity.setPrimaryKey(FileLister.text(el, "PrimaryKey"));
        return entity;
    }

    public static void main(String[] args) throws JAXBException, ParserConfigurationException, IOException, SAXException {
        E10Properties e10Properties = PropertiesUtil.getE10Properties("C:/Users/Alor/Desktop/\u65b0\u5efa\u6587\u4ef6\u5939/E80KF-20251011092257");
        List<RootEntity> rootNodeList = FileLister.getRootNodeList(e10Properties.getBusinessObjectsRoot(), e10Properties.getRootEntityFileName());
        System.out.println(rootNodeList);
    }
}

