/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GroupObjectUtil {
    public static <K, V> List<Map<K, V>> groupMapByKeyCountWithStreams(Map<K, V> originalMap, int groupSize) {
        if (originalMap == null || originalMap.isEmpty() || groupSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList entries = new ArrayList(originalMap.entrySet());
        return IntStream.range(0, entries.size()).boxed().collect(Collectors.groupingBy(index -> index / groupSize)).values().stream().map(indices -> indices.stream().map(entries::get).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).collect(Collectors.toList());
    }

    public static <T> Map<Integer, List<T>> groupBySizeWithStream(List<T> list, int groupSize) {
        if (list == null || list.isEmpty() || groupSize <= 0) {
            return Map.of();
        }
        return IntStream.range(0, list.size()).boxed().collect(Collectors.groupingBy(index -> index / groupSize, Collectors.mapping(list::get, Collectors.toList())));
    }

    public static void main(String[] args) {
        List<String> originalList = List.of("A", "B", "C", "D", "E", "F", "G");
        int groupSize = 3;
        Map<Integer, List<String>> groupedMap = GroupObjectUtil.groupBySizeWithStream(originalList, groupSize);
        groupedMap.forEach((key, value) -> System.out.println("\u7ec4 " + (key + 1) + ": " + String.valueOf(value)));
    }

    public static <T, K, V> Map<K, V> toMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, V defaultValue) {
        return list.stream().collect(Collectors.toMap(keyMapper, t -> {
            Object value = valueMapper.apply(t);
            return value != null ? value : defaultValue;
        }, (existingValue, newValue) -> existingValue));
    }
}

