/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.util;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

@Component
public class TemplateUtil {
    private static final Map<String, String> TEMPLATE_CACHE = new ConcurrentHashMap<String, String>();
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{(\\w+)}");
    public static final String SHAREDATA_RELATION_TEMPLATE = "sharedata_relation";
    public static final String SHAREDATA_VARIABLE_TEMPLATE = "sharedata_variable";
    public static final String FORMULA_TEMPLATE = "FORMULA";
    public static final String VALIDATOR_TEMPLATE = "VALIDATE";

    @PostConstruct
    public void init() {
        try {
            TEMPLATE_CACHE.put(SHAREDATA_RELATION_TEMPLATE, this.loadTemplateFromClasspath("templates/sharedata_relation_template.txt"));
            TEMPLATE_CACHE.put(SHAREDATA_VARIABLE_TEMPLATE, this.loadTemplateFromClasspath("templates/sharedata_variable_template.txt"));
            TEMPLATE_CACHE.put(FORMULA_TEMPLATE, this.loadTemplateFromClasspath("templates/formula_template.txt"));
            TEMPLATE_CACHE.put(VALIDATOR_TEMPLATE, this.loadTemplateFromClasspath("templates/validator_template.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load template file", e);
        }
    }

    private String loadTemplateFromClasspath(String path) throws IOException {
        ClassPathResource resource = new ClassPathResource(path);
        if (!resource.exists()) {
            throw new IOException("Template file not found: " + path);
        }
        return FileCopyUtils.copyToString((Reader)new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
    }

    public static String getShareDataRelationTemplate() {
        return TEMPLATE_CACHE.get(SHAREDATA_RELATION_TEMPLATE);
    }

    public static String getShareDataVariableTemplate() {
        return TEMPLATE_CACHE.get(SHAREDATA_VARIABLE_TEMPLATE);
    }

    public static String getTemplate(String templateName) {
        return TEMPLATE_CACHE.get(templateName);
    }

    public static String replaceTemplate(String template, Map<String, String> replacements) {
        if (template == null || replacements == null) {
            return template;
        }
        String result = template;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            String placeholder = "{" + entry.getKey() + "}";
            String value = entry.getValue() != null ? entry.getValue() : "";
            result = result.replace(placeholder, value);
        }
        return result;
    }

    public Set<String> extractPlaceholders(String template) {
        HashSet<String> placeholders = new HashSet<String>();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(template);
        while (matcher.find()) {
            placeholders.add(matcher.group(1));
        }
        return placeholders;
    }

    public boolean validateReplacements(String template, Map<String, String> replacements) {
        Set<String> requiredPlaceholders = this.extractPlaceholders(template);
        Set<String> providedPlaceholders = replacements.keySet();
        return providedPlaceholders.containsAll(requiredPlaceholders);
    }
}

