/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final XPathFactory xPathFactory = XPathFactory.newInstance();
    private static final XPath xPath = xPathFactory.newXPath();

    public static String elementText(Element parent, String tagName, String defaultValue) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !tagName.equals(child.getNodeName())) continue;
            return child.getTextContent() != null ? child.getTextContent().trim() : null;
        }
        return defaultValue;
    }

    public static String elementText(Element parent, String tagName) {
        return XmlUtil.elementText(parent, tagName, null);
    }

    public static Element getElement(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !tagName.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static Node parse(String file) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(file));
        Element rootElement = document.getDocumentElement();
        rootElement.removeAttribute("xmlns");
        return rootElement;
    }

    public static Node parseByXmlText(String xmlText) {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlText.getBytes(StandardCharsets.UTF_8));
            Document document = builder.parse(inputStream);
            Element rootElement = document.getDocumentElement();
            rootElement.removeAttribute("xmlns");
            inputStream.close();
            return rootElement;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasNode(Node node, String name) {
        try {
            return xPath.evaluate(name, node, XPathConstants.NODE) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static NodeList getNodeList(Node node, String name) {
        try {
            return (NodeList)xPath.evaluate(name, node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Node getNode(Node node, String name) {
        try {
            return (Node)xPath.evaluate(name, node, XPathConstants.NODE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getNodeText(Node node, String name) {
        Node cNode = XmlUtil.getNode(node, name);
        if (cNode != null) {
            return cNode.getTextContent();
        }
        return null;
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<MetadataContainer xmlns=\"http://schemas.dcms.com/configuration/MetadataContainerElement\" FileVersion=\"8.0.0.4\" ProductVersion=\"8.0.0\" ProductName=\"E10\" CopyRight=\"CopyRight@2013,Digiwin\">\n<DataEntityTypes>\n<DataEntityType>\n  <Name>PURCHASE_ARRIVAL</Name>\n  <DisplayName>\u5230\u8d27\u5355</DisplayName>\n  <Description>\u5230\u8d27\u5355</Description>\n  <PrimaryKey>PURCHASE_ARRIVAL_ID</PrimaryKey>\n  <Domain>Database</Domain>\n  <DataEntityTypeType>Root</DataEntityTypeType>\n  <BusinessPrimaryKey>DOC_NO</BusinessPrimaryKey>\n  <Properties>\n    <SimpleProperty>\n      <Name>PURCHASE_ARRIVAL_ID</Name>\n      <Alias>PURCHASE_ARRIVAL_ID</Alias>\n      <DisplayName>\u4e3b\u952e</DisplayName>\n      <Description>\u4e3b\u952e</Description>\n      <BusinessTypeName>PrimaryKey</BusinessTypeName>\n      <AutoSync>Never</AutoSync>\n    </SimpleProperty>\n    <SimpleProperty>\n      <Name>CATEGORY</Name>\n      <Alias>CATEGORY</Alias>\n      <DisplayName>\u5355\u636e\u6027\u8d28</DisplayName>\n      <Description>\u5355\u636e\u6027\u8d28</Description>\n      <Size>20</Size>\n      <AutoSync>Never</AutoSync>\n    </SimpleProperty>\n    <ComplexProperty>\n      <Name>SOURCE_ID</Name>\n      <Alias>SOURCE_ID</Alias>\n      <DisplayName>\u6e90\u5355</DisplayName>\n      <Description>\u6e90\u5355</Description>\n      <DataEntityTypeName>ReferToEntity</DataEntityTypeName>\n      <PickListType>DocSource36</PickListType>\n    </ComplexProperty>\n    <ReferenceProperty>\n      <Name>TAX_INVOICE_CATEGORY_ID</Name>\n      <Alias>TAX_INVOICE_CATEGORY_ID</Alias>\n      <DisplayName>\u53d1\u7968\u79cd\u7c7b</DisplayName>\n      <Description>\u53d1\u7968\u79cd\u7c7b</Description>\n      <BusinessTypeName>PrimaryKey</BusinessTypeName>\n      <AutoSync>Never</AutoSync>\n      <ReferenceToName>TAX_INVOICE_CATEGORY</ReferenceToName>\n    </ReferenceProperty>\n    <ReferenceProperty>\n      <Name>SUPPLIER_ADDR_ID</Name>\n      <Alias>SUPPLIER_ADDR_ID</Alias>\n      <DisplayName>\u4f9b\u5e94\u5546\u5730\u5740\u7f16\u53f7</DisplayName>\n      <Description>\u4f9b\u5e94\u5546\u5730\u5740\u7f16\u53f7</Description>\n      <BusinessTypeName>PrimaryKey</BusinessTypeName>\n      <AutoSync>Never</AutoSync>\n      <ReferenceToName>SUPPLIER_PURCHASE.SUPPLIER_ADDRESS</ReferenceToName>\n    </ReferenceProperty>\n    <CollectionProperty>\n      <Name>PURCHASE_ARRIVAL_D</Name>\n      <Alias>PURCHASE_ARRIVAL_D</Alias>\n      <DisplayName>\u5230\u8d27\u5355\u660e\u7ec6</DisplayName>\n      <Description>\u5230\u8d27\u5355\u660e\u7ec6</Description>\n      <ItemDataEntityTypeName>PURCHASE_ARRIVAL_D</ItemDataEntityTypeName>\n    </CollectionProperty>\n    <CollectionProperty>\n      <Name>PUR_ARRIVAL_OFFSETDEP</Name>\n      <Alias>PUR_ARRIVAL_OFFSETDEP</Alias>\n      <DisplayName>\u5230\u8d27\u5355\u8ba2\u91d1\u51b2\u51cf\u660e\u7ec6</DisplayName>\n      <Description>\u5230\u8d27\u5355\u8ba2\u91d1\u51b2\u51cf\u660e\u7ec6</Description>\n      <ItemDataEntityTypeName>PUR_ARRIVAL_OFFSETDEP</ItemDataEntityTypeName>\n    </CollectionProperty>\n    <ComplexProperty>\n      <Name>RECEIVE_Owner_Org</Name>\n      <Alias>RECEIVE_Owner_Org</Alias>\n      <DisplayName>\u6536\u8d27\u673a\u6784</DisplayName>\n      <Description>\u6536\u8d27\u673a\u6784</Description>\n      <DataEntityTypeName>ReferToEntity</DataEntityTypeName>\n      <PickListType>OrgType</PickListType>\n    </ComplexProperty>\n  </Properties>\n</DataEntityType>\n<DataEntityType>\n  <Name>PURCHASE_ARRIVAL_D</Name>\n  <DisplayName>\u5230\u8d27\u5355\u660e\u7ec6</DisplayName>\n  <Description>\u5230\u8d27\u5355\u660e\u7ec6</Description>\n  <PrimaryKey>PURCHASE_ARRIVAL_D_ID</PrimaryKey>\n  <Domain>Database</Domain>\n  <DataEntityTypeType>CollectionItem</DataEntityTypeType>\n  <BusinessPrimaryKey>SequenceNumber</BusinessPrimaryKey>\n  <Properties>\n    <SimpleProperty>\n      <Name>PURCHASE_ARRIVAL_D_ID</Name>\n      <Alias>PURCHASE_ARRIVAL_D_ID</Alias>\n      <DisplayName>\u4e3b\u952e</DisplayName>\n      <Description>\u4e3b\u952e</Description>\n      <BusinessTypeName>PrimaryKey</BusinessTypeName>\n      <AutoSync>Never</AutoSync>\n    </SimpleProperty>\n    <SimpleProperty>\n      <Name>ITEM_TYPE</Name>\n      <Alias>ITEM_TYPE</Alias>\n      <DisplayName>\u5546\u54c1\u7c7b\u578b</DisplayName>\n      <Description>\u5546\u54c1\u7c7b\u578b</Description>\n      <Size>20</Size>\n      <AutoSync>Never</AutoSync>\n      <PickListType>GoodsType</PickListType>\n    </SimpleProperty>\n  </Properties>\n</DataEntityType>\n</DataEntityTypes>\n</MetadataContainer>\n";
        Node rootNode = XmlUtil.parseByXmlText(xml);
        NodeList propertyNameList = XmlUtil.getNodeList(rootNode, "//Properties/*/Name");
        for (int i = 0; i < propertyNameList.getLength(); ++i) {
            System.out.println(propertyNameList.item(i).getTextContent());
        }
        NodeList detList = XmlUtil.getNodeList(rootNode, "//DataEntityType");
        detList = XmlUtil.getNodeList(rootNode, "/MetadataContainer/DataEntityTypes/DataEntityType");
        for (int i = 0; i < detList.getLength(); ++i) {
            System.out.println(XmlUtil.getNodeText(detList.item(i), "Name"));
            NodeList simpleList = XmlUtil.getNodeList(detList.item(i), "Properties/SimpleProperty");
            for (int j = 0; j < simpleList.getLength(); ++j) {
                System.out.println("\t" + XmlUtil.getNodeText(simpleList.item(j), "Name"));
            }
        }
        Node firstDataEntityType = detList.item(0);
        Node nameNode = XmlUtil.getNode(firstDataEntityType, "Name");
        String name = nameNode.getTextContent();
        System.out.println(name);
        name = XmlUtil.getNodeText(firstDataEntityType, "Name");
        System.out.println(name);
    }
}

