/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule;

import com.digiwin.athena.ai.generate.tools.e10.util.XmlUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.FunctionRuleXmlParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.constant.FunctionRuleConstant;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.constant.FunctionRuleTypeEnum;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.FuctionRule;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.FuctionRuleContentData;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.utils.FunctionRuleUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormulaXmlParser
implements FunctionRuleXmlParser {
    private static final String NAMESPACE_URI = "http://schemas.dcms.com/configuration/FormulaContainerElement";

    @Override
    public Boolean supportKey(String type) {
        return FunctionRuleTypeEnum.FORMULA.getType().equalsIgnoreCase(type);
    }

    @Override
    public List<FuctionRule> parseXml(Path path) throws Exception {
        File xmlFile = path.toFile();
        String pPath = xmlFile.getParentFile().getName();
        String filename = FunctionRuleUtil.extractMiddlePart(xmlFile.getAbsoluteFile().getName());
        ArrayList<FuctionRule> formulas = new ArrayList<FuctionRule>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlFile);
        NodeList formulasNodes = document.getElementsByTagNameNS(NAMESPACE_URI, "Formulas");
        if (formulasNodes.getLength() > 0) {
            Element formulasElement = (Element)formulasNodes.item(0);
            NodeList childNodes = formulasElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                if ("LambdaFormula".equals(node.getNodeName())) {
                    Element formulaElement = (Element)node;
                    FuctionRule formula = this.parseFormulaElement(formulaElement, pPath, filename, null, null);
                    formulas.add(formula);
                    continue;
                }
                if (!"LambdaFormulaGroup".equals(node.getNodeName())) continue;
                formulas.addAll(this.parseFormulaGroup((Element)node, pPath, filename));
            }
        }
        return formulas;
    }

    private List<FuctionRule> parseFormulaGroup(Element groupElement, String pPath, String filename) {
        ArrayList<FuctionRule> formulas = new ArrayList<FuctionRule>();
        String groupCode = XmlUtil.elementText(groupElement, "Id");
        String groupPath = XmlUtil.elementText(groupElement, "Path");
        Element itemsElement = XmlUtil.getElement(groupElement, "Items");
        if (itemsElement != null) {
            NodeList formulaItemNodes = itemsElement.getElementsByTagNameNS(NAMESPACE_URI, "FormulaItem");
            for (int i = 0; i < formulaItemNodes.getLength(); ++i) {
                Element formulaItemElement = (Element)formulaItemNodes.item(i);
                FuctionRule formula = this.parseFormulaElement(formulaItemElement, pPath, filename, groupCode, groupPath);
                formulas.add(formula);
            }
        }
        return formulas;
    }

    private FuctionRule parseFormulaElement(Element formulaElement, String pPath, String filename, String groupCode, String groupPath) {
        FuctionRule formula = new FuctionRule();
        formula.setType(FunctionRuleTypeEnum.FORMULA.getType());
        formula.setEx1(filename);
        formula.setEx2(pPath);
        formula.setCode(XmlUtil.elementText(formulaElement, "Id"));
        formula.setDisplayName(XmlUtil.elementText(formulaElement, "DisplayName"));
        formula.setDescription(XmlUtil.elementText(formulaElement, "Description"));
        if (groupPath != null) {
            formula.setFieldPath(groupPath);
        } else {
            formula.setFieldPath(XmlUtil.elementText(formulaElement, "Path"));
        }
        formula.setFieldSchema(XmlUtil.elementText(formulaElement, "Target"));
        FuctionRuleContentData content = this.buildFormulaContent(formulaElement, groupCode);
        formula.setContent(content);
        return formula;
    }

    private FuctionRuleContentData buildFormulaContent(Element formulaElement, String groupCode) {
        String dependencyItems;
        FuctionRuleContentData content = new FuctionRuleContentData();
        if (groupCode != null) {
            content.setGroupCode(groupCode);
        }
        if (StringUtils.hasText((String)(dependencyItems = XmlUtil.elementText(formulaElement, "DependencyItems")))) {
            content.setDependencyItems(new HashSet<String>(Arrays.asList(dependencyItems.split(","))));
        }
        content.setExpression(XmlUtil.elementText(formulaElement, "Expression"));
        this.parseActivePoints(formulaElement, content);
        return content;
    }

    private void parseActivePoints(Element formulaElement, FuctionRuleContentData content) {
        Element activePointsElement = XmlUtil.getElement(formulaElement, "ActivePoints");
        if (activePointsElement != null) {
            NodeList activePointNodes = activePointsElement.getElementsByTagNameNS(NAMESPACE_URI, "FormulaActivePoint");
            for (int i = 0; i < activePointNodes.getLength(); ++i) {
                Element activePointElement = (Element)activePointNodes.item(i);
                String activePoint = XmlUtil.elementText(activePointElement, "ActivePoint");
                if (activePoint == null || activePoint.isEmpty()) continue;
                content.addPoint(FunctionRuleConstant.FORMULA_POINT_COVERT.getOrDefault(activePoint, activePoint));
            }
        }
    }
}

