/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule;

import com.digiwin.athena.ai.generate.tools.e10.util.XmlUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.FunctionRuleXmlParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.constant.FunctionRuleConstant;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.constant.FunctionRuleTypeEnum;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.FuctionRule;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.dto.FuctionRuleContentData;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.utils.FunctionRuleUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorXmlParser
implements FunctionRuleXmlParser {
    private static final String NAMESPACE_URI = "http://schemas.dcms.com/configuration/ValidatorContainerElement";
    private static final String REQUIRED_FIELD_VALIDATOR = "RequiredFieldValidator";
    private static final String LAMBDA_VALIDATOR = "LambdaValidator";

    @Override
    public Boolean supportKey(String type) {
        return FunctionRuleTypeEnum.VALIDATE.getType().equalsIgnoreCase(type);
    }

    @Override
    public List<FuctionRule> parseXml(Path path) throws Exception {
        File xmlFile = path.toFile();
        String pPath = xmlFile.getParentFile().getName();
        String filename = FunctionRuleUtil.extractMiddlePart(xmlFile.getAbsoluteFile().getName());
        ArrayList<FuctionRule> validators = new ArrayList<FuctionRule>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlFile);
        NodeList validatorsNodes = document.getElementsByTagNameNS(NAMESPACE_URI, "Validators");
        if (validatorsNodes.getLength() > 0) {
            Element validatorsElement = (Element)validatorsNodes.item(0);
            NodeList childNodes = validatorsElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                FuctionRule validator = null;
                if (REQUIRED_FIELD_VALIDATOR.equals(node.getNodeName())) {
                    validator = this.parseRequiredFieldValidator((Element)node, pPath, filename);
                } else if (LAMBDA_VALIDATOR.equals(node.getNodeName())) {
                    validator = this.parseLambdaValidator((Element)node, pPath, filename);
                }
                if (validator == null) continue;
                validators.add(validator);
            }
        }
        return validators;
    }

    private FuctionRule parseRequiredFieldValidator(Element validatorElement, String pPath, String filename) {
        FuctionRule validator = new FuctionRule();
        validator.setType(FunctionRuleTypeEnum.VALIDATE.getType());
        validator.setEx1(filename);
        validator.setEx2(pPath);
        validator.setCode(XmlUtil.elementText(validatorElement, "Id"));
        validator.setDisplayName(XmlUtil.elementText(validatorElement, "DisplayName"));
        validator.setDescription(XmlUtil.elementText(validatorElement, "Description"));
        validator.setFieldPath(XmlUtil.elementText(validatorElement, "Path"));
        validator.setFieldSchema(XmlUtil.elementText(validatorElement, "ApplyTo"));
        FuctionRuleContentData content = this.buildRequiredFieldValidatorContent(validatorElement);
        validator.setContent(content);
        return validator;
    }

    private FuctionRuleContentData buildRequiredFieldValidatorContent(Element formulaElement) {
        FuctionRuleContentData content = new FuctionRuleContentData();
        content.setCategory("required");
        content.setValidatorType(XmlUtil.elementText(formulaElement, "ResponseType"));
        content.setErrorMessage(XmlUtil.elementText(formulaElement, "Message"));
        String condition = XmlUtil.elementText(formulaElement, "Expression");
        if (StringUtils.hasText((String)condition)) {
            content.setCondition(condition);
        } else {
            content.setCondition("true");
        }
        String applyTo = XmlUtil.elementText(formulaElement, "ApplyTo");
        content.setExpression(String.format("not IsEmpty(ActiveObject.%s)", applyTo));
        content.setDependencyItems(new HashSet<String>(Collections.singletonList(applyTo)));
        this.parseActivePoints(formulaElement, content);
        return content;
    }

    private FuctionRule parseLambdaValidator(Element validatorElement, String pPath, String filename) {
        FuctionRule validator = new FuctionRule();
        validator.setType(FunctionRuleTypeEnum.VALIDATE.getType());
        validator.setEx1(filename);
        validator.setEx2(pPath);
        validator.setCode(XmlUtil.elementText(validatorElement, "Id"));
        validator.setDisplayName(XmlUtil.elementText(validatorElement, "DisplayName"));
        validator.setDescription(XmlUtil.elementText(validatorElement, "Description"));
        validator.setFieldPath(XmlUtil.elementText(validatorElement, "Path"));
        validator.setFieldSchema(XmlUtil.elementText(validatorElement, "ShowMessageTo"));
        validator.setDescription(XmlUtil.elementText(validatorElement, "Description"));
        FuctionRuleContentData content = this.buildLambdaValidatorContent(validatorElement);
        validator.setContent(content);
        return validator;
    }

    private FuctionRuleContentData buildLambdaValidatorContent(Element formulaElement) {
        FuctionRuleContentData content = new FuctionRuleContentData();
        content.setCategory("custom");
        content.setValidatorType(XmlUtil.elementText(formulaElement, "ResponseType"));
        content.setErrorMessage(XmlUtil.elementText(formulaElement, "Message"));
        content.setExpression(XmlUtil.elementText(formulaElement, "Expression"));
        content.setCondition("true");
        this.parseActivePoints(formulaElement, content);
        return content;
    }

    private void parseActivePoints(Element validatorElement, FuctionRuleContentData content) {
        Element activePointsElement = XmlUtil.getElement(validatorElement, "ActivePoints");
        if (activePointsElement != null) {
            NodeList activePointNodes = activePointsElement.getElementsByTagNameNS(NAMESPACE_URI, "ValidateActivePoint");
            for (int i = 0; i < activePointNodes.getLength(); ++i) {
                Element activePointElement = (Element)activePointNodes.item(i);
                String activePoint = XmlUtil.elementText(activePointElement, "ActivePoint");
                if (activePoint == null || activePoint.isEmpty()) continue;
                content.addPoint(FunctionRuleConstant.VALIDATE_POINT_COVERT.getOrDefault(activePoint, activePoint));
            }
        }
    }
}

