/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionRuleUtil {
    private static final Pattern PATTERN = Pattern.compile("FormulaContainer\\.(.*?)\\.dcxml");
    private static final Pattern PATTERN_EMPTY = Pattern.compile("FormulaContainer\\.dcxml");

    public static String extractMiddlePart(String input) {
        if (input == null || input.trim().isEmpty()) {
            return "";
        }
        if (PATTERN_EMPTY.matcher(input).matches()) {
            return "";
        }
        Matcher matcher = PATTERN.matcher(input);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String extractMiddlePartFast(String input) {
        if (input == null) {
            return "";
        }
        String prefix = "FormulaContainer.";
        String suffix = ".dcxml";
        if (input.startsWith(prefix) && input.endsWith(suffix)) {
            String middle = input.substring(prefix.length(), input.length() - suffix.length());
            return middle;
        }
        return "";
    }

    public static boolean isValidFormat(String input) {
        if (input == null) {
            return false;
        }
        return input.startsWith("FormulaContainer.") && input.endsWith(".dcxml");
    }

    public static String buildFullString(String middlePart) {
        if (middlePart == null) {
            middlePart = "";
        }
        return "FormulaContainer." + middlePart + ".dcxml";
    }

    public static String[] splitMiddlePart(String input) {
        String middle = FunctionRuleUtil.extractMiddlePart(input);
        if (middle.isEmpty()) {
            return new String[0];
        }
        return middle.split("\\.");
    }
}

