/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.layout.bindingsource;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.layout.bindingsource.BindingSource;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.layout.bindingsource.BindingSourceContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.layout.bindingsource.CollectionBinding;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.layout.bindingsource.ColumnCustomFormat;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.layout.bindingsource.PropertyBinding;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;

public class BindingsParser {
    private static final JAXBContext context;

    public static BindingSourceContainer parser(String xmlFile) {
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            BindingSourceContainer container = (BindingSourceContainer)unmarshaller.unmarshal(new File(xmlFile));
            return container;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void processBindingSourceContainer(BindingSourceContainer container) {
        if (container != null && container.getBindingSources() != null) {
            for (BindingSource bindingSource : container.getBindingSources().getBindingSources()) {
                System.out.println("BindingSource ID: " + bindingSource.getId());
                if (bindingSource.getPropertyBindings() != null && bindingSource.getPropertyBindings().getPropertyBindings() != null) {
                    for (PropertyBinding propertyBinding : bindingSource.getPropertyBindings().getPropertyBindings()) {
                        System.out.println("  PropertyBinding ID: " + propertyBinding.getId());
                        System.out.println("    ControlName: " + propertyBinding.getControlName());
                        System.out.println("    PropertyName: " + propertyBinding.getPropertyName());
                        System.out.println("    DataMember: " + propertyBinding.getDataMember());
                    }
                }
                if (bindingSource.getCollectionBindings() == null || bindingSource.getCollectionBindings().getCollectionBindings() == null) continue;
                for (CollectionBinding collectionBinding : bindingSource.getCollectionBindings().getCollectionBindings()) {
                    System.out.println("  CollectionBinding ID: " + collectionBinding.getId());
                    System.out.println("    ControlName: " + collectionBinding.getControlName());
                    if (collectionBinding.getColumnCustomFormats() == null) continue;
                    for (ColumnCustomFormat format : collectionBinding.getColumnCustomFormats().getColumnCustomFormats()) {
                        System.out.println("      PropertyName: " + format.getPropertyName());
                        System.out.println("        CustomFormat: " + format.getCustomFormat());
                        System.out.println("        IsExpression: " + format.isExpression());
                    }
                }
            }
        }
    }

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{BindingSourceContainer.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

