/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.utils;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.config.E10DbProperties;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.ColumnUsage;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.SqlResult;
import com.digiwin.athena.ai.generate.tools.util.SpringBeanUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class SqlUtil {
    private static final String SQL_RESULTS = "sql_results.txt";

    public static void covertTxt(String inputFile, String outputFile) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class);
        List queries = (List)objectMapper.readValue(new File(inputFile), (JavaType)listType);
        StringBuilder output = new StringBuilder();
        for (Map query : queries) {
            output.append("code: ").append(query.get("code")).append("\n");
            output.append("source: ").append(query.get("source")).append("\n");
            output.append("description: ").append(query.get("description")).append("\n");
            output.append("executionResult: ").append(query.get("sqlExecutionResult")).append("\n");
            output.append("error: ").append(query.get("error")).append("\n");
            output.append("returnFields: ").append(query.get("returnFields")).append("\n");
            String sql = (String)query.get("sqlExample");
            sql = sql.replace("\\r\\n", "\n").replace("\\n", "\n").replace("\\t", "\t");
            output.append("sqlExample:\n").append(sql).append("\n");
            output.append("--------------------------------------------------------------------------------\n\n");
        }
        Files.write(Paths.get(outputFile, new String[0]), output.toString().getBytes(), new OpenOption[0]);
    }

    public static void covertTxt() throws IOException {
        String inputFile = "F:\\djworkspace\\ai-generate-tools\\sql_results.txt";
        String outputFile = "F:\\djworkspace\\ai-generate-tools\\sql_display.txt";
        SqlUtil.covertTxt(inputFile, outputFile);
    }

    public static void validateSqlExecute(List<SqlResult> sqlResults) {
        System.out.println("SQL\u68c0\u6d4b\u7ed3\u679c:");
        for (SqlResult result : sqlResults) {
            if (result.getSqlExample().startsWith("ERROR")) continue;
            SqlUtil.validateSql(result);
        }
    }

    private static void validateSql(SqlResult result) {
        String sql = result.getSqlExample();
        if (sql == null || sql.trim().isEmpty() || sql.startsWith("ERROR")) {
            result.setSqlExecutionResult("\u4e0d\u53ef\u6267\u884c:sql\u4e3a\u7a7a");
            result.setIsExecutionSuccess(Boolean.FALSE);
            return;
        }
        String testSql = SqlUtil.adaptSqlForValidation(sql);
        E10DbProperties e10DbProperties = (E10DbProperties)SpringBeanUtil.getBean(E10DbProperties.class);
        if (null == e10DbProperties) {
            e10DbProperties = new E10DbProperties();
        }
        try (Connection conn = DriverManager.getConnection(e10DbProperties.getUrl(), e10DbProperties.getUsername(), e10DbProperties.getPassword());
             PreparedStatement stmt = conn.prepareStatement(testSql);){
            stmt.setQueryTimeout(10);
            try (ResultSet rs = stmt.executeQuery();){
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                result.setSqlExecutionResult("\u53ef\u6267\u884c");
                result.setIsExecutionSuccess(Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            String detailedError = SqlUtil.enhanceErrorMessageWithAlias(e, sql, e10DbProperties.getUrl(), e10DbProperties.getUsername(), e10DbProperties.getPassword());
            System.err.println("| " + result.getCode() + " | " + detailedError + " |");
            System.err.println("\u5931\u8d25SQL:");
            System.err.println(sql);
            result.setSqlExecutionResult("\u4e0d\u53ef\u6267\u884c:" + e.getMessage());
            result.setIsExecutionSuccess(Boolean.FALSE);
        }
    }

    private static String adaptSqlForValidation(String originalSql) {
        String sql = originalSql.trim();
        if (sql.toUpperCase().startsWith("SELECT") && !sql.toUpperCase().contains(" TOP ") && !sql.toUpperCase().contains(" LIMIT ")) {
            int selectIndex = sql.toUpperCase().indexOf("SELECT");
            int fromIndex = sql.toUpperCase().indexOf("FROM");
            if (selectIndex >= 0 && fromIndex > selectIndex) {
                StringBuilder adaptedSql = new StringBuilder();
                adaptedSql.append(sql.substring(0, selectIndex + 6)).append(" TOP 1 ").append(sql.substring(selectIndex + 6));
                return adaptedSql.toString();
            }
        }
        return sql;
    }

    public static void writeTxt(List<SqlResult> sqlResults) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String jsonResult = mapper.writeValueAsString(sqlResults);
        try (FileWriter writer = new FileWriter(SQL_RESULTS);){
            writer.write(jsonResult);
        }
    }

    private static String enhanceErrorMessageWithAlias(SQLException e, String sql, String url, String username, String password) {
        String result;
        String possibleInvalidTable;
        StringBuilder enhancedMessage;
        String originalMessage;
        block6: {
            String invalidColumn;
            originalMessage = e.getMessage();
            enhancedMessage = new StringBuilder();
            if (originalMessage.contains("\u5217\u540d") && originalMessage.contains("\u65e0\u6548") && (invalidColumn = SqlUtil.extractColumnNameFromError(originalMessage)) != null) {
                try {
                    Map<String, String> aliasToTableMap = SqlUtil.parseTableAliasMapping(sql);
                    List<ColumnUsage> columnUsages = SqlUtil.findColumnUsages(sql, invalidColumn);
                    if (columnUsages.isEmpty()) break block6;
                    for (ColumnUsage usage : columnUsages) {
                        String actualTable = aliasToTableMap.get(usage.getTableAlias());
                        if (actualTable == null) continue;
                        enhancedMessage.append("\u8868\u5b57\u6bb5\u7f3a\u5931:").append(actualTable).append(".").append(invalidColumn);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (originalMessage.contains("\u5bf9\u8c61\u540d") && originalMessage.contains("\u65e0\u6548") && (possibleInvalidTable = SqlUtil.extractTableNameFromError(originalMessage)) != null) {
            enhancedMessage.append("\u8868\u7f3a\u5931:").append(possibleInvalidTable);
        }
        if (StringUtils.hasText((String)(result = enhancedMessage.toString()))) {
            return result;
        }
        return originalMessage;
    }

    private static Map<String, String> parseTableAliasMapping(String sql) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        Pattern fromPattern = Pattern.compile("FROM\\s+\\[?([^\\]\\s]+)\\]?\\s+(?:AS\\s+)?\\[?([^\\]\\s]+)\\]?", 2);
        Pattern joinPattern = Pattern.compile("(?:LEFT|RIGHT|INNER|OUTER)?\\s+JOIN\\s+\\[?([^\\]\\s]+)\\]?\\s+(?:AS\\s+)?\\[?([^\\]\\s]+)\\]?", 2);
        Matcher fromMatcher = fromPattern.matcher(sql);
        while (fromMatcher.find()) {
            String tableName = fromMatcher.group(1);
            String alias = fromMatcher.group(2);
            aliasMap.put(alias, tableName);
        }
        Matcher joinMatcher = joinPattern.matcher(sql);
        while (joinMatcher.find()) {
            String tableName = joinMatcher.group(1);
            String alias = joinMatcher.group(2);
            aliasMap.put(alias, tableName);
        }
        return aliasMap;
    }

    private static List<ColumnUsage> findColumnUsages(String sql, String columnName) {
        ArrayList<ColumnUsage> usages = new ArrayList<ColumnUsage>();
        Pattern columnPattern = Pattern.compile("\\[([^\\]]+)\\]\\.\\[(" + Pattern.quote(columnName) + ")\\]", 2);
        Matcher matcher = columnPattern.matcher(sql);
        while (matcher.find()) {
            String tableAlias = matcher.group(1);
            String column = matcher.group(2);
            usages.add(new ColumnUsage(tableAlias, column, matcher.start(), matcher.end()));
        }
        return usages;
    }

    private static String extractColumnNameFromError(String errorMessage) {
        Pattern pattern = Pattern.compile("\u5217\u540d[\\s'\"']*([^'\"\\s]+)[\\s'\"']*\u65e0\u6548");
        Matcher matcher = pattern.matcher(errorMessage);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String extractTableNameFromError(String errorMessage) {
        Pattern pattern = Pattern.compile("\u5bf9\u8c61\u540d[\\s'\"']*([^'\"\\s]+)[\\s'\"']*\u65e0\u6548");
        Matcher matcher = pattern.matcher(errorMessage);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isColumnExistsInTable(String tableName, String columnName, String url, String username, String password) {
        try (Connection conn = DriverManager.getConnection(url, username, password);){
            boolean bl;
            block14: {
                DatabaseMetaData metaData = conn.getMetaData();
                ResultSet columns = metaData.getColumns(null, null, tableName, columnName);
                try {
                    bl = columns.next();
                    if (columns == null) break block14;
                }
                catch (Throwable throwable) {
                    if (columns != null) {
                        try {
                            columns.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columns.close();
            }
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private static List<String> findSimilarColumns(String tableName, String targetColumn, String url, String username, String password) {
        ArrayList<String> similarColumns = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(url, username, password);){
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet columns = metaData.getColumns(null, null, tableName, "%");){
                while (columns.next()) {
                    String columnName = columns.getString("COLUMN_NAME");
                    if (SqlUtil.calculateLevenshteinDistance(targetColumn.toLowerCase(), columnName.toLowerCase()) > 2) continue;
                    similarColumns.add(columnName);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return similarColumns;
    }

    private static List<String> getAllTableNames(String url, String username, String password) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(url, username, password);){
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(null, null, "%", new String[]{"TABLE"});){
                while (rs.next()) {
                    tables.add(rs.getString("TABLE_NAME"));
                }
            }
        }
        return tables;
    }

    private static List<String> findSimilarTables(String targetTable, List<String> allTables) {
        ArrayList<String> similarTables = new ArrayList<String>();
        String lowerTarget = targetTable.toLowerCase();
        for (String table : allTables) {
            String lowerTable = table.toLowerCase();
            if (!lowerTable.contains(lowerTarget) && !lowerTarget.contains(lowerTable) && SqlUtil.calculateLevenshteinDistance(lowerTarget, lowerTable) > 3) continue;
            similarTables.add(table);
        }
        return similarTables;
    }

    private static int calculateLevenshteinDistance(String s1, String s2) {
        int[][] dp = new int[s1.length() + 1][s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            for (int j = 0; j <= s2.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + (s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1)));
            }
        }
        return dp[s1.length()][s2.length()];
    }

    public static void main(String[] args) throws IOException {
        String inputFile = "F:\\djworkspace\\ai-generate-tools\\sql_results.txt";
        String outputFile = "F:\\djworkspace\\ai-generate-tools\\sql_display.txt";
        SqlUtil.covertTxt(inputFile, outputFile);
    }

    static {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            System.out.println("SQL Server JDBC \u9a71\u52a8\u52a0\u8f7d\u6210\u529f");
        }
        catch (ClassNotFoundException e) {
            System.err.println("\u65e0\u6cd5\u52a0\u8f7d SQL Server JDBC \u9a71\u52a8: " + e.getMessage());
            throw new RuntimeException("JDBC \u9a71\u52a8\u52a0\u8f7d\u5931\u8d25", e);
        }
    }
}

