/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata;

import cn.hutool.core.util.IdUtil;
import cn.hutool.log.Log;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ai.generate.tools.e10.util.XmlUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.ContentArgs;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationNode;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationPair;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChainLinkedList;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.VariableArgument;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.VariableContent;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.VariablesDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.GenerateClassUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.MetadataUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.RelationTreeUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.SqlGeneratorNewUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.VariableTreeUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RelationXmlParser {
    private static final String NAMESPACE_URI = "http://schemas.dcms.com/configuration/ShareDataContainerElement";
    private static final String DATA_ENTITY_MODEL = "DataEntityModel";
    private static final String GENERAL_RELATION = "GeneralRelation";
    private static final String RELATION_PAIR = "RelationPair";
    private static final String PROPERTY_RELATION_NODE = "PropertyRelationNode";
    private static final String CONSTANT_RELATION_NODE = "ConstantRelationNode";
    private static final String PROPERTY = "property";
    private static final String CONSTANT = "constant";
    private final RelationTreeUtil relationTreeUtil;
    private final VariableTreeUtil variableTreeUtil;
    private final MetadataUtil metadataUtil;
    private final SqlGeneratorNewUtil sqlGeneratorUtil;
    private final GenerateClassUtil generateClassUtil;
    private final Set<String> deduplications = new HashSet<String>();

    public RelationXmlParser(MetadataUtil metadataUtil, RelationTreeUtil relationTreeUtil, SqlGeneratorNewUtil sqlGeneratorUtil, GenerateClassUtil generateClassUtil, VariableTreeUtil variableTreeUtil) {
        this.metadataUtil = metadataUtil;
        this.relationTreeUtil = relationTreeUtil;
        this.sqlGeneratorUtil = sqlGeneratorUtil;
        this.generateClassUtil = generateClassUtil;
        this.variableTreeUtil = variableTreeUtil;
    }

    public Result parseXml(Path path) throws Exception {
        File xmlFile = path.toFile();
        String bizCode = xmlFile.getParentFile().getName();
        List<DataEntity> dataEntityListByBizCode = this.metadataUtil.findDataEntityListByBizCode(bizCode);
        Map dataEntityMapByBizCode = dataEntityListByBizCode.stream().collect(Collectors.toMap(DataEntity::getName, Function.identity(), (existingValue, newValue) -> existingValue));
        ArrayList<RelationDefinition> relations = new ArrayList<RelationDefinition>();
        ArrayList<VariablesDefinition> variablesDefinitions = new ArrayList<VariablesDefinition>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlFile);
        NodeList dataEntityModels = document.getElementsByTagNameNS(NAMESPACE_URI, DATA_ENTITY_MODEL);
        for (int i = 0; i < dataEntityModels.getLength(); ++i) {
            Element dataEntityModel = (Element)dataEntityModels.item(i);
            String fromEntity = XmlUtil.elementText(dataEntityModel, "From");
            String fromCode = XmlUtil.elementText(dataEntityModel, "Id");
            this.createFixedGeneralRelation((DataEntity)dataEntityMapByBizCode.get(fromEntity), document, dataEntityModel);
            NodeList generalRelations = dataEntityModel.getElementsByTagNameNS(NAMESPACE_URI, GENERAL_RELATION);
            for (int j = 0; j < generalRelations.getLength(); ++j) {
                Element generalRelation = (Element)generalRelations.item(j);
                RelationDefinition relation = this.parseGeneralRelation(generalRelation, fromEntity, fromCode, bizCode);
                relations.add(relation);
            }
            NodeList generalVariables = dataEntityModel.getElementsByTagNameNS(NAMESPACE_URI, "Variable");
            for (int j = 0; j < generalVariables.getLength(); ++j) {
                Element generalVariable = (Element)generalVariables.item(j);
                VariablesDefinition variablesDefinition = this.parseVariables(generalVariable, fromEntity, fromCode, bizCode);
                variablesDefinitions.add(variablesDefinition);
            }
        }
        List<RelationDefinition> relationDefinitions = this.relationTreeUtil.build(bizCode, relations);
        List<VariablesDefinition> variablesDefinitionsList = this.variableTreeUtil.build(bizCode, variablesDefinitions);
        this.sqlGeneratorUtil.generateSqlList(relationDefinitions);
        this.generateClassUtil.generateClassList(relationDefinitions);
        return new Result(relationDefinitions, variablesDefinitionsList);
    }

    private void createFixedGeneralRelation(DataEntity dataEntity, Document document, Element dataEntityModel) {
        if (null == dataEntity) {
            return;
        }
        dataEntity.getColumns().stream().filter(t -> "ReferenceProperty".equals(t.getPropertyType())).forEach(dataProperty -> {
            DataProperty nameDataProperty = this.metadataUtil.resolveColumnPath(dataProperty.getReferenceToName());
            DataEntity d = this.metadataUtil.findDataEntity(nameDataProperty.getItemDataEntityTypeName());
            if (d == null) {
                Log.get().error("\u627e\u4e0d\u5230ReferenceToName\u5bf9\u5e94\u7684\u5b9e\u4f53\uff1a" + nameDataProperty.getItemDataEntityTypeName(), new Object[0]);
                return;
            }
            Element generalRelation = document.createElementNS(NAMESPACE_URI, GENERAL_RELATION);
            Element idElement = document.createElementNS(NAMESPACE_URI, "Id");
            idElement.setTextContent(IdUtil.randomUUID());
            generalRelation.appendChild(idElement);
            Element nameElement = document.createElementNS(NAMESPACE_URI, "Name");
            String name = "RL_" + nameDataProperty.getItemDataEntityTypeName();
            nameElement.setTextContent(name);
            generalRelation.appendChild(nameElement);
            boolean contains = this.deduplications.contains(name + ":" + dataEntity.getName());
            if (contains) {
                return;
            }
            this.deduplications.add(name + ":" + dataEntity.getName());
            Element displayNameElement = document.createElementNS(NAMESPACE_URI, "DisplayName");
            displayNameElement.setTextContent(dataProperty.getDisplayName());
            generalRelation.appendChild(displayNameElement);
            Element relationToElement = document.createElementNS(NAMESPACE_URI, "RelationTo");
            relationToElement.setTextContent(dataProperty.getReferenceToName());
            generalRelation.appendChild(relationToElement);
            Element relationPairsElement = document.createElementNS(NAMESPACE_URI, "RelationPairs");
            Element relationPairElement = document.createElementNS(NAMESPACE_URI, RELATION_PAIR);
            Element relationPairId = document.createElementNS(NAMESPACE_URI, "Id");
            relationPairId.setTextContent(IdUtil.randomUUID());
            relationPairElement.appendChild(relationPairId);
            Element fromElement = document.createElementNS(NAMESPACE_URI, "From");
            Element propertyRelationNodeFrom = document.createElementNS(NAMESPACE_URI, PROPERTY_RELATION_NODE);
            Element fromId = document.createElementNS(NAMESPACE_URI, "Id");
            fromId.setTextContent(IdUtil.randomUUID());
            propertyRelationNodeFrom.appendChild(fromId);
            Element fromName = document.createElementNS(NAMESPACE_URI, "Name");
            fromName.setTextContent(dataProperty.getName());
            propertyRelationNodeFrom.appendChild(fromName);
            fromElement.appendChild(propertyRelationNodeFrom);
            relationPairElement.appendChild(fromElement);
            Element toElement = document.createElementNS(NAMESPACE_URI, "To");
            Element propertyRelationNodeTo = document.createElementNS(NAMESPACE_URI, PROPERTY_RELATION_NODE);
            Element toId = document.createElementNS(NAMESPACE_URI, "Id");
            toId.setTextContent(IdUtil.randomUUID());
            propertyRelationNodeTo.appendChild(toId);
            Element toName = document.createElementNS(NAMESPACE_URI, "Name");
            toName.setTextContent(d.getPrimaryKey());
            propertyRelationNodeTo.appendChild(toName);
            toElement.appendChild(propertyRelationNodeTo);
            relationPairElement.appendChild(toElement);
            relationPairsElement.appendChild(relationPairElement);
            generalRelation.appendChild(relationPairsElement);
            dataEntityModel.appendChild(generalRelation);
        });
    }

    private RelationDefinition parseGeneralRelation(Element relationElement, String fromEntity, String fromCode, String bizCode) {
        RelationDefinition relation = new RelationDefinition();
        relation.setBusinessCode(bizCode);
        relation.setCode(XmlUtil.elementText(relationElement, "Id"));
        relation.setName(XmlUtil.elementText(relationElement, "Name"));
        relation.setDisplayName(XmlUtil.elementText(relationElement, "DisplayName"));
        relation.setFromCode(fromCode);
        relation.setFromEntity(fromEntity);
        String relationTo = XmlUtil.elementText(relationElement, "RelationTo");
        relation.setToFullPath(relationTo);
        TableChainLinkedList tableChainLinkedList = this.metadataUtil.tableChainLinkedList(relationTo);
        relation.setToEntity(tableChainLinkedList.getTail().getData().getEntityName());
        relation.setToTable(tableChainLinkedList.getTail().getData().getTableName());
        List<RelationPair> relationPairs = this.parseRelationPairs(relationElement);
        relation.setRelations(relationPairs);
        Set<String> dependencyItems = this.extractDependencyItems(relationPairs);
        relation.setDependencyItems(new ArrayList<String>(dependencyItems));
        return relation;
    }

    private VariablesDefinition parseVariables(Element variableElement, String fromEntity, String fromCode, String bizCode) {
        VariablesDefinition variablesDefinition = new VariablesDefinition();
        variablesDefinition.setBusinessCode(bizCode);
        variablesDefinition.setCode(XmlUtil.elementText(variableElement, "Id"));
        variablesDefinition.setName(XmlUtil.elementText(variableElement, "Name"));
        variablesDefinition.setDisplayName(XmlUtil.elementText(variableElement, "DisplayName"));
        variablesDefinition.setValidExpression(XmlUtil.elementText(variableElement, "ValidExpression"));
        variablesDefinition.setFunctionName(XmlUtil.elementText(variableElement, "FunctionName"));
        List<VariableArgument> variableArguments = this.parseArguments(variableElement);
        variablesDefinition.setVariableArguments(variableArguments);
        variablesDefinition.setEntityName(fromEntity);
        VariableContent variableContent = new VariableContent();
        variableContent.setFunctionName(variablesDefinition.getFunctionName());
        variableContent.setContextTypeKey(variablesDefinition.getName());
        variableContent.setValidExpression(variablesDefinition.getValidExpression());
        if (CollectionUtils.isNotEmpty(variableArguments)) {
            variablesDefinition.setDependencyItems(variableArguments.stream().map(VariableArgument::getExpression).toList());
            List<ContentArgs> contentArgs = this.variableArgumentsToContentArgs(variableArguments);
            variableContent.setArgs(contentArgs);
        }
        variablesDefinition.setContent(JSON.toJSONString((Object)variableContent));
        return variablesDefinition;
    }

    private List<ContentArgs> variableArgumentsToContentArgs(List<VariableArgument> variableArguments) {
        ArrayList<ContentArgs> contentArgList = new ArrayList<ContentArgs>();
        for (VariableArgument variableArgument : variableArguments) {
            ContentArgs contentArgs = new ContentArgs();
            contentArgs.setId(variableArgument.getId());
            contentArgs.setName(variableArgument.getDisplayName());
            contentArgs.setValue(variableArgument.getExpression());
            contentArgList.add(contentArgs);
        }
        return contentArgList;
    }

    private List<VariableArgument> parseArguments(Element relationElement) {
        ArrayList<VariableArgument> variableArguments = new ArrayList<VariableArgument>();
        Element argumentsElement = XmlUtil.getElement(relationElement, "Arguments");
        if (argumentsElement == null) {
            return variableArguments;
        }
        NodeList variableArgumentNodes = argumentsElement.getElementsByTagNameNS(NAMESPACE_URI, "VariableArgument");
        for (int i = 0; i < variableArgumentNodes.getLength(); ++i) {
            Element variableArgumentElement = (Element)variableArgumentNodes.item(i);
            VariableArgument variableArgument = this.parseVariableArgument(variableArgumentElement);
            if (variableArgument == null) continue;
            variableArguments.add(variableArgument);
        }
        return variableArguments;
    }

    private List<RelationPair> parseRelationPairs(Element relationElement) {
        ArrayList<RelationPair> relationPairs = new ArrayList<RelationPair>();
        Element relationPairsElement = XmlUtil.getElement(relationElement, "RelationPairs");
        if (relationPairsElement == null) {
            return relationPairs;
        }
        NodeList relationPairNodes = relationPairsElement.getElementsByTagNameNS(NAMESPACE_URI, RELATION_PAIR);
        for (int i = 0; i < relationPairNodes.getLength(); ++i) {
            Element relationPairElement = (Element)relationPairNodes.item(i);
            RelationPair relationPair = this.parseRelationPair(relationPairElement);
            if (relationPair == null) continue;
            relationPairs.add(relationPair);
        }
        return relationPairs;
    }

    private VariableArgument parseVariableArgument(Element pairElement) {
        VariableArgument variableArgument = new VariableArgument();
        variableArgument.setId(XmlUtil.elementText(pairElement, "Id"));
        variableArgument.setExpression(XmlUtil.elementText(pairElement, "Expression"));
        variableArgument.setDisplayName(XmlUtil.elementText(pairElement, "DisplayName"));
        return variableArgument;
    }

    private RelationPair parseRelationPair(Element pairElement) {
        Element toElement;
        RelationPair relationPair = new RelationPair();
        relationPair.setId(XmlUtil.elementText(pairElement, "Id"));
        Element fromElement = XmlUtil.getElement(pairElement, "From");
        if (fromElement != null) {
            RelationNode fromNode = this.parseRelationNode(fromElement);
            relationPair.setFrom(fromNode);
        }
        if ((toElement = XmlUtil.getElement(pairElement, "To")) != null) {
            RelationNode toNode = this.parseRelationNode(toElement);
            relationPair.setTo(toNode);
        }
        return relationPair;
    }

    private RelationNode parseRelationNode(Element containerElement) {
        Element propertyNode = XmlUtil.getElement(containerElement, PROPERTY_RELATION_NODE);
        if (propertyNode != null) {
            return this.parsePropertyRelationNode(propertyNode);
        }
        Element constantNode = XmlUtil.getElement(containerElement, CONSTANT_RELATION_NODE);
        if (constantNode != null) {
            return this.parseConstantRelationNode(constantNode);
        }
        return null;
    }

    private RelationNode parsePropertyRelationNode(Element propertyElement) {
        RelationNode node = new RelationNode();
        node.setType(PROPERTY);
        node.setId(XmlUtil.elementText(propertyElement, "Id"));
        node.setName(XmlUtil.elementText(propertyElement, "Name"));
        if (!node.getName().contains("Parent")) {
            DataProperty dataProperty = this.metadataUtil.resolveColumnPath(node.getName());
            node.setFieldName(dataProperty.getAlias());
        }
        return node;
    }

    private RelationNode parseConstantRelationNode(Element constantElement) {
        RelationNode node = new RelationNode();
        node.setType(CONSTANT);
        node.setId(XmlUtil.elementText(constantElement, "Id"));
        node.setValue(this.parseConstantValue(XmlUtil.elementText(constantElement, "Value")));
        node.setDbType(XmlUtil.elementText(constantElement, "DBType"));
        return node;
    }

    private Object parseConstantValue(String value) {
        if (value == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return Boolean.parseBoolean(value);
        }
        if ("Y".equals(value) || "N".equals(value)) {
            return value;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                return value;
            }
        }
    }

    private Set<String> extractDependencyItems(List<RelationPair> relationPairs) {
        HashSet<String> dependencies = new HashSet<String>();
        for (RelationPair pair : relationPairs) {
            RelationNode fromNode = pair.getFrom();
            if (fromNode == null || !PROPERTY.equals(fromNode.getType())) continue;
            dependencies.add(fromNode.getName());
        }
        return dependencies;
    }

    public static class Result {
        private List<RelationDefinition> relationDefinitionList;
        private List<VariablesDefinition> variableList;

        @Generated
        public List<RelationDefinition> getRelationDefinitionList() {
            return this.relationDefinitionList;
        }

        @Generated
        public List<VariablesDefinition> getVariableList() {
            return this.variableList;
        }

        @Generated
        public void setRelationDefinitionList(List<RelationDefinition> relationDefinitionList) {
            this.relationDefinitionList = relationDefinitionList;
        }

        @Generated
        public void setVariableList(List<VariablesDefinition> variableList) {
            this.variableList = variableList;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<RelationDefinition> this$relationDefinitionList = this.getRelationDefinitionList();
            List<RelationDefinition> other$relationDefinitionList = other.getRelationDefinitionList();
            if (this$relationDefinitionList == null ? other$relationDefinitionList != null : !((Object)this$relationDefinitionList).equals(other$relationDefinitionList)) {
                return false;
            }
            List<VariablesDefinition> this$variableList = this.getVariableList();
            List<VariablesDefinition> other$variableList = other.getVariableList();
            return !(this$variableList == null ? other$variableList != null : !((Object)this$variableList).equals(other$variableList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<RelationDefinition> $relationDefinitionList = this.getRelationDefinitionList();
            result = result * 59 + ($relationDefinitionList == null ? 43 : ((Object)$relationDefinitionList).hashCode());
            List<VariablesDefinition> $variableList = this.getVariableList();
            result = result * 59 + ($variableList == null ? 43 : ((Object)$variableList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelationXmlParser.Result(relationDefinitionList=" + String.valueOf(this.getRelationDefinitionList()) + ", variableList=" + String.valueOf(this.getVariableList()) + ")";
        }

        @Generated
        public Result(List<RelationDefinition> relationDefinitionList, List<VariablesDefinition> variableList) {
            this.relationDefinitionList = relationDefinitionList;
            this.variableList = variableList;
        }

        @Generated
        public Result() {
        }
    }
}

