/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChain;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChainNode;
import lombok.Generated;

public class TableChainLinkedList {
    private TableChainNode head;
    private TableChainNode tail;
    private int size;

    public void add(TableChain data) {
        TableChainNode newNode = new TableChainNode(data);
        if (this.head == null) {
            this.head = this.tail = newNode;
        } else {
            this.tail.setNext(newNode);
            newNode.setPrev(this.tail);
            this.tail = newNode;
        }
        ++this.size;
    }

    public void insert(int index, TableChain data) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (index == this.size) {
            this.add(data);
            return;
        }
        TableChainNode newNode = new TableChainNode(data);
        if (index == 0) {
            newNode.setNext(this.head);
            this.head.setPrev(newNode);
            this.head = newNode;
        } else {
            TableChainNode current = this.getNode(index);
            TableChainNode prevNode = current.getPrev();
            prevNode.setNext(newNode);
            newNode.setPrev(prevNode);
            newNode.setNext(current);
            current.setPrev(newNode);
        }
        ++this.size;
    }

    private TableChainNode getNode(int index) {
        TableChainNode current;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (index < this.size / 2) {
            current = this.head;
            for (int i = 0; i < index; ++i) {
                current = current.getNext();
            }
        } else {
            current = this.tail;
            for (int i = this.size - 1; i > index; --i) {
                current = current.getPrev();
            }
        }
        return current;
    }

    public TableChain get(int index) {
        return this.getNode(index).getData();
    }

    public TableChain remove(int index) {
        TableChainNode nodeToRemove = this.getNode(index);
        TableChain data = nodeToRemove.getData();
        TableChainNode prevNode = nodeToRemove.getPrev();
        TableChainNode nextNode = nodeToRemove.getNext();
        if (prevNode != null) {
            prevNode.setNext(nextNode);
        } else {
            this.head = nextNode;
        }
        if (nextNode != null) {
            nextNode.setPrev(prevNode);
        } else {
            this.tail = prevNode;
        }
        --this.size;
        return data;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public TableChainNode findNodeByEntityName(String entityName) {
        for (TableChainNode current = this.head; current != null; current = current.getNext()) {
            if (!current.getData().getEntityName().equals(entityName)) continue;
            return current;
        }
        return null;
    }

    public static void traverseToTail(TableChainNode node) {
        for (TableChainNode current = node; current != null; current = current.getNext()) {
        }
    }

    public static void traverseToHead(TableChainNode node) {
        for (TableChainNode current = node; current != null; current = current.getPrev()) {
        }
    }

    @Generated
    public TableChainNode getHead() {
        return this.head;
    }

    @Generated
    public TableChainNode getTail() {
        return this.tail;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public void setHead(TableChainNode head) {
        this.head = head;
    }

    @Generated
    public void setTail(TableChainNode tail) {
        this.tail = tail;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableChainLinkedList)) {
            return false;
        }
        TableChainLinkedList other = (TableChainLinkedList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        TableChainNode this$head = this.getHead();
        TableChainNode other$head = other.getHead();
        if (this$head == null ? other$head != null : !((Object)this$head).equals(other$head)) {
            return false;
        }
        TableChainNode this$tail = this.getTail();
        TableChainNode other$tail = other.getTail();
        return !(this$tail == null ? other$tail != null : !((Object)this$tail).equals(other$tail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableChainLinkedList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        TableChainNode $head = this.getHead();
        result = result * 59 + ($head == null ? 43 : ((Object)$head).hashCode());
        TableChainNode $tail = this.getTail();
        result = result * 59 + ($tail == null ? 43 : ((Object)$tail).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TableChainLinkedList(head=" + String.valueOf(this.getHead()) + ", tail=" + String.valueOf(this.getTail()) + ", size=" + this.getSize() + ")";
    }

    @Generated
    public TableChainLinkedList(TableChainNode head, TableChainNode tail, int size) {
        this.head = head;
        this.tail = tail;
        this.size = size;
    }

    @Generated
    public TableChainLinkedList() {
    }
}

