/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils;

import cn.hutool.log.Log;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.PathResult;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.TableChainLinkedList;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.covert.RelationDefinitonMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.MetadataUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class RelationTreeUtil {
    private final MetadataUtil metadataUtil;

    public RelationTreeUtil(MetadataUtil metadataUtil) {
        this.metadataUtil = metadataUtil;
    }

    public List<RelationDefinition> build(String bizCode, List<RelationDefinition> oldRelations) {
        List<DataEntity> dataEntityListByBizCode = this.metadataUtil.findDataEntityListByBizCode(bizCode);
        List<PathResult> pathResults = this.smartExpand(dataEntityListByBizCode);
        List<RelationDefinition> newRelations = this.buildTree(pathResults, oldRelations);
        return this.flattenTreeIterative(newRelations);
    }

    public List<RelationDefinition> buildTree(List<PathResult> pathResults, List<RelationDefinition> oldRelations) {
        oldRelations = this.deduplicateByRuleStream(oldRelations);
        Map<String, List<RelationDefinition>> fromEntityMap = oldRelations.stream().collect(Collectors.groupingBy(RelationDefinition::getFromEntity));
        ArrayList<RelationDefinition> roots = new ArrayList<RelationDefinition>();
        for (PathResult pathResult : pathResults) {
            List<RelationDefinition> rootNodes = fromEntityMap.get(pathResult.getName());
            ArrayList<RelationDefinition> newRootNodes = new ArrayList<RelationDefinition>();
            for (RelationDefinition relationDefinition : rootNodes) {
                int counter = 0;
                for (String path : pathResult.getPaths()) {
                    RelationDefinition newRelationDefinition = RelationDefinitonMapper.INSTANCE.to(relationDefinition);
                    newRelationDefinition.setFromFullPath(path);
                    TableChainLinkedList tableChainLinkedList = this.metadataUtil.tableChainLinkedList(path);
                    newRelationDefinition.setFromTable(tableChainLinkedList.getTail().getData().getTableName());
                    newRelationDefinition.setCounter(counter++);
                    newRootNodes.add(newRelationDefinition);
                }
            }
            fromEntityMap.remove(pathResult.getName());
            roots.addAll(newRootNodes);
        }
        HashSet<String> distinct = new HashSet<String>();
        for (RelationDefinition root : roots) {
            this.fillChildren(root, fromEntityMap, distinct);
        }
        return roots;
    }

    private void fillChildren(RelationDefinition parent, Map<String, List<RelationDefinition>> fromEntityMap, Set<String> distinct) {
        String toFullPath = parent.getToFullPath();
        List<RelationDefinition> children = fromEntityMap.getOrDefault(parent.getToEntity(), List.of());
        List<RelationDefinition> newChildren = RelationDefinitonMapper.INSTANCE.to(children);
        newChildren.removeIf(t -> distinct.contains(String.join((CharSequence)":", parent.getToEntity(), t.getFromEntity())));
        for (RelationDefinition newChild : newChildren) {
            newChild.setFromFullPath(toFullPath);
            TableChainLinkedList tableChainLinkedList = this.metadataUtil.tableChainLinkedList(toFullPath);
            newChild.setFromTable(tableChainLinkedList.getTail().getData().getTableName());
            distinct.add(String.join((CharSequence)":", parent.getToEntity(), newChild.getFromEntity()));
        }
        parent.setChild(newChildren);
        for (RelationDefinition child : children) {
            this.fillChildren(child, fromEntityMap, distinct);
        }
    }

    public List<RelationDefinition> deduplicateByRuleStream(List<RelationDefinition> list) {
        String fromCode;
        String fromEntity;
        HashMap<String, String> entityToFirstCode = new HashMap<String, String>();
        ArrayList<RelationDefinition> result = new ArrayList<RelationDefinition>();
        for (RelationDefinition item : list) {
            fromEntity = item.getFromEntity();
            fromCode = item.getFromCode();
            if (fromEntity == null || entityToFirstCode.containsKey(fromEntity)) continue;
            entityToFirstCode.put(fromEntity, fromCode);
        }
        for (RelationDefinition item : list) {
            fromEntity = item.getFromEntity();
            fromCode = item.getFromCode();
            String firstCode = (String)entityToFirstCode.get(fromEntity);
            if (Objects.equals(firstCode, fromCode)) {
                result.add(item);
                continue;
            }
            Log.get().info("\u820d\u5f03\u6570\u636e: fromEntity:" + fromEntity + ", fromCode:" + fromCode, new Object[0]);
        }
        return result;
    }

    public void printTree(List<RelationDefinition> nodes, int level) {
        if (nodes == null) {
            return;
        }
        for (RelationDefinition node : nodes) {
            String indent = "  ".repeat(level);
            String arrow = level == 0 ? "" : "\u2514\u2500\u2500 ";
            System.out.println(indent + arrow + "fromFullPath: " + node.getFromFullPath() + " (fromEntity: " + node.getFromEntity() + ") \u2192 toFullPath: " + node.getToFullPath() + " (name: " + node.getName() + " displayName: " + node.getDisplayName() + ")");
            if (node.getChild() == null || node.getChild().isEmpty()) continue;
            this.printTree(node.getChild(), level + 1);
        }
    }

    public List<RelationDefinition> flattenTreeIterative(List<RelationDefinition> treeList) {
        ArrayList<RelationDefinition> result = new ArrayList<RelationDefinition>();
        if (treeList == null || treeList.isEmpty()) {
            return result;
        }
        Stack<RelationDefinition> stack = new Stack<RelationDefinition>();
        for (int i = treeList.size() - 1; i >= 0; --i) {
            stack.push(treeList.get(i));
        }
        while (!stack.isEmpty()) {
            RelationDefinition node = (RelationDefinition)stack.pop();
            RelationDefinition newNode = RelationDefinitonMapper.INSTANCE.to(node);
            newNode.setChild(null);
            result.add(newNode);
            if (node.getChild() == null || node.getChild().isEmpty()) continue;
            for (int i = node.getChild().size() - 1; i >= 0; --i) {
                stack.push(node.getChild().get(i));
            }
        }
        return result;
    }

    public List<PathResult> smartExpand(List<DataEntity> entities) {
        HashMap<String, Set<String>> graph = new HashMap<String, Set<String>>();
        HashMap<String, Integer> indegree = new HashMap<String, Integer>();
        HashSet<String> allNodes = new HashSet<String>();
        for (DataEntity entity : entities) {
            allNodes.add(entity.getName());
        }
        for (DataEntity entity : entities) {
            String from = entity.getName();
            List<String> toList = entity.getColumns().stream().map(DataProperty::getItemDataEntityTypeName).filter(Objects::nonNull).filter(item -> !item.isEmpty()).toList();
            for (String to : toList) {
                graph.computeIfAbsent(from, k -> new HashSet()).add(to);
                indegree.put(to, indegree.getOrDefault(to, 0) + 1);
                allNodes.add(to);
            }
        }
        HashSet rootNodes = new HashSet(allNodes);
        rootNodes.removeAll(indegree.keySet());
        HashMap<String, Set<String>> nodePaths = new HashMap<String, Set<String>>();
        for (String root : rootNodes) {
            this.collectPathsFromRoot(root, root, graph, nodePaths);
        }
        return nodePaths.entrySet().stream().map(entry -> new PathResult((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()))).collect(Collectors.toList());
    }

    private void collectPathsFromRoot(String current, String path, Map<String, Set<String>> graph, Map<String, Set<String>> result) {
        Set<String> neighbors;
        if (!result.containsKey(current) || !result.get(current).contains(path)) {
            result.computeIfAbsent(current, k -> new HashSet()).add(path);
        }
        if ((neighbors = graph.get(current)) != null) {
            for (String neighbor : neighbors) {
                this.collectPathsFromRoot(neighbor, path + "." + neighbor, graph, result);
            }
        }
    }
}

