/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.PathResult;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.VariablesDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.covert.VariableDefinitionMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.MetadataUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class VariableTreeUtil {
    private final MetadataUtil metadataUtil;

    public VariableTreeUtil(MetadataUtil metadataUtil) {
        this.metadataUtil = metadataUtil;
    }

    public List<VariablesDefinition> build(String bizCode, List<VariablesDefinition> oldVariables) {
        List<DataEntity> dataEntityListByBizCode = this.metadataUtil.findDataEntityListByBizCode(bizCode);
        List<PathResult> pathResults = this.smartExpand(dataEntityListByBizCode);
        List<VariablesDefinition> newRelations = this.fillFullPath(pathResults, oldVariables);
        return newRelations;
    }

    public List<VariablesDefinition> fillFullPath(List<PathResult> pathResults, List<VariablesDefinition> variablesDefinitions) {
        Map<String, List<VariablesDefinition>> fromEntityMap = variablesDefinitions.stream().collect(Collectors.groupingBy(VariablesDefinition::getEntityName));
        ArrayList<VariablesDefinition> roots = new ArrayList<VariablesDefinition>();
        for (PathResult pathResult : pathResults) {
            List<VariablesDefinition> rootNodes = fromEntityMap.get(pathResult.getName());
            if (CollectionUtils.isEmpty(rootNodes)) continue;
            ArrayList<VariablesDefinition> newRootNodes = new ArrayList<VariablesDefinition>();
            for (VariablesDefinition variablesDefinition : rootNodes) {
                int counter = 0;
                for (String path : pathResult.getPaths()) {
                    VariablesDefinition newVariablesDefinition = VariableDefinitionMapper.INSTANCE.to(variablesDefinition);
                    newVariablesDefinition.setEntityFullName(path);
                    newVariablesDefinition.setCounter(counter++);
                    newRootNodes.add(newVariablesDefinition);
                }
            }
            fromEntityMap.remove(pathResult.getName());
            roots.addAll(newRootNodes);
        }
        return roots;
    }

    public List<PathResult> smartExpand(List<DataEntity> entities) {
        HashMap<String, Set<String>> graph = new HashMap<String, Set<String>>();
        HashMap<String, Integer> indegree = new HashMap<String, Integer>();
        HashSet<String> allNodes = new HashSet<String>();
        for (DataEntity entity : entities) {
            allNodes.add(entity.getName());
        }
        for (DataEntity entity : entities) {
            String from = entity.getName();
            List<String> toList = entity.getColumns().stream().map(DataProperty::getItemDataEntityTypeName).filter(Objects::nonNull).filter(item -> !item.isEmpty()).toList();
            for (String to : toList) {
                graph.computeIfAbsent(from, k -> new HashSet()).add(to);
                indegree.put(to, indegree.getOrDefault(to, 0) + 1);
                allNodes.add(to);
            }
        }
        HashSet rootNodes = new HashSet(allNodes);
        rootNodes.removeAll(indegree.keySet());
        HashMap<String, Set<String>> nodePaths = new HashMap<String, Set<String>>();
        for (String root : rootNodes) {
            this.collectPathsFromRoot(root, root, graph, nodePaths);
        }
        return nodePaths.entrySet().stream().map(entry -> new PathResult((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()))).collect(Collectors.toList());
    }

    private void collectPathsFromRoot(String current, String path, Map<String, Set<String>> graph, Map<String, Set<String>> result) {
        Set<String> neighbors;
        if (!result.containsKey(current) || !result.get(current).contains(path)) {
            result.computeIfAbsent(current, k -> new HashSet()).add(path);
        }
        if ((neighbors = graph.get(current)) != null) {
            for (String neighbor : neighbors) {
                this.collectPathsFromRoot(neighbor, path + "." + neighbor, graph, result);
            }
        }
    }
}

