/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.ui.dto;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class NamespaceAwareUnmarshaller {
    public static <T> T unmarshalIgnoreNamespace(Class<T> clazz, File file) throws JAXBException, SAXException, ParserConfigurationException, FileNotFoundException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
        NamespaceFilter namespaceFilter = new NamespaceFilter();
        namespaceFilter.setParent(xmlReader);
        InputSource inputSource = new InputSource(new FileInputStream(file));
        SAXSource saxSource = new SAXSource(namespaceFilter, inputSource);
        Object result = unmarshaller.unmarshal((Source)saxSource);
        return (T)result;
    }

    public static <T> T unmarshalIgnoreNamespace(Class<T> clazz, InputStream inputStream) throws JAXBException, SAXException, ParserConfigurationException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
        NamespaceFilter namespaceFilter = new NamespaceFilter();
        namespaceFilter.setParent(xmlReader);
        InputSource inputSource = new InputSource(inputStream);
        SAXSource saxSource = new SAXSource(namespaceFilter, inputSource);
        Object result = unmarshaller.unmarshal((Source)saxSource);
        return (T)result;
    }

    private static class NamespaceFilter
    extends XMLFilterImpl {
        private NamespaceFilter() {
        }

        private Attributes removeNamespaceFromAttributes(Attributes atts) {
            if (atts == null || atts.getLength() == 0) {
                return atts;
            }
            AttributesImpl newAtts = new AttributesImpl();
            for (int i = 0; i < atts.getLength(); ++i) {
                String localName = atts.getLocalName(i);
                if (localName == null || localName.isEmpty()) {
                    localName = atts.getQName(i);
                }
                newAtts.addAttribute("", localName, localName, atts.getType(i), atts.getValue(i));
            }
            return newAtts;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String elementName = localName != null && !localName.isEmpty() ? localName : qName;
            Attributes newAtts = this.removeNamespaceFromAttributes(atts);
            super.startElement("", elementName, elementName, newAtts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String elementName = localName != null && !localName.isEmpty() ? localName : qName;
            super.endElement("", elementName, elementName);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }
    }
}

