/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.ai.generate.tools.common.service.CommonGenerateToolsService;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProcessLog;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProduct;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProcessLogMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductVersionMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateHolder;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.PropertiesUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.enums.ProductEnum;
import com.digiwin.athena.ai.generate.tools.service.Step;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;

@Service
public class E108GenerateToolsServiceImpl
extends CommonGenerateToolsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E108GenerateToolsServiceImpl.class);
    @Autowired
    private List<ObjectService> objectServices;
    @Value(value="${e10.root:}")
    private String e10RootPath;
    @Value(value="${e10.typeKeys:}")
    private List<String> typeKeys;
    @Autowired
    private SclProductMapper sclProductMapper;
    @Autowired
    private SclProductVersionMapper sclProductVersionMapper;
    @Autowired
    private SclProcessLogMapper sclProcessLogMapper;

    public boolean condition(ProductEnum productEnum) {
        return ProductEnum.E10_8 == productEnum;
    }

    public GenerateHolder execute(GenerateRequestDTO generateRequestDTO) {
        List objectTypeEnumList = generateRequestDTO.getObjectTypeEnumList();
        String name = generateRequestDTO.getProductNo();
        String version = generateRequestDTO.getVersion();
        SclProduct sclProduct = this.sclProductMapper.selectByName(name);
        if (sclProduct == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1", name));
        }
        SclProductVersion sclProductVersion = this.sclProductVersionMapper.selectByProductIdAndVersion(sclProduct.getId(), version);
        if (sclProductVersion == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1\u7684\u3010%s\u3011\u7248\u672c", name, version));
        }
        E10ExecuteContext context = new E10ExecuteContext();
        context.setSclProduct(sclProduct);
        context.setSclProductVersion(sclProductVersion);
        E10Properties e10Properties = PropertiesUtil.getE10Properties(ObjectUtils.isEmpty((Object)generateRequestDTO.getRootPath()) ? this.e10RootPath : generateRequestDTO.getRootPath(), CollectionUtil.isEmpty((Collection)generateRequestDTO.getTypeKeys()) ? this.typeKeys : generateRequestDTO.getTypeKeys());
        context.setE10Properties(e10Properties);
        ArrayList objectTypeEnums = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)objectTypeEnumList)) {
            objectTypeEnums.addAll(objectTypeEnumList.stream().filter(ObjectTypeEnum::getEnable).collect(Collectors.toList()));
        } else {
            objectTypeEnums.addAll(Arrays.stream(ObjectTypeEnum.values()).filter(ObjectTypeEnum::getEnable).collect(Collectors.toList()));
        }
        List objectServiceList = this.objectServices.stream().filter(objectService -> objectTypeEnums.contains(objectService.objectTypeEnum())).collect(Collectors.toList());
        objectServiceList.sort(Comparator.comparing(Step::stepIndex));
        String requestId = UUID.randomUUID().toString();
        for (ObjectService objectService2 : objectServiceList) {
            StopWatch stopWatch = new StopWatch();
            SclProcessLog sclProcessLog = SclProcessLog.builder().id(Long.valueOf(this.getNextId())).productVersionId(sclProductVersion.getId()).createTime(new Date()).step(objectService2.desc()).orderNo(objectService2.stepIndex()).code("Ongoing").requestId(requestId).build();
            this.sclProcessLogMapper.insert((Object)sclProcessLog);
            try {
                stopWatch.start(generateRequestDTO.getProductNo() + "_" + generateRequestDTO.getVersion() + "-->" + objectService2.desc());
                if (!objectTypeEnums.contains(objectService2.objectTypeEnum())) continue;
                log.info("\u5f00\u59cb\u4ea7\u54c1\uff1a{}\uff0c\u7248\u672c\u53f7\uff1a{}\u5bf9\u5e94{}\u6570\u636e\u62bd\u53d6", new Object[]{generateRequestDTO.getProductNo(), generateRequestDTO.getVersion(), objectService2.desc()});
                objectService2.execute(context, generateRequestDTO);
                log.info("\u4ea7\u54c1\uff1a{}\uff0c\u7248\u672c\u53f7\uff1a{}\u5bf9\u5e94{}\u6570\u636e\u62bd\u53d6\u5df2\u5b8c\u6210", new Object[]{generateRequestDTO.getProductNo(), generateRequestDTO.getVersion(), objectService2.desc()});
                stopWatch.stop();
                log.info(stopWatch.prettyPrint());
                sclProcessLog.setConsumeTime(String.valueOf(stopWatch.getTotalTimeSeconds()));
                sclProcessLog.setMessage(stopWatch.prettyPrint());
                sclProcessLog.setCode("Success");
            }
            catch (Exception e) {
                log.error("{}\u62bd\u53d6\u5904\u5f02\u5e38", (Object)objectService2.desc());
                sclProcessLog.setCode("Error");
                sclProcessLog.setMessage(e.getMessage());
                throw new RuntimeException(e);
            }
            finally {
                sclProcessLog.setUpdateTime(new Date());
                this.sclProcessLogMapper.updateById((Object)sclProcessLog);
            }
        }
        return new GenerateHolder();
    }

    public GenerateHolder clear(GenerateRequestDTO generateRequestDTO) {
        return super.clear(generateRequestDTO);
    }
}

