/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.MetadataParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.sub.EntitySubObject;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;

@Service
public class E10EntityObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10EntityObjectServiceImpl.class);
    @Autowired
    private List<EntitySubObject> entitySubObjects;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.ENTITY;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws Exception {
        MetadataParser object = new MetadataParser(context.getE10Properties());
        object.parser();
        context.setEntityMap(object.getEntityMap());
        context.setEntities(object.getAllDataEntitys());
        HashMap<String, Long> entityFieldIdsRel = new HashMap<String, Long>();
        ArrayList<String> databases = new ArrayList<String>();
        E10EntityObjectServiceImpl.entityParentFill(object.getAllDataEntitys(), object.getEntityMap(), entityFieldIdsRel, databases);
        context.setEntityFieldIdsRel(entityFieldIdsRel);
        Map<String, DataEntity> collect = object.getEntityMap().entrySet().stream().filter(res -> databases.contains(res.getKey())).collect(Collectors.toMap(res -> (String)res.getKey(), res -> (DataEntity)res.getValue()));
        collect.put("ReferToEntity", object.getEntityMap().get("ReferToEntity"));
        this.entitySubObjects.sort(Comparator.comparing(res -> res.stepIndex()));
        this.entitySubObjects.forEach(res -> {
            if (res.enable().booleanValue()) {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start(generateRequestDTO.getProductNo() + "_" + generateRequestDTO.getVersion() + "-->" + res.desc());
                res.execute(context, object.getAllDataEntitys(), collect);
                log.info("\u4ea7\u54c1\uff1a{}\uff0c\u7248\u672c\u53f7\uff1a{}\u5bf9\u5e94{}\u6570\u636e\u62bd\u53d6\u5df2\u5b8c\u6210", new Object[]{generateRequestDTO.getProductNo(), generateRequestDTO.getVersion(), res.desc()});
                stopWatch.stop();
                log.info(stopWatch.prettyPrint());
            }
        });
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.ENTITY.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.ENTITY.getDesc();
    }

    private static void entityParentFill(List<DataEntity> allDataEntitys, Map<String, DataEntity> entityMap, Map<String, Long> entityFieldIdsRel, List<String> databases) {
        List distinct = allDataEntitys.stream().filter(res -> "Database".equals(res.getDomain())).distinct().collect(Collectors.toList());
        distinct.add(entityMap.get("ReferToEntity"));
        for (DataEntity allDataEntity : distinct) {
            List<DataProperty> collect;
            databases.add(allDataEntity.getName());
            List<DataProperty> columns = allDataEntity.getColumns();
            String tableName = allDataEntity.getName();
            List<String> itemDataEntityTypeNames = allDataEntity.getItemDataEntityTypeNames();
            DataEntity dataEntity = entityMap.get(allDataEntity.getName());
            if (CollectionUtils.isNotEmpty(itemDataEntityTypeNames)) {
                if (ObjectUtils.isEmpty((Object)dataEntity.getId())) {
                    dataEntity.setId(IdUtil.getId());
                }
                for (String itemDataEntityTypeName : itemDataEntityTypeNames) {
                    DataEntity child = entityMap.get(itemDataEntityTypeName);
                    if (ObjectUtils.isEmpty((Object)child.getParentId())) {
                        child.setParentId(dataEntity.getId());
                    }
                    if (!ObjectUtils.isEmpty((Object)child.getId())) continue;
                    child.setId(IdUtil.getId());
                }
            } else if (ObjectUtils.isEmpty((Object)dataEntity.getId())) {
                allDataEntity.setId(IdUtil.getId());
            }
            if (!CollectionUtils.isNotEmpty(collect = columns.stream().distinct().collect(Collectors.toList()))) continue;
            collect.forEach(res -> {
                res.setEntityId(allDataEntity.getId());
                String columName = res.getName();
                if (entityFieldIdsRel.containsKey(tableName + "&" + columName)) {
                    log.info("tableName:{},key:==>{}", (Object)tableName, (Object)(tableName + "&" + columName));
                } else {
                    entityFieldIdsRel.put(tableName + "&" + columName, IdUtil.getId());
                }
            });
        }
    }
}

