/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclModuleJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleJobMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.util.GroupObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.JobDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.ProgramInfoParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.programInfo.ProgramInfo;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.programInfo.ProgramInfoContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.job.workflow.WorkFlowProgramInfoContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10JobObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10JobObjectServiceImpl.class);
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclModuleJobMapper sclModuleJobMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.JOB;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws Exception {
        E10Properties.ProgramInfoContainerInfo programInfoContainer;
        List<String> xmlFiles;
        List<ProgramInfo> programInfoList = context.getProgramInfoList();
        SclProductVersion sclProductVersion = context.getSclProductVersion();
        if (CollectionUtils.isEmpty(programInfoList) && CollectionUtils.isNotEmpty(xmlFiles = FileLister.getFilePathsWithSuffix((programInfoContainer = context.getE10Properties().getProgramInfoContainer()).getPath(), programInfoContainer.getRegex()))) {
            log.debug("\u627e\u5230{}\u4e2a{}\u6587\u4ef6 ", (Object)xmlFiles.size(), (Object)programInfoContainer.getRegex());
            ArrayList programInfoListTmp = new ArrayList();
            Map<Integer, List<String>> integerListMap = GroupObjectUtil.groupBySizeWithStream(xmlFiles, 20);
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                integerListMap.forEach((groupNo, data) -> executor.submit(() -> E10JobObjectServiceImpl.parserJob(data, programInfoListTmp)));
            }
            programInfoList.addAll(programInfoListTmp);
        }
        ArrayList<SclJob> jobs = new ArrayList<SclJob>();
        ArrayList<SclModuleJob> moduleJobs = new ArrayList<SclModuleJob>();
        Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
        Map<String, List<Long>> typeKeysModuleIdRel = context.getTypeKeysModuleIdRel();
        List programInfos = programInfoList.stream().distinct().toList();
        HashMap<String, List<JobDTO>> businessCodeToJobCode = new HashMap<String, List<JobDTO>>();
        for (ProgramInfo programInfo : programInfos) {
            JobDTO jobDTO;
            List<JobDTO> jobCodes;
            if (MapUtils.isNotEmpty(typeKeysModuleIdRel) && CollectionUtils.isNotEmpty((Collection)typeKeysModuleIdRel.get(programInfo.getTypeKey()))) {
                List<Long> modules = typeKeysModuleIdRel.get(programInfo.getTypeKey());
                for (Long id : modules) {
                    SclModuleJob sclModuleJob = new SclModuleJob();
                    sclModuleJob.setJobCode(programInfo.getId());
                    sclModuleJob.setId(IdUtil.getId());
                    sclModuleJob.setProductVersionId(sclProductVersion.getId());
                    sclModuleJob.setModuleId(id);
                    moduleJobs.add(sclModuleJob);
                }
            }
            SclJob sclJob = new SclJob();
            sclJob.setCode(programInfo.getId());
            sclJob.setId(IdUtil.getId());
            sclJob.setCategory(programInfo.getCategory());
            sclJob.setDescription(programInfo.getDescription());
            sclJob.setName(programInfo.getDisplayName());
            sclJob.setProductVersionId(sclProductVersion.getId());
            if (MapUtils.isNotEmpty(businessObjectsRel)) {
                Long aLong = MapUtils.getLong(businessObjectsRel, (Object)programInfo.getTypeKey());
                sclJob.setBusinessObjectId(Long.valueOf(aLong == null ? -1L : aLong));
            }
            sclJob.setEx1(programInfo.getLocation());
            sclJob.setEx2(programInfo.getTypeKey());
            jobs.add(sclJob);
            if (businessCodeToJobCode.containsKey(programInfo.getTypeKey())) {
                jobCodes = (List)businessCodeToJobCode.get(programInfo.getTypeKey());
                jobDTO = new JobDTO();
                jobDTO.setCode(programInfo.getId());
                jobDTO.setBusinessCode(programInfo.getTypeKey());
                jobDTO.setLocation(programInfo.getLocation());
                jobCodes.add(jobDTO);
                continue;
            }
            jobCodes = new ArrayList();
            jobDTO = new JobDTO();
            jobDTO.setCode(programInfo.getId());
            jobDTO.setBusinessCode(programInfo.getTypeKey());
            jobDTO.setLocation(programInfo.getLocation());
            jobCodes.add(jobDTO);
            businessCodeToJobCode.put(programInfo.getTypeKey(), jobCodes);
        }
        if (CollectionUtils.isNotEmpty(jobs)) {
            context.setBusinessCodeToJobCode(businessCodeToJobCode);
            List<SclJob> list = jobs.stream().filter(res -> res.getBusinessObjectId() != -1L).toList();
            this.sclJobMapper.insert(list);
            Map<String, Long> jobsRel = list.stream().collect(Collectors.toMap(SclJob::getCode, SclJob::getId, (existingValue, newValue) -> existingValue));
            context.setJobsRel(jobsRel);
            ArrayList<SclModuleJob> sclModuleJobs = new ArrayList<SclModuleJob>();
            for (SclModuleJob moduleJob : moduleJobs) {
                if (null != jobsRel.get(moduleJob.getJobCode())) {
                    moduleJob.setJobId(jobsRel.get(moduleJob.getJobCode()));
                    sclModuleJobs.add(moduleJob);
                    continue;
                }
                log.warn("\u4f5c\u4e1a{}\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u6a21\u5757", (Object)moduleJob.getJobCode());
            }
            this.sclModuleJobMapper.insert(sclModuleJobs);
        }
    }

    private static void parserJob(List<String> xmlFiles, List<ProgramInfo> programInfoList) {
        for (String filePath : xmlFiles) {
            Object parser;
            if (new File(filePath).getName().startsWith("Workflow")) {
                parser = null;
                try {
                    parser = ProgramInfoParser.workFlowParser(filePath);
                }
                catch (JAXBException e) {
                    throw new RuntimeException(e);
                }
                if (null == ((WorkFlowProgramInfoContainer)parser).getWorkflowProgramInfos() || !CollectionUtils.isNotEmpty(((WorkFlowProgramInfoContainer)parser).getWorkflowProgramInfos().getWorkFlowProgramInfoList())) continue;
                ((WorkFlowProgramInfoContainer)parser).getWorkflowProgramInfos().getWorkFlowProgramInfoList().forEach(res -> {
                    ProgramInfo programInfo = new ProgramInfo();
                    programInfo.setCategory(res.getCategory());
                    programInfo.setStrategy(res.getStrategy());
                    programInfo.setLocation(res.getLocation());
                    programInfo.setTypeKey(res.getTypeKey());
                    programInfo.setTitleExpression(res.getTitleExpression());
                    programInfo.setDescription(res.getDescription());
                    programInfo.setDisplayName(res.getDisplayName());
                    programInfoList.add(programInfo);
                });
                continue;
            }
            parser = null;
            try {
                parser = ProgramInfoParser.parser(filePath);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            if (null == ((ProgramInfoContainer)parser).getProgramInfos() || !CollectionUtils.isNotEmpty(((ProgramInfoContainer)parser).getProgramInfos().getProgramInfoList())) continue;
            programInfoList.addAll(((ProgramInfoContainer)parser).getProgramInfos().getProgramInfoList());
        }
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.JOB.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.JOB.getDesc();
    }
}

