/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclLayout;
import com.digiwin.athena.ai.generate.tools.db.bo.SclLayoutComponent;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclLayoutComponentMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclLayoutMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.layout.LayoutParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class E10LayoutObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10LayoutObjectServiceImpl.class);
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclLayoutMapper sclLayoutMapper;
    @Autowired
    private SclLayoutComponentMapper sclLayoutComponentMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.LAYOUT;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        List jobs = this.sclJobMapper.selectByProductVersionId(context.getSclProductVersion().getId());
        List layouts = jobs.stream().map(res -> {
            SclLayout sclLayout = new SclLayout();
            sclLayout.setCode(res.getCode());
            sclLayout.setName(res.getName());
            sclLayout.setJobId(res.getId());
            sclLayout.setProductVersionId(context.getSclProductVersion().getId());
            sclLayout.setDescription(res.getDescription());
            sclLayout.setId(IdUtil.getId());
            return sclLayout;
        }).collect(Collectors.toList());
        this.sclLayoutMapper.insert(layouts);
        Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
        Map<Long, String> idToCode = businessObjectsRel.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<Long, Long> JobIdToLayoutId = layouts.stream().collect(Collectors.toMap(SclLayout::getJobId, SclLayout::getId, (e, n) -> n));
        E10Properties e10Properties = context.getE10Properties();
        ArrayList result = new ArrayList();
        jobs.stream().forEach(res -> {
            String businessCode = (String)idToCode.get(res.getBusinessObjectId());
            if (!ObjectUtils.isEmpty((Object)res.getEx1())) {
                E10LayoutObjectServiceImpl.setCommonParam(e10Properties.getLayoutRoot() + "/" + businessCode + "/LayoutContainer." + res.getEx1() + ".dcxml", context, JobIdToLayoutId, res, result);
            } else {
                E10LayoutObjectServiceImpl.setCommonParam(e10Properties.getLayoutRoot() + "/" + businessCode + "/LayoutContainer.dcxml", context, JobIdToLayoutId, res, result);
            }
        });
        this.sclLayoutComponentMapper.insert(result);
    }

    private static void setCommonParam(String e10Properties, E10ExecuteContext context, Map<Long, Long> jobIdToLayoutId, SclJob res, List<SclLayoutComponent> result) {
        List<Object> sclLayoutComponents = new ArrayList();
        try {
            sclLayoutComponents = LayoutParser.parserSingleFile(new File(e10Properties));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        if (CollectionUtils.isNotEmpty(sclLayoutComponents)) {
            sclLayoutComponents.forEach(sclLayoutComponent -> {
                sclLayoutComponent.setProductVersionId(context.getSclProductVersion().getId());
                sclLayoutComponent.setLayoutId((Long)jobIdToLayoutId.get(res.getId()));
            });
            result.addAll(sclLayoutComponents);
        }
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.LAYOUT.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.LAYOUT.getDesc();
    }
}

