/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ai.generate.tools.common.agent.prompt.PromptHelper;
import com.digiwin.athena.ai.generate.tools.common.agent.service.IntelligentDialogueService;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApi;
import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntity;
import com.digiwin.athena.ai.generate.tools.db.bo.SclOpenwindow;
import com.digiwin.athena.ai.generate.tools.db.bo.SclOpenwindowEntityPtyBO;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.OpenWindowsParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.E10OpenWindowConditionDto;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.E10OpenWindowDto;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.E10OpenWindowReturnExpressionDto;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.parser.GeneralWindowOpener;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.parser.OpeningParameters;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.parser.ReturnExpressions;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.parser.SelectWindow;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.parser.SelectWindowContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.dto.parser.SelectWindows;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.openwindow.utils.FilePathUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.querycase.QueryCaseParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.querycase.dto.parser.QueryProject;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.querycase.dto.parser.QueryProjectContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.querycase.dto.parser.SimpleConditionColumns;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.querycase.dto.parser.SingleConditionColumn;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.SclOpenwindowService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class E10OpenWindowServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10OpenWindowServiceImpl.class);
    @Autowired
    private IntelligentDialogueService intelligentDialogueService;
    @Autowired
    private SclOpenwindowService sclOpenwindowService;
    private final String PACKAGE_NAME = "com.digiwin.athenai.reactive.delegate.mock";

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.OPEN_WINDOW;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws Exception {
        File file = new File("E:\\RAG\\E80KF-20251011092257\\DeployServer\\Shared\\BusinessObjects\\PURCHASE_ARRIVAL\\SelectWindowContainer.dcxml");
        this.parserSingleFile(context, file);
    }

    private void parserSingleFile(E10ExecuteContext context, File file) {
        List<SelectWindowContainer> containers = OpenWindowsParser.parser(file);
        if (CollectionUtils.isEmpty(containers)) {
            return;
        }
        for (SelectWindowContainer container : containers) {
            Optional.ofNullable(container.getSelectWindows()).map(SelectWindows::getSelectWindow).orElse(List.of()).forEach(selectWindow -> this.processSelectWindow(context, file, (SelectWindow)selectWindow));
        }
    }

    private void processSelectWindow(E10ExecuteContext context, File file, SelectWindow selectWindow) {
        if (selectWindow == null || selectWindow.getWindowOpeners() == null) {
            return;
        }
        List openerList = Optional.ofNullable(selectWindow.getWindowOpeners().getGeneralWindowOpener()).orElse(List.of());
        openerList.stream().filter(Objects::nonNull).filter(opener -> !"F2".equals(opener.getShortcut())).forEach(opener -> this.buildAndGenerate(context, file, selectWindow, (GeneralWindowOpener)opener));
    }

    private void buildAndGenerate(E10ExecuteContext context, File file, SelectWindow selectWindow, GeneralWindowOpener opener) {
        try {
            String applyTo = selectWindow.getApplyTo();
            ApplyToResult applyToResult = E10OpenWindowServiceImpl.splitByLastDot(applyTo);
            E10OpenWindowDto dto = new E10OpenWindowDto();
            dto.setPath(applyToResult.getFirstPart());
            dto.setSchemaFix(applyToResult.getLastPart());
            dto.setCode(opener.getName());
            dto.setDisplayName(opener.getTip());
            String description = (String)StringUtils.defaultIfBlank((CharSequence)opener.getDescription(), (CharSequence)opener.getTip());
            dto.setDescription(description);
            dto.setQueryProjectId(opener.getQueryProjectId());
            dto.setQueryTypeKey(opener.getQueryTypeKey());
            dto.setOpenCondition(opener.getOpenCondition());
            dto.setReturnField(opener.getReturnField());
            String className = this.buildClassName(file, opener.getName(), dto);
            dto.setWindowCode(className);
            String middle = E10OpenWindowServiceImpl.extractMiddleName(file.getName());
            dto.setLocation(middle);
            this.buildConditions(dto, file, opener);
            this.buildParameters(dto, opener);
            this.buildReturnExpressions(dto, selectWindow, opener);
            log.info("OpenWindow\u7684\u67e5\u8be2\u65b9\u6848 \u2192 {} - {}", (Object)dto.getQueryTypeKey(), (Object)dto.getQueryProjectId());
            log.info("OpenWindow\u7684\u62a5\u6587 \u2192 {}", (Object)JSON.toJSONString((Object)dto));
            dto.setPackageName("com.digiwin.athenai.reactive.delegate.mock");
            String prompt = PromptHelper.buildJavaOpenWindowPrompt((String)JSON.toJSONString((Object)dto), (String)"com.digiwin.athenai.reactive.delegate.mock", (String)"", (String)dto.getWindowCode(), (String)dto.getPath(), (String)dto.getSchemaFix());
            OpenWindowLLLMResult result = (OpenWindowLLLMResult)this.intelligentDialogueService.executeDialogue(prompt, (ParameterizedTypeReference)new ParameterizedTypeReference<OpenWindowLLLMResult>(this){});
            log.info("\u751f\u6210 Java \u6587\u4ef6\uff1a{}", (Object)result.getValue());
            dto.setTranslate(result.getValue());
            this.saveOpenWindow(context, dto);
        }
        catch (Exception e) {
            log.error("OpenWindow\u751f\u6210Java\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private void saveOpenWindow(E10ExecuteContext context, E10OpenWindowDto dto) {
        SclOpenwindow sclOpenwindow = new SclOpenwindow();
        Long jobId = 767364789929343L;
        sclOpenwindow.setJobId(jobId);
        ApplyToResult applyToResult = E10OpenWindowServiceImpl.splitByLastDot(dto.getPath());
        String businessName = applyToResult.getLastPart();
        if (StringUtils.isBlank((CharSequence)businessName)) {
            businessName = dto.getBusinessName();
        }
        Long productVersionId = context.getSclProductVersion().getId();
        SclOpenwindowEntityPtyBO sclOpenwindowEntityPtyBO = this.sclOpenwindowService.getEntityField(productVersionId, dto.getBusinessName(), dto.getReturnField());
        sclOpenwindow.setEntityPropertyId(sclOpenwindowEntityPtyBO.getPropertyId());
        SclApi sclApi = new SclApi();
        sclApi.setId(IdUtil.getId());
        SclBusinessObject sclBusinessObject = this.sclOpenwindowService.getBusinessObject(productVersionId, businessName);
        sclApi.setBusinessObjectId(sclBusinessObject.getId());
        sclApi.setName(dto.getCode());
        sclApi.setDisplayName(dto.getDisplayName());
        sclApi.setDescription(dto.getDescription());
        sclApi.setVersion("v1");
        sclApi.setInvokeType("sync");
        SclEntity sclEntity = this.sclOpenwindowService.selectEntityByBusinessId(sclBusinessObject.getId(), productVersionId);
        sclApi.setEntityId(sclEntity.getId());
        sclApi.setProtocol("http");
        sclApi.setMethod("post");
        sclApi.setProductVersionId(productVersionId);
        sclApi.setScript("");
        this.sclOpenwindowService.saveApi(sclApi);
        sclOpenwindow.setContent(JSON.toJSONString((Object)dto));
        sclOpenwindow.setPath(dto.getPath());
        sclOpenwindow.setSchema(dto.getSchemaFix());
        sclOpenwindow.setCode(dto.getCode());
        sclOpenwindow.setDisplayName(dto.getDisplayName());
        sclOpenwindow.setDescription(dto.getDescription());
        sclOpenwindow.setCreateTime(LocalDateTime.now());
        sclOpenwindow.setTranslate(dto.getTranslate());
        sclOpenwindow.setApiId(sclApi.getId());
        sclOpenwindow.setClassFullName(dto.getPackageName() + "." + dto.getWindowCode());
        sclOpenwindow.setProductVersionId(productVersionId);
        this.sclOpenwindowService.saveOpenwindow(sclOpenwindow);
    }

    private void buildConditions(E10OpenWindowDto dto, File file, GeneralWindowOpener opener) {
        File queryProjectContainerFile = FilePathUtil.getQueryProjectContainerFile(file, opener.getQueryTypeKey());
        QueryProjectContainer container = QueryCaseParser.parser(queryProjectContainerFile);
        if (container == null || CollectionUtils.isEmpty(container.getQueryProjects())) {
            return;
        }
        Optional<QueryProject> projectOpt = container.getQueryProjects().stream().filter(Objects::nonNull).flatMap(qps -> Optional.ofNullable(qps.getQueryProject()).orElse(List.of()).stream()).filter(qp -> qp.getId().equals(opener.getQueryProjectId())).findFirst();
        projectOpt.ifPresent(project -> {
            List columns = Optional.ofNullable(project.getSimpleConditionColumns()).map(SimpleConditionColumns::getSingleConditionColumn).orElse(List.of());
            int index = 1;
            for (SingleConditionColumn col : columns) {
                E10OpenWindowConditionDto condition = new E10OpenWindowConditionDto();
                condition.setSequence(index++);
                condition.setField_name(col.getPropertyPath());
                condition.setOperator("like");
                condition.setLogical("or");
                condition.setValue("#" + col.getPropertyPath() + "#");
                dto.getConditionList().add(condition);
            }
        });
    }

    private void buildParameters(E10OpenWindowDto dto, GeneralWindowOpener opener) {
        Optional.ofNullable(opener.getOpeningParameters()).map(OpeningParameters::getParameters).orElse(List.of()).forEach(param -> dto.getParameterList().add(Map.of(param.getName(), "#" + param.getValue() + "#")));
    }

    private void buildReturnExpressions(E10OpenWindowDto dto, SelectWindow selectWindow, GeneralWindowOpener opener) {
        E10OpenWindowReturnExpressionDto defaultExp = new E10OpenWindowReturnExpressionDto();
        defaultExp.setLeft(selectWindow.getApplyTo());
        defaultExp.setRight(opener.getReturnField());
        dto.getReturnExpressionList().add(defaultExp);
        Optional.ofNullable(opener.getReturnExpressions()).map(ReturnExpressions::getReturnExpression).orElse(List.of()).forEach(exp -> {
            E10OpenWindowReturnExpressionDto item = new E10OpenWindowReturnExpressionDto();
            item.setName(exp.getName());
            item.setLeft(exp.getLeft());
            item.setRight(exp.getRight());
            dto.getReturnExpressionList().add(item);
        });
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.OPEN_WINDOW.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.OPEN_WINDOW.getDesc();
    }

    private String buildClassName(File file, String openerName, E10OpenWindowDto dto) {
        String businessName = file.getParentFile().getName();
        dto.setBusinessName(businessName);
        Object middle = E10OpenWindowServiceImpl.extractMiddleName(file.getName());
        if (StringUtils.isNotBlank((CharSequence)middle)) {
            middle = "_" + (String)middle;
        }
        return ("E10_" + businessName + (String)middle + "_" + openerName).replace("-", "_");
    }

    public static ApplyToResult splitByLastDot(String input) {
        if (input == null || input.isEmpty()) {
            return new ApplyToResult("", "");
        }
        int lastDotIndex = input.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return new ApplyToResult("", input);
        }
        String firstPart = input.substring(0, lastDotIndex);
        String lastPart = input.substring(lastDotIndex + 1);
        return new ApplyToResult(firstPart, lastPart);
    }

    public static String extractMiddleName(String filename) {
        if (filename == null || filename.isEmpty()) {
            return "";
        }
        int firstDot = filename.indexOf(46);
        int lastDot = filename.lastIndexOf(46);
        if (firstDot == -1 || lastDot == -1 || firstDot == lastDot) {
            return "";
        }
        String middle = filename.substring(firstDot + 1, lastDot);
        return middle.trim();
    }

    public static class ApplyToResult {
        private final String firstPart;
        private final String lastPart;

        public ApplyToResult(String firstPart, String lastPart) {
            this.firstPart = firstPart;
            this.lastPart = lastPart;
        }

        public String getFirstPart() {
            return this.firstPart;
        }

        public String getLastPart() {
            return this.lastPart;
        }

        public String toString() {
            return "Result{firstPart='" + this.firstPart + "', lastPart='" + this.lastPart + "'}";
        }
    }

    public static class OpenWindowLLLMResult {
        private String type;
        private String value;

        @Generated
        public OpenWindowLLLMResult() {
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OpenWindowLLLMResult)) {
                return false;
            }
            OpenWindowLLLMResult other = (OpenWindowLLLMResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OpenWindowLLLMResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "E10OpenWindowServiceImpl.OpenWindowLLLMResult(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }
    }
}

