/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclQueryCase;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclQueryCaseMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.SqlParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.SqlResult;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.covert.SqlResultQueryCaseMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class E10QueryEntityServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10QueryEntityServiceImpl.class);
    @Autowired
    private SclQueryCaseMapper sclQueryCaseMapper;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.QUERY_ENTITY;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        try {
            List<String> typeKeys = context.getE10Properties().getTypeKeys();
            if (CollectionUtil.isEmpty(typeKeys)) {
                this.parserInsert(context, null);
            } else {
                for (String typeKey : typeKeys) {
                    this.parserInsert(context, typeKey);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parserInsert(E10ExecuteContext context, String code) throws Exception {
        SqlParser sqlParser = new SqlParser(context.getEntityMap(), context.getDicPropertyMap());
        List<Path> pathList = StrUtil.isEmpty((CharSequence)code) ? FileLister.getFilePathsWithFileName(context.getE10Properties().getQueryBusinessObjectsRoot(), "QueryProjectContainer.dcxml") : FileLister.getFilePathsWithFileName(context.getE10Properties().getQueryBusinessObjectsRoot(), code, "QueryProjectContainer.dcxml");
        for (Path p : pathList) {
            sqlParser.parseXmlToSql(p);
        }
        List<SqlResult> sqlResults = sqlParser.getSqlResults();
        Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
        List<SqlResult> filteredResults = sqlResults.stream().filter(sqlResult -> StringUtils.hasText((String)sqlResult.getSqlExample()) && sqlResult.getIsExecutionSuccess() != false).peek(sqlResult -> {
            sqlResult.setId(IdUtil.getId());
            sqlResult.setBusinessObjectId((Long)businessObjectsRel.get(sqlResult.getBusinessCode()));
            sqlResult.setProductVersionId(context.getSclProductVersion().getId());
        }).collect(Collectors.toList());
        List<SclQueryCase> sclQueryCaseList = SqlResultQueryCaseMapper.INSTANCE.to(filteredResults);
        Map<Long, List<SclQueryCase>> listMap = sclQueryCaseList.stream().filter(o -> o.getBusinessObjectId() != null).collect(Collectors.groupingBy(SclQueryCase::getBusinessObjectId));
        List sclBusinessObjects = this.sclBusinessObjectMapper.selectByIds(listMap.keySet());
        Map sclBusinessObjectMap = sclBusinessObjects.stream().collect(Collectors.toMap(SclBusinessObject::getId, Function.identity()));
        listMap.forEach((businessObjectId, sclQueryCases) -> {
            SclBusinessObject sclBusinessObject = (SclBusinessObject)sclBusinessObjectMap.get(businessObjectId);
            if (sclBusinessObject != null) {
                sclQueryCases.forEach(sclQueryCase -> sclQueryCase.setDescription(sclQueryCase.getName() + sclBusinessObject.getName()));
            }
        });
        this.sclQueryCaseMapper.insert(sclQueryCaseList);
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.QUERY_ENTITY.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.QUERY_ENTITY.getDesc();
    }
}

