/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApi;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApiInputParam;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApiOutputParam;
import com.digiwin.athena.ai.generate.tools.db.bo.SclJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclJobFunction;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiInputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiOutputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclDictMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobFunctionMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.queryproject.QueryProjectApiParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.queryproject.dto.QueryProjectContainer;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10QueryProjectApiObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10QueryProjectApiObjectServiceImpl.class);
    @Autowired
    private SclJobFunctionMapper sclJobFunctionMapper;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclApiMapper sclApiMapper;
    @Autowired
    private SclApiInputParamMapper sclApiInputParamMapper;
    @Autowired
    private SclApiOutputParamMapper sclApiOutputParamMapper;
    @Autowired
    private SclDictMapper sclDictMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.QUERY_PROJECT_API;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws Exception {
        HashSet<String> businessCodes = new HashSet<String>(context.getBusinessCodeToJobCode().keySet());
        businessCodes.forEach(businessCode -> {
            List<Path> pathWithFileNameRoot = FileLister.getFilePathsWithFileName(context.getE10Properties().getQueryProjectRoot() + "/" + businessCode, "QueryProjectContainer.dcxml");
            if (CollectionUtils.isNotEmpty(pathWithFileNameRoot)) {
                Path path = pathWithFileNameRoot.getFirst();
                log.info("\u89e3\u6790\u6587\u4ef6\uff1a{}", (Object)path.toString());
                QueryProjectContainer queryProjectContainer = QueryProjectApiParser.readQueryProjectContainerFromXml(path);
                QueryProjectContainer.QueryProjects queryProjects1 = queryProjectContainer.getQueryProjects();
                if (queryProjects1 != null) {
                    List<QueryProjectContainer.OoqlQueryProject> ooqlQueryProjects;
                    List<QueryProjectContainer.QueryProject> queryProjects = queryProjects1.getQueryProjects();
                    if (CollectionUtils.isNotEmpty(queryProjects)) {
                        queryProjects.forEach(queryProject -> this.handleQueryProjects(context, (String)businessCode, (QueryProjectContainer.AbstractQueryProject)queryProject));
                    }
                    if (CollectionUtils.isNotEmpty(ooqlQueryProjects = queryProjectContainer.getQueryProjects().getOoqlQueryProjects())) {
                        ooqlQueryProjects.forEach(queryProject -> this.handleQueryProjects(context, (String)businessCode, (QueryProjectContainer.AbstractQueryProject)queryProject));
                    }
                }
            }
        });
    }

    private void handleQueryProjects(E10ExecuteContext context, String businessCode, QueryProjectContainer.AbstractQueryProject queryProject) {
        if (queryProject.getProjectType().equals("Browse")) {
            Long businessObjectId = context.getBusinessObjectsRel().get(businessCode);
            if (businessObjectId == null) {
                return;
            }
            SclApi sclApi = this.getSclApi(context, businessCode, queryProject);
            List<SclApiInputParam> sclApiInputParamList = this.sclApiInputParam(context, sclApi);
            List<SclApiOutputParam> sclApiOutputParamList = this.sclApiOutputParam(context, sclApi, queryProject);
            String editorViewName = queryProject.getEditorViewName();
            SclJobFunction sclJobFunction = this.jobFunction(context, businessCode, queryProject, editorViewName, sclApi);
            this.sclApiMapper.insert((Object)sclApi);
            if (CollectionUtils.isNotEmpty(sclApiInputParamList)) {
                this.sclApiInputParamMapper.insert(sclApiInputParamList);
            }
            if (CollectionUtils.isNotEmpty(sclApiOutputParamList)) {
                this.sclApiOutputParamMapper.insert(sclApiOutputParamList);
            }
            if (sclJobFunction != null) {
                this.sclJobFunctionMapper.insert((Object)sclJobFunction);
            }
        }
    }

    private SclJobFunction jobFunction(E10ExecuteContext context, String businessCode, QueryProjectContainer.AbstractQueryProject queryProject, String editorViewName, SclApi sclApi) {
        if (StringUtils.isNotBlank((CharSequence)editorViewName)) {
            SclJob sclJob;
            Long jobId = context.getJobsRel().get(editorViewName);
            if (jobId != null && (sclJob = (SclJob)this.sclJobMapper.selectById((Serializable)jobId)) != null) {
                SclJobFunction exists = this.sclJobFunctionMapper.selectByJobIdAndCode(sclJob.getId(), queryProject.getId());
                if (exists != null) {
                    return null;
                }
                SclJobFunction sclJobFunction = new SclJobFunction();
                sclJobFunction.setId(this.getId());
                sclJobFunction.setJobId(jobId);
                sclJobFunction.setWrite(false);
                sclJobFunction.setName(queryProject.getDisplayName());
                sclJobFunction.setCode(queryProject.getId());
                sclJobFunction.setApiId(sclApi.getId());
                sclJobFunction.setDescription(sclJob.getName() + queryProject.getDisplayName());
                sclJobFunction.setProductVersionId(sclApi.getProductVersionId());
                return sclJobFunction;
            }
        } else {
            List sclJobs = this.sclJobMapper.selectByBusinessObjectIds(Collections.singletonList(context.getBusinessObjectsRel().get(businessCode)));
            Optional<SclJob> optionalSclJob = sclJobs.stream().filter(o -> o.getEx1() == null).findFirst();
            if (optionalSclJob.isPresent()) {
                SclJob sclJob = optionalSclJob.get();
                SclJobFunction exists = this.sclJobFunctionMapper.selectByJobIdAndCode(sclJob.getId(), queryProject.getId());
                if (exists != null) {
                    return null;
                }
                SclJobFunction sclJobFunction = new SclJobFunction();
                sclJobFunction.setId(this.getId());
                sclJobFunction.setJobId(sclJob.getId());
                sclJobFunction.setWrite(false);
                sclJobFunction.setName(queryProject.getDisplayName());
                sclJobFunction.setCode(queryProject.getId());
                sclJobFunction.setApiId(sclApi.getId());
                sclJobFunction.setDescription(sclJob.getName() + queryProject.getDisplayName());
                sclJobFunction.setProductVersionId(sclApi.getProductVersionId());
                return sclJobFunction;
            }
        }
        return null;
    }

    private SclApi getSclApi(E10ExecuteContext context, String businessCode, QueryProjectContainer.AbstractQueryProject queryProject) {
        SclApi sclApi = new SclApi();
        sclApi.setId(this.getId());
        Long businessObjectId = context.getBusinessObjectsRel().get(businessCode);
        sclApi.setBusinessObjectId(businessObjectId);
        sclApi.setEntityId(context.getEntityIdsRel().get(queryProject.getQueryEntity()));
        sclApi.setVersion("1.0");
        sclApi.setProductVersionId(context.getSclProductVersion().getId());
        sclApi.setName("e10.marsc.selectwindow.data.get");
        sclApi.setEx1("QueryProjectContainer");
        sclApi.setEx2(queryProject.getId());
        sclApi.setDisplayName(queryProject.getDisplayName());
        sclApi.setMethod("post");
        sclApi.setInvokeType("sync");
        sclApi.setProtocol("http");
        sclApi.setDescription(queryProject.getDisplayName());
        return sclApi;
    }

    private List<SclApiOutputParam> sclApiOutputParam(E10ExecuteContext context, SclApi sclApi, QueryProjectContainer.AbstractQueryProject queryProject) {
        ArrayList<SclApiOutputParam> sclApiOutputParamList = new ArrayList<SclApiOutputParam>();
        SclApiOutputParam cntOutputParam = new SclApiOutputParam();
        cntOutputParam.setId(this.getId());
        cntOutputParam.setApiId(sclApi.getId());
        cntOutputParam.setName("cnt");
        cntOutputParam.setDisplayName("\u603b\u8bb0\u5f55\u6570");
        cntOutputParam.setProductVersionId(sclApi.getProductVersionId());
        cntOutputParam.setIsArray(Boolean.valueOf(false));
        cntOutputParam.setType("P");
        cntOutputParam.setDescription("\u603b\u8bb0\u5f55\u6570");
        cntOutputParam.setDataType("numeric");
        sclApiOutputParamList.add(cntOutputParam);
        this.fieldsOutputParam(sclApi, sclApiOutputParamList);
        this.rowsOutputParam(context, sclApi, sclApiOutputParamList, queryProject);
        return sclApiOutputParamList;
    }

    private void rowsOutputParam(E10ExecuteContext context, SclApi sclApi, List<SclApiOutputParam> sclApiOutputParamList, QueryProjectContainer.AbstractQueryProject queryProject) {
        SclApiOutputParam fieldsOutputParam = new SclApiOutputParam();
        fieldsOutputParam.setId(this.getId());
        fieldsOutputParam.setApiId(sclApi.getId());
        fieldsOutputParam.setName("rows");
        fieldsOutputParam.setDisplayName("\u8fd4\u56de\u7684\u5185\u5bb9");
        fieldsOutputParam.setProductVersionId(sclApi.getProductVersionId());
        fieldsOutputParam.setIsArray(Boolean.valueOf(true));
        fieldsOutputParam.setType("M");
        fieldsOutputParam.setDescription("\u8fd4\u56de\u7684\u5185\u5bb9");
        fieldsOutputParam.setDataType("array");
        sclApiOutputParamList.add(fieldsOutputParam);
        List<QueryProjectContainer.QueryViewColumn> queryViewColumns = queryProject.getQueryViewColumns();
        if (CollectionUtils.isNotEmpty(queryViewColumns)) {
            queryViewColumns.forEach(queryViewColumn -> {
                String pickListTypeName;
                QueryProjectContainer.PickListLookUp pickListLookUp;
                String displayName = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)queryViewColumn.getDisplayName(), (CharSequence)queryViewColumn.getAlias());
                SclApiOutputParam queryViewColumnOutputParam = new SclApiOutputParam();
                queryViewColumnOutputParam.setId(this.getId());
                queryViewColumnOutputParam.setApiId(sclApi.getId());
                queryViewColumnOutputParam.setName(queryViewColumn.getAlias());
                queryViewColumnOutputParam.setDisplayName(displayName);
                queryViewColumnOutputParam.setProductVersionId(sclApi.getProductVersionId());
                queryViewColumnOutputParam.setIsArray(Boolean.valueOf(false));
                queryViewColumnOutputParam.setType("MF");
                queryViewColumnOutputParam.setDescription(displayName);
                queryViewColumnOutputParam.setDataType((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)queryViewColumn.getDataType(), (CharSequence)"String"));
                sclApiOutputParamList.add(queryViewColumnOutputParam);
                QueryProjectContainer.Editor editor = queryViewColumn.getEditor();
                if (editor != null && (pickListLookUp = editor.getPickListLookUp()) != null && (pickListTypeName = pickListLookUp.getPickListTypeName()) != null) {
                    Long dictId = context.getDicCodeIdRel().get(pickListTypeName);
                    queryViewColumnOutputParam.setDictId(dictId);
                }
            });
        }
    }

    private void fieldsOutputParam(SclApi sclApi, List<SclApiOutputParam> sclApiOutputParamList) {
        SclApiOutputParam fieldsOutputParam = new SclApiOutputParam();
        fieldsOutputParam.setId(this.getId());
        fieldsOutputParam.setApiId(sclApi.getId());
        fieldsOutputParam.setName("fields");
        fieldsOutputParam.setDisplayName("\u5b57\u6bb5\u63cf\u8ff0");
        fieldsOutputParam.setProductVersionId(sclApi.getProductVersionId());
        fieldsOutputParam.setIsArray(Boolean.valueOf(true));
        fieldsOutputParam.setType("M");
        fieldsOutputParam.setDescription("\u5b57\u6bb5\u63cf\u8ff0");
        fieldsOutputParam.setDataType("array");
        sclApiOutputParamList.add(fieldsOutputParam);
        SclApiOutputParam fieldsFieldNameOutputParam = new SclApiOutputParam();
        fieldsFieldNameOutputParam.setId(this.getId());
        fieldsFieldNameOutputParam.setApiId(sclApi.getId());
        fieldsFieldNameOutputParam.setName("field_name");
        fieldsFieldNameOutputParam.setDisplayName("\u680f\u4f4d\u540d\u79f0");
        fieldsFieldNameOutputParam.setProductVersionId(sclApi.getProductVersionId());
        fieldsFieldNameOutputParam.setIsArray(Boolean.valueOf(false));
        fieldsFieldNameOutputParam.setType("MF");
        fieldsFieldNameOutputParam.setDescription("\u680f\u4f4d\u540d\u79f0");
        fieldsFieldNameOutputParam.setDataType("string");
        fieldsFieldNameOutputParam.setParentId(fieldsOutputParam.getId());
        sclApiOutputParamList.add(fieldsFieldNameOutputParam);
        SclApiOutputParam fieldsTypeOutputParam = new SclApiOutputParam();
        fieldsTypeOutputParam.setId(this.getId());
        fieldsTypeOutputParam.setApiId(sclApi.getId());
        fieldsTypeOutputParam.setName("type");
        fieldsTypeOutputParam.setDisplayName("\u680f\u4f4d\u7c7b\u578b");
        fieldsTypeOutputParam.setProductVersionId(sclApi.getProductVersionId());
        fieldsTypeOutputParam.setIsArray(Boolean.valueOf(false));
        fieldsTypeOutputParam.setType("MF");
        fieldsTypeOutputParam.setDescription("\u680f\u4f4d\u7c7b\u578b");
        fieldsTypeOutputParam.setDataType("string");
        fieldsTypeOutputParam.setParentId(fieldsOutputParam.getId());
        sclApiOutputParamList.add(fieldsTypeOutputParam);
        SclApiOutputParam fieldsCaptionOutputParam = new SclApiOutputParam();
        fieldsCaptionOutputParam.setId(this.getId());
        fieldsCaptionOutputParam.setApiId(sclApi.getId());
        fieldsCaptionOutputParam.setName("caption");
        fieldsCaptionOutputParam.setDisplayName("\u680f\u4f4d\u6807\u9898");
        fieldsCaptionOutputParam.setProductVersionId(sclApi.getProductVersionId());
        fieldsCaptionOutputParam.setIsArray(Boolean.valueOf(false));
        fieldsCaptionOutputParam.setType("MF");
        fieldsCaptionOutputParam.setDescription("\u680f\u4f4d\u6807\u9898");
        fieldsCaptionOutputParam.setDataType("string");
        fieldsCaptionOutputParam.setParentId(fieldsOutputParam.getId());
        sclApiOutputParamList.add(fieldsCaptionOutputParam);
    }

    private List<SclApiInputParam> sclApiInputParam(E10ExecuteContext e10ExecuteContext, SclApi sclApi) {
        ArrayList<SclApiInputParam> sclApiInputParamList = new ArrayList<SclApiInputParam>();
        SclApiInputParam pageSizeInputParam = new SclApiInputParam();
        pageSizeInputParam.setId(this.getId());
        pageSizeInputParam.setApiId(sclApi.getId());
        pageSizeInputParam.setName("page_size");
        pageSizeInputParam.setDisplayName("\u8bf7\u6c42\u7b14\u6570");
        pageSizeInputParam.setProductVersionId(sclApi.getProductVersionId());
        pageSizeInputParam.setIsArray(Boolean.valueOf(false));
        pageSizeInputParam.setType("P");
        pageSizeInputParam.setDescription("\u6bcf\u9875\u6570\u636e\u91cf\uff0c\u6700\u592710000");
        pageSizeInputParam.setDataType("numeric");
        sclApiInputParamList.add(pageSizeInputParam);
        SclApiInputParam pageNoInputParam = new SclApiInputParam();
        pageNoInputParam.setId(this.getId());
        pageNoInputParam.setApiId(sclApi.getId());
        pageNoInputParam.setName("page_no");
        pageNoInputParam.setDisplayName("\u9875\u7801");
        pageNoInputParam.setProductVersionId(sclApi.getProductVersionId());
        pageNoInputParam.setIsArray(Boolean.valueOf(false));
        pageNoInputParam.setType("P");
        pageNoInputParam.setDescription("\u9875\u7801");
        pageNoInputParam.setDataType("numeric");
        sclApiInputParamList.add(pageNoInputParam);
        SclApiInputParam programJobNoInputParam = new SclApiInputParam();
        programJobNoInputParam.setId(this.getId());
        programJobNoInputParam.setApiId(sclApi.getId());
        programJobNoInputParam.setName("program_job_no");
        programJobNoInputParam.setDisplayName("program_job_no");
        programJobNoInputParam.setProductVersionId(sclApi.getProductVersionId());
        programJobNoInputParam.setIsArray(Boolean.valueOf(false));
        programJobNoInputParam.setType("P");
        programJobNoInputParam.setDescription("program_job_no");
        programJobNoInputParam.setDataType("string");
        sclApiInputParamList.add(programJobNoInputParam);
        SclApiInputParam queryTypeKeyInputParam = new SclApiInputParam();
        queryTypeKeyInputParam.setId(this.getId());
        queryTypeKeyInputParam.setApiId(sclApi.getId());
        queryTypeKeyInputParam.setName("query_typekey");
        queryTypeKeyInputParam.setDisplayName("query_typekey");
        queryTypeKeyInputParam.setProductVersionId(sclApi.getProductVersionId());
        queryTypeKeyInputParam.setIsArray(Boolean.valueOf(false));
        queryTypeKeyInputParam.setType("P");
        queryTypeKeyInputParam.setDescription("query_typekey");
        queryTypeKeyInputParam.setDataType("string");
        sclApiInputParamList.add(queryTypeKeyInputParam);
        SclApiInputParam queryProjectIdInputParam = new SclApiInputParam();
        queryProjectIdInputParam.setId(this.getId());
        queryProjectIdInputParam.setApiId(sclApi.getId());
        queryProjectIdInputParam.setName("query_project_id");
        queryProjectIdInputParam.setDisplayName("query_project_id");
        queryProjectIdInputParam.setProductVersionId(sclApi.getProductVersionId());
        queryProjectIdInputParam.setIsArray(Boolean.valueOf(false));
        queryProjectIdInputParam.setType("P");
        queryProjectIdInputParam.setDescription("query_project_id");
        queryProjectIdInputParam.setDataType("string");
        sclApiInputParamList.add(queryProjectIdInputParam);
        SclApiInputParam bindingFieldInputParam = new SclApiInputParam();
        bindingFieldInputParam.setId(this.getId());
        bindingFieldInputParam.setApiId(sclApi.getId());
        bindingFieldInputParam.setName("binding_field");
        bindingFieldInputParam.setDisplayName("binding_field");
        bindingFieldInputParam.setProductVersionId(sclApi.getProductVersionId());
        bindingFieldInputParam.setIsArray(Boolean.valueOf(false));
        bindingFieldInputParam.setType("P");
        bindingFieldInputParam.setDescription("binding_field");
        bindingFieldInputParam.setDataType("string");
        sclApiInputParamList.add(bindingFieldInputParam);
        SclApiInputParam isGetSchemaInputParam = new SclApiInputParam();
        isGetSchemaInputParam.setId(this.getId());
        isGetSchemaInputParam.setApiId(sclApi.getId());
        isGetSchemaInputParam.setName("is_get_schema");
        isGetSchemaInputParam.setDisplayName("\u662f\u5426\u8fd4\u56de\u67b6\u6784");
        isGetSchemaInputParam.setProductVersionId(sclApi.getProductVersionId());
        isGetSchemaInputParam.setIsArray(Boolean.valueOf(false));
        isGetSchemaInputParam.setType("P");
        isGetSchemaInputParam.setDescription("\u662f\u5426\u8fd4\u56de\u67b6\u6784");
        isGetSchemaInputParam.setDataType("boolean");
        sclApiInputParamList.add(isGetSchemaInputParam);
        SclApiInputParam isGetCountInputParam = new SclApiInputParam();
        isGetCountInputParam.setId(this.getId());
        isGetCountInputParam.setApiId(sclApi.getId());
        isGetCountInputParam.setName("is_get_count");
        isGetCountInputParam.setDisplayName("\u662f\u5426\u7edf\u8ba1\u603b\u7b14\u6570");
        isGetCountInputParam.setProductVersionId(sclApi.getProductVersionId());
        isGetCountInputParam.setIsArray(Boolean.valueOf(false));
        isGetCountInputParam.setType("P");
        isGetCountInputParam.setDescription("\u662f\u5426\u7edf\u8ba1\u603b\u7b14\u6570");
        isGetCountInputParam.setDataType("boolean");
        sclApiInputParamList.add(isGetCountInputParam);
        this.parametersInputParam(sclApi, sclApiInputParamList);
        this.conditionsInputParam(sclApi, sclApiInputParamList);
        this.ordersInputParam(sclApi, sclApiInputParamList);
        return sclApiInputParamList;
    }

    private void conditionsInputParam(SclApi sclApi, List<SclApiInputParam> sclApiInputParamList) {
        SclApiInputParam conditionsInputParam = new SclApiInputParam();
        conditionsInputParam.setId(this.getId());
        conditionsInputParam.setApiId(sclApi.getId());
        conditionsInputParam.setName("conditions");
        conditionsInputParam.setDisplayName("\u6761\u4ef6\u96c6\u5408");
        conditionsInputParam.setProductVersionId(sclApi.getProductVersionId());
        conditionsInputParam.setIsArray(Boolean.valueOf(true));
        conditionsInputParam.setType("M");
        conditionsInputParam.setDescription("\u6761\u4ef6\u96c6\u5408");
        conditionsInputParam.setDataType("array");
        sclApiInputParamList.add(conditionsInputParam);
        SclApiInputParam parametersNameInputParam = new SclApiInputParam();
        parametersNameInputParam.setId(this.getId());
        parametersNameInputParam.setApiId(sclApi.getId());
        parametersNameInputParam.setName("field_name");
        parametersNameInputParam.setDisplayName("\u5b57\u6bb5\u540d\u79f0");
        parametersNameInputParam.setProductVersionId(sclApi.getProductVersionId());
        parametersNameInputParam.setIsArray(Boolean.valueOf(false));
        parametersNameInputParam.setType("MF");
        parametersNameInputParam.setDescription("\u5b57\u6bb5\u540d\u79f0");
        parametersNameInputParam.setDataType("string");
        parametersNameInputParam.setParentId(conditionsInputParam.getId());
        sclApiInputParamList.add(parametersNameInputParam);
        SclApiInputParam parametersValueInputParam = new SclApiInputParam();
        parametersValueInputParam.setId(this.getId());
        parametersValueInputParam.setApiId(sclApi.getId());
        parametersValueInputParam.setName("value");
        parametersValueInputParam.setDisplayName("value");
        parametersValueInputParam.setProductVersionId(sclApi.getProductVersionId());
        parametersValueInputParam.setIsArray(Boolean.valueOf(false));
        parametersValueInputParam.setType("MF");
        parametersValueInputParam.setDescription("value");
        parametersValueInputParam.setDataType("string");
        parametersValueInputParam.setParentId(conditionsInputParam.getId());
        sclApiInputParamList.add(parametersValueInputParam);
        SclApiInputParam bracketInputParam = new SclApiInputParam();
        bracketInputParam.setId(this.getId());
        bracketInputParam.setApiId(sclApi.getId());
        bracketInputParam.setName("bracket");
        bracketInputParam.setDisplayName("\u62ec\u53f7\u7c7b\u578b");
        bracketInputParam.setProductVersionId(sclApi.getProductVersionId());
        bracketInputParam.setIsArray(Boolean.valueOf(false));
        bracketInputParam.setType("MF");
        bracketInputParam.setDescription("\u62ec\u53f7\u7c7b\u578b");
        bracketInputParam.setDataType("string");
        bracketInputParam.setParentId(conditionsInputParam.getId());
        sclApiInputParamList.add(bracketInputParam);
        SclApiInputParam logicalInputParam = new SclApiInputParam();
        logicalInputParam.setId(this.getId());
        logicalInputParam.setApiId(sclApi.getId());
        logicalInputParam.setName("logical");
        logicalInputParam.setDisplayName("\u903b\u8f91\u5173\u7cfb");
        logicalInputParam.setProductVersionId(sclApi.getProductVersionId());
        logicalInputParam.setIsArray(Boolean.valueOf(false));
        logicalInputParam.setType("MF");
        logicalInputParam.setDescription("\u903b\u8f91\u5173\u7cfb");
        logicalInputParam.setDataType("string");
        logicalInputParam.setParentId(conditionsInputParam.getId());
        sclApiInputParamList.add(logicalInputParam);
        SclApiInputParam sequenceInputParam = new SclApiInputParam();
        sequenceInputParam.setId(this.getId());
        sequenceInputParam.setApiId(sclApi.getId());
        sequenceInputParam.setName("sequence");
        sequenceInputParam.setDisplayName("\u689d\u4ef6\u9806\u5e8f");
        sequenceInputParam.setProductVersionId(sclApi.getProductVersionId());
        sequenceInputParam.setIsArray(Boolean.valueOf(false));
        sequenceInputParam.setType("MF");
        sequenceInputParam.setDescription("\u689d\u4ef6\u9806\u5e8f");
        sequenceInputParam.setDataType("numeric");
        sequenceInputParam.setParentId(conditionsInputParam.getId());
        sclApiInputParamList.add(sequenceInputParam);
        SclApiInputParam operatorInputParam = new SclApiInputParam();
        operatorInputParam.setId(this.getId());
        operatorInputParam.setApiId(sclApi.getId());
        operatorInputParam.setName("operator");
        operatorInputParam.setDisplayName("\u64cd\u4f5c\u7b26");
        operatorInputParam.setProductVersionId(sclApi.getProductVersionId());
        operatorInputParam.setIsArray(Boolean.valueOf(false));
        operatorInputParam.setType("MF");
        operatorInputParam.setDescription("\u64cd\u4f5c\u7b26");
        operatorInputParam.setDataType("string");
        operatorInputParam.setParentId(conditionsInputParam.getId());
        sclApiInputParamList.add(operatorInputParam);
    }

    private void ordersInputParam(SclApi sclApi, List<SclApiInputParam> sclApiInputParamList) {
        SclApiInputParam ordersInputParam = new SclApiInputParam();
        ordersInputParam.setId(this.getId());
        ordersInputParam.setApiId(sclApi.getId());
        ordersInputParam.setName("orders");
        ordersInputParam.setDisplayName("\u6392\u5e8f\u8bbe\u7f6e");
        ordersInputParam.setProductVersionId(sclApi.getProductVersionId());
        ordersInputParam.setIsArray(Boolean.valueOf(true));
        ordersInputParam.setType("M");
        ordersInputParam.setDescription("\u6392\u5e8f\u8bbe\u7f6e");
        ordersInputParam.setDataType("array");
        sclApiInputParamList.add(ordersInputParam);
        SclApiInputParam fieldNameInputParam = new SclApiInputParam();
        fieldNameInputParam.setId(this.getId());
        fieldNameInputParam.setApiId(sclApi.getId());
        fieldNameInputParam.setName("field_name");
        fieldNameInputParam.setDisplayName("\u5b57\u6bb5\u540d\u79f0");
        fieldNameInputParam.setProductVersionId(sclApi.getProductVersionId());
        fieldNameInputParam.setIsArray(Boolean.valueOf(false));
        fieldNameInputParam.setType("MF");
        fieldNameInputParam.setDescription("\u5b57\u6bb5\u540d\u79f0");
        fieldNameInputParam.setDataType("string");
        fieldNameInputParam.setParentId(ordersInputParam.getId());
        sclApiInputParamList.add(fieldNameInputParam);
        SclApiInputParam orderTypeInputParam = new SclApiInputParam();
        orderTypeInputParam.setId(this.getId());
        orderTypeInputParam.setApiId(sclApi.getId());
        orderTypeInputParam.setName("value");
        orderTypeInputParam.setDisplayName("value");
        orderTypeInputParam.setProductVersionId(sclApi.getProductVersionId());
        orderTypeInputParam.setIsArray(Boolean.valueOf(false));
        orderTypeInputParam.setType("MF");
        orderTypeInputParam.setDescription("value");
        orderTypeInputParam.setDataType("string");
        orderTypeInputParam.setParentId(ordersInputParam.getId());
        sclApiInputParamList.add(orderTypeInputParam);
    }

    private void parametersInputParam(SclApi sclApi, List<SclApiInputParam> sclApiInputParamList) {
        SclApiInputParam parametersInputParam = new SclApiInputParam();
        parametersInputParam.setId(this.getId());
        parametersInputParam.setApiId(sclApi.getId());
        parametersInputParam.setName("parameters");
        parametersInputParam.setDisplayName("parameters");
        parametersInputParam.setProductVersionId(sclApi.getProductVersionId());
        parametersInputParam.setIsArray(Boolean.valueOf(true));
        parametersInputParam.setType("M");
        parametersInputParam.setDescription("parameters");
        parametersInputParam.setDataType("array");
        sclApiInputParamList.add(parametersInputParam);
        SclApiInputParam parametersNameInputParam = new SclApiInputParam();
        parametersNameInputParam.setId(this.getId());
        parametersNameInputParam.setApiId(sclApi.getId());
        parametersNameInputParam.setName("name");
        parametersNameInputParam.setDisplayName("name");
        parametersNameInputParam.setProductVersionId(sclApi.getProductVersionId());
        parametersNameInputParam.setIsArray(Boolean.valueOf(false));
        parametersNameInputParam.setType("MF");
        parametersNameInputParam.setDescription("name");
        parametersNameInputParam.setDataType("string");
        parametersNameInputParam.setParentId(parametersInputParam.getId());
        sclApiInputParamList.add(parametersNameInputParam);
        SclApiInputParam parametersValueInputParam = new SclApiInputParam();
        parametersValueInputParam.setId(this.getId());
        parametersValueInputParam.setApiId(sclApi.getId());
        parametersValueInputParam.setName("value");
        parametersValueInputParam.setDisplayName("value");
        parametersValueInputParam.setProductVersionId(sclApi.getProductVersionId());
        parametersValueInputParam.setIsArray(Boolean.valueOf(false));
        parametersValueInputParam.setType("MF");
        parametersValueInputParam.setDescription("value");
        parametersValueInputParam.setDataType("string");
        parametersValueInputParam.setParentId(parametersInputParam.getId());
        sclApiInputParamList.add(parametersValueInputParam);
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.QUERY_PROJECT_API.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.QUERY_PROJECT_API.getDesc();
    }
}

