/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ai.generate.tools.db.bo.SclShareDataRelation;
import com.digiwin.athena.ai.generate.tools.db.bo.SclShareDataVariables;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclShareDataRelationMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclShareDataVariableMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.RelationXmlParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.RelationDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.VariablesDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.covert.SclShareDataRelationDefinitonMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.covert.SclShareDataVariableDefinitonMapper;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.GenerateClassUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.MetadataUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.RelationTreeUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.SqlGeneratorNewUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.utils.VariableTreeUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10ShareDataServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10ShareDataServiceImpl.class);
    @Autowired
    private SclShareDataRelationMapper sclShareDataRelationMapper;
    @Autowired
    private SclShareDataVariableMapper sclShareDataVariableMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.SHARE_DATA;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        try {
            Map<String, Long> businessObjectsRel = context.getBusinessObjectsRel();
            Long productVersionId = context.getSclProductVersion().getId();
            String path = context.getE10Properties().getBusinessObjectsRoot();
            List<String> typeKeys = context.getE10Properties().getTypeKeys();
            if (CollectionUtil.isEmpty(typeKeys)) {
                this.batchParserInsert(context.getEntityMap(), path, null, businessObjectsRel, productVersionId);
            } else {
                for (String typeKey : typeKeys) {
                    this.batchParserInsert(context.getEntityMap(), path, typeKey, businessObjectsRel, productVersionId);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void batchParserInsert(Map<String, DataEntity> entityMap, String path, String code, Map<String, Long> businessObjectsRel, Long productVersionId) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)code)) {
            path = (String)path + "\\" + code;
        }
        List<Path> pathList = FileLister.getFilePathsWithFileName((String)path, "ShareDataContainer.dcxml");
        MetadataUtil metadataUtil = new MetadataUtil(entityMap);
        RelationTreeUtil relationTreeUtil = new RelationTreeUtil(metadataUtil);
        SqlGeneratorNewUtil sqlGeneratorUtil = new SqlGeneratorNewUtil(metadataUtil);
        GenerateClassUtil generateClassUtil = new GenerateClassUtil();
        VariableTreeUtil variableTreeUtil = new VariableTreeUtil(metadataUtil);
        RelationXmlParser parser = new RelationXmlParser(metadataUtil, relationTreeUtil, sqlGeneratorUtil, generateClassUtil, variableTreeUtil);
        ArrayList<RelationDefinition> relations = new ArrayList<RelationDefinition>();
        ArrayList<VariablesDefinition> variablesDefinitions = new ArrayList<VariablesDefinition>();
        for (Path p : pathList) {
            RelationXmlParser.Result result = parser.parseXml(p);
            relations.addAll(result.getRelationDefinitionList());
            variablesDefinitions.addAll(result.getVariableList());
        }
        for (RelationDefinition relation : relations) {
            relation.setBusinessObjectId(businessObjectsRel.get(relation.getBusinessCode()));
            relation.setProductVersionId(productVersionId);
            relation.setId(IdUtil.getId());
        }
        if (CollectionUtils.isNotEmpty(variablesDefinitions)) {
            for (VariablesDefinition variablesDefinition : variablesDefinitions) {
                variablesDefinition.setBusinessObjectId(businessObjectsRel.get(variablesDefinition.getBusinessCode()));
                variablesDefinition.setProductVersionId(productVersionId);
                variablesDefinition.setId(IdUtil.getId());
            }
        }
        List<SclShareDataRelation> sclShareDataRelations = SclShareDataRelationDefinitonMapper.INSTANCE.to(relations);
        this.sclShareDataRelationMapper.insert(sclShareDataRelations);
        List<SclShareDataVariables> sclShareDataVariables = SclShareDataVariableDefinitonMapper.INSTANCE.to(variablesDefinitions);
        this.sclShareDataVariableMapper.insert(sclShareDataVariables);
    }

    public Integer stepIndex() {
        return ObjectTypeEnum.SHARE_DATA.getOrder();
    }

    public String desc() {
        return ObjectTypeEnum.SHARE_DATA.getDesc();
    }
}

