/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.config;

import com.digiwin.athena.ai.generate.tools.dto.Result;
import com.digiwin.athena.ai.generate.tools.exception.BusinessException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BusinessException.class})
    public Result<String> handleBusinessException(BusinessException e) {
        logger.warn("\u4e1a\u52a1\u5f02\u5e38: {}", (Object)e.getMessage());
        return Result.error((Integer)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        FieldError fieldError = e.getBindingResult().getFieldError();
        String message = fieldError != null ? fieldError.getDefaultMessage() : "\u53c2\u6570\u9519\u8bef";
        logger.warn("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38: {}", (Object)message);
        return Result.badRequest((String)message);
    }

    @ExceptionHandler(value={BindException.class})
    public Result<String> handleBindException(BindException e) {
        FieldError fieldError = e.getBindingResult().getFieldError();
        String message = fieldError != null ? fieldError.getDefaultMessage() : "\u53c2\u6570\u7ed1\u5b9a\u9519\u8bef";
        logger.warn("\u6570\u636e\u7ed1\u5b9a\u5f02\u5e38: {}", (Object)message);
        return Result.badRequest((String)message);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<String> handleConstraintViolationException(ConstraintViolationException e) {
        Set violations = e.getConstraintViolations();
        String message = violations.stream().map(ConstraintViolation::getMessage).findFirst().orElse("\u53c2\u6570\u9519\u8bef");
        logger.warn("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38: {}", (Object)message);
        return Result.badRequest((String)message);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Result<String> handleNotFoundException(NoHandlerFoundException e) {
        logger.warn("404\u5f02\u5e38: {}", (Object)e.getMessage());
        return Result.notFound((String)"\u63a5\u53e3\u4e0d\u5b58\u5728");
    }

    @ExceptionHandler(value={Exception.class})
    public Result<String> handleException(Exception e) {
        logger.error("\u7cfb\u7edf\u5f02\u5e38: ", (Throwable)e);
        return Result.error((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

