/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.controller;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.ai.generate.tools.common.agent.service.transformation.CodeIntelligentTransformationService;
import com.digiwin.athena.ai.generate.tools.db.bo.SclFunctionRule;
import com.digiwin.athena.ai.generate.tools.db.bo.TranslateData;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclFunctionRuleMapper;
import com.digiwin.athena.ai.generate.tools.dto.PythonCovertJavaDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.functionrule.constant.FunctionRuleTypeEnum;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.E10FunctionRuleServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/generate/tools/rule"})
public class CodeIntelligentTransformationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeIntelligentTransformationController.class);
    private final CodeIntelligentTransformationService codeIntelligentTransformationService;
    private final SclFunctionRuleMapper sclFunctionRuleMapper;
    private final E10FunctionRuleServiceImpl e10FunctionRuleService;
    private final Executor virtualThreadTaskExecutor;

    public CodeIntelligentTransformationController(CodeIntelligentTransformationService codeIntelligentTransformationService, SclFunctionRuleMapper sclFunctionRuleMapper, E10FunctionRuleServiceImpl e10FunctionRuleService, Executor virtualThreadTaskExecutor) {
        this.codeIntelligentTransformationService = codeIntelligentTransformationService;
        this.sclFunctionRuleMapper = sclFunctionRuleMapper;
        this.e10FunctionRuleService = e10FunctionRuleService;
        this.virtualThreadTaskExecutor = virtualThreadTaskExecutor;
    }

    @PostMapping(value={"/code/insert"})
    public void insert(@RequestBody Map<String, Object> param) {
        Long productVersionId = MapUtils.getLong(param, (Object)"productVersionId");
        String directoryPath = MapUtils.getString(param, (Object)"directoryPath");
        String type = MapUtils.getString(param, (Object)"type");
        String code = MapUtils.getString(param, (Object)"code");
        this.virtualThreadTaskExecutor.execute(() -> {
            try {
                this.e10FunctionRuleService.batchFunctionRuleParserInsert(directoryPath, code, FunctionRuleTypeEnum.getByType((String)type), productVersionId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @PostMapping(value={"/code/delete"})
    public void delete(@RequestBody Map<String, Object> param) {
        Long productVersionId = MapUtils.getLong(param, (Object)"productVersionId");
        String type = MapUtils.getString(param, (Object)"type");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SclFunctionRule::getType, (Object)type);
        queryWrapper.eq(SclFunctionRule::getProductVersionId, (Object)productVersionId);
        this.sclFunctionRuleMapper.delete((Wrapper)queryWrapper);
    }

    @PostMapping(value={"/code/query"})
    public List<SclFunctionRule> query(@RequestBody Map<String, Object> param) {
        Long productVersionId = MapUtils.getLong(param, (Object)"productVersionId");
        String code = MapUtils.getString(param, (Object)"code");
        Boolean translate = MapUtils.getBoolean(param, (Object)"translate");
        String type = MapUtils.getString(param, (Object)"type");
        List sclFunctionRules = this.sclFunctionRuleMapper.queryListByVersionAndCode(productVersionId, code, translate, type);
        StringBuilder sb = new StringBuilder();
        for (SclFunctionRule sclFunctionRule : sclFunctionRules) {
            TranslateData t = sclFunctionRule.getContent().getTranslate();
            if (t == null) continue;
            sb.append("\n").append("--------------------------------------------------------------------------");
            sb.append("\n").append(String.join((CharSequence)":", sclFunctionRule.getType(), "" + sclFunctionRule.getFuncId(), sclFunctionRule.getCode()));
            sb.append("\n").append(StringEscapeUtils.unescapeJson((String)JSONUtil.toJsonStr((Object)t.getExpression())));
            sb.append("\n").append(StringEscapeUtils.unescapeJson((String)JSONUtil.toJsonStr((Object)t.getCondition())));
        }
        log.info("query:" + String.valueOf(sb));
        return sclFunctionRules;
    }

    @PostMapping(value={"/code/covert"})
    public void covert(@RequestBody Map<String, Object> param) {
        Long productVersionId = MapUtils.getLong(param, (Object)"productVersionId");
        String code = MapUtils.getString(param, (Object)"code");
        String type = MapUtils.getString(param, (Object)"type");
        if (FunctionRuleTypeEnum.VALIDATE.getType().equalsIgnoreCase(type)) {
            this.virtualThreadTaskExecutor.execute(() -> this.e10FunctionRuleService.doFunctionRuleCovert(productVersionId, code, type));
        } else if (FunctionRuleTypeEnum.FORMULA.getType().equalsIgnoreCase(type)) {
            this.virtualThreadTaskExecutor.execute(() -> this.e10FunctionRuleService.doFunctionRuleCovert(productVersionId, code, type));
        }
    }

    @PostMapping(value={"/code/covert/formula"})
    public List<PythonCovertJavaDTO> formula(@RequestBody Map<String, Object> param) {
        Object code = MapUtils.getObject(param, (Object)"code");
        String mode = MapUtils.getString(param, (Object)"mode");
        return this.codeIntelligentTransformationService.executePythonCovertJavaDialogue(JSONUtil.toJsonStr((Object)code), mode);
    }

    @PostMapping(value={"/code/covert/validator"})
    public List<PythonCovertJavaDTO> validator(@RequestBody Map<String, Object> param) {
        Object code = MapUtils.getObject(param, (Object)"code");
        return this.codeIntelligentTransformationService.executePythonCovertJavaDialogue(JSONUtil.toJsonStr((Object)code));
    }

    @PostMapping(value={"/code/resolve"})
    public void resolve(@RequestBody Map<String, Object> param) {
        Long productVersionId = MapUtils.getLong(param, (Object)"productVersionId");
        String code = MapUtils.getString(param, (Object)"code");
        String type = MapUtils.getString(param, (Object)"type");
        this.virtualThreadTaskExecutor.execute(() -> this.e10FunctionRuleService.resolveDependencyItems(productVersionId, code, type));
    }
}

