/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.ai.generate.tools.common.agent.service.transformation.CodeIntelligentTransformationService;
import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclShareDataVariables;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclShareDataRelationMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclShareDataVariableMapper;
import com.digiwin.athena.ai.generate.tools.dto.PythonCovertJavaDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.GroupObjectUtil;
import com.digiwin.athena.ai.generate.tools.e10.util.PropertiesUtil;
import com.digiwin.athena.ai.generate.tools.e10.util.TemplateUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.MetadataParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.sharedata.dto.VariablesDefinition;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.objects.E10ShareDataServiceImpl;
import com.digiwin.athena.ai.generate.tools.service.ShareDataService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ShareDataServiceImpl
implements ShareDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShareDataServiceImpl.class);
    @Autowired
    private SclShareDataVariableMapper sclShareDataVariableMapper;
    @Autowired
    SclShareDataRelationMapper sclShareDataRelationMapper;
    @Autowired
    private CodeIntelligentTransformationService codeIntelligentTransformationService;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;
    @Autowired
    private E10ShareDataServiceImpl e10ShareDataService;

    public static void generateVariableClassList(List<VariablesDefinition> variablesDefinitions, Map<Long, String> businessObjectsRel, Map<String, PythonCovertJavaDTO> pythonCovertJavaTranslateDTOMap) {
        if (CollectionUtil.isEmpty(variablesDefinitions)) {
            return;
        }
        String classFullNameFormat = "com.digiwin.athenai.reactive.delegate.e10.sharedata.E10_%s_V_%s";
        for (VariablesDefinition definition : variablesDefinitions) {
            HashMap<String, Object> replacements = new HashMap<String, Object>();
            PythonCovertJavaDTO pythonCovertJavaDTO = pythonCovertJavaTranslateDTOMap.get(String.valueOf(definition.getId()));
            String typeKey = businessObjectsRel.get(definition.getBusinessObjectId());
            replacements.put("typeKey", typeKey);
            replacements.put("id", definition.getCode().replace("-", "_"));
            replacements.put("entityName", definition.getEntityName());
            replacements.put("entityFullName", definition.getEntityFullName());
            replacements.put("name", definition.getName());
            replacements.put("functionName", definition.getFunctionName());
            List dependencyItems = definition.getDependencyItems();
            if (CollectionUtil.isNotEmpty((Collection)dependencyItems)) {
                ArrayList<String> list = new ArrayList<String>();
                for (String s : dependencyItems) {
                    if (s.contains("\\.Parent\\.")) {
                        list.add(String.format("\"%s\"", s.replace("ActiveObject", ShareDataServiceImpl.getBeforeLastDot((String)definition.getEntityFullName()))));
                        continue;
                    }
                    list.add(String.format("\"%s\"", s.replace("ActiveObject", definition.getEntityFullName())));
                }
                definition.setDependencyItems(list);
                replacements.put("dependencyItems", "Arrays.asList(" + String.join((CharSequence)",", list) + ")");
            } else {
                log.info("functionName:{}\u5bf9\u5e94\u7684\u4f9d\u8d56\u9879\u4e0d\u5b58\u5728", (Object)definition.getFunctionName());
                replacements.put("dependencyItems", "null");
            }
            replacements.put("conditionFunc", String.join((CharSequence)"\n        ", pythonCovertJavaDTO.getTranslate().getCondition()));
            replacements.put("getParameters", String.join((CharSequence)"\n        ", pythonCovertJavaDTO.getTranslate().getExpression()));
            definition.setTranslate(TemplateUtil.replaceTemplate((String)TemplateUtil.getShareDataVariableTemplate(), replacements));
            definition.setClassFullName(String.format(classFullNameFormat, typeKey, definition.getCode().replace("-", "_"), definition.getCounter()));
        }
    }

    public static String getBeforeLastDot(String fullName) {
        return Optional.ofNullable(fullName).filter(s -> !s.isEmpty()).map(s -> {
            int lastDotIndex = s.lastIndexOf(46);
            return lastDotIndex == -1 ? s : s.substring(0, lastDotIndex);
        }).orElse("");
    }

    public static void main(String[] args) {
        String entityFullName = "a\\.b\\.c\\.d";
        if ("a\\.d\\.Parent\\.e".contains("\\.Parent\\.")) {
            String beforeLastDot = ShareDataServiceImpl.getBeforeLastDot((String)entityFullName);
            System.out.println(beforeLastDot);
        }
    }

    public void variableFullClass(Long productVersionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SclShareDataVariables::getProductVersionId, (Object)4);
        List<SclShareDataVariables> list = this.sclShareDataVariableMapper.selectList((Wrapper)queryWrapper);
        list = list.stream().filter(res -> res.getName().equals("VL_OoqlValidate05")).toList();
        LambdaQueryWrapper businessQueryWrapper = new LambdaQueryWrapper();
        businessQueryWrapper.eq(SclBusinessObject::getProductVersionId, (Object)4);
        List sclBusinessObjects = this.sclBusinessObjectMapper.selectList((Wrapper)businessQueryWrapper);
        Map<Long, String> businessObjectsRel = sclBusinessObjects.stream().collect(Collectors.toMap(SclBusinessObject::getId, SclBusinessObject::getCode, (existingValue, newValue) -> existingValue));
        Map integerListMap = GroupObjectUtil.groupBySizeWithStream(list, (int)1);
        integerListMap.forEach((k, v) -> {
            log.info("\u5f00\u59cb\u5904\u7406\uff1a\u7b2c{}\u8f6e\u8c03\u7528LLM\u751f\u6210\u4ee3\u7801", k);
            ArrayList<Map> jsonList = new ArrayList<Map>();
            for (SclShareDataVariables sclShareDataVariables : v) {
                String content = sclShareDataVariables.getContent();
                Map map = (Map)JSONObject.parseObject((String)content, Map.class);
                map.put("bizCode", sclShareDataVariables.getId());
                jsonList.add(map);
            }
            System.out.println(JSONObject.toJSONString(jsonList));
        });
        log.info("\u5168\u90e8\u5904\u7406\u5b8c\u6bd5");
    }

    public void generateShareData(Map<String, Object> param) {
        Long productVersionId = MapUtils.getLong(param, (Object)"productVersionId");
        String directoryPath = MapUtils.getString(param, (Object)"directoryPath");
        String code = MapUtils.getString(param, (Object)"code");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SclBusinessObject::getProductVersionId, (Object)productVersionId);
        List sclBusinessObjects = this.sclBusinessObjectMapper.selectList((Wrapper)queryWrapper);
        Map<String, Long> businessObjectsRel = sclBusinessObjects.stream().collect(Collectors.toMap(SclBusinessObject::getCode, SclBusinessObject::getId, (existingValue, newValue) -> existingValue));
        E10Properties e10Properties = PropertiesUtil.getE10Properties((String)directoryPath);
        MetadataParser metadataParser = new MetadataParser(e10Properties);
        try {
            metadataParser.parser();
            this.sclShareDataRelationMapper.deleteByProductVersionId(productVersionId);
            this.e10ShareDataService.batchParserInsert(metadataParser.getEntityMap(), e10Properties.getBusinessObjectsRoot(), code, businessObjectsRel, productVersionId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

