/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.t100.mongo;

import com.digiwin.athena.ai.generate.tools.t100.dto.MongoConfigRequest;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.stereotype.Component;

@Component
public class MongoTemplateFactory
implements DisposableBean {
    private static final Map<String, MongoTemplate> templateCache = new ConcurrentHashMap<String, MongoTemplate>();
    private static final Map<String, MongoClient> clientCache = new ConcurrentHashMap<String, MongoClient>();

    public static MongoTemplate getTemplate(MongoConfigRequest req) {
        String key = MongoTemplateFactory.buildKey(req);
        return templateCache.computeIfAbsent(key, k -> {
            String uri = String.format("mongodb://%s:%s@%s:%d/%s?authSource=admin", req.getUsername(), req.getPassword(), req.getHost(), req.getPort(), req.getDatabase());
            MongoClient client = MongoClients.create((String)uri);
            clientCache.put(key, client);
            return new MongoTemplate((MongoDatabaseFactory)new SimpleMongoClientDatabaseFactory(client, req.getDatabase()));
        });
    }

    public static void close(String key) {
        MongoClient client = clientCache.remove(key);
        if (client != null) {
            client.close();
        }
        templateCache.remove(key);
    }

    public static void close() {
        Set<String> keySet = clientCache.keySet();
        for (String key : keySet) {
            MongoTemplateFactory.close(key);
        }
        templateCache.clear();
    }

    private static String buildKey(MongoConfigRequest req) {
        return req.getUsername() + "@" + req.getHost() + ":" + req.getPort() + "/" + req.getDatabase();
    }

    public void destroy() throws Exception {
        MongoTemplateFactory.close();
    }
}

