/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.t100.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiConfig;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiResponse;
import com.digiwin.athena.ai.generate.tools.common.service.CommonGenerateToolsService;
import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclModule;
import com.digiwin.athena.ai.generate.tools.db.bo.SclModuleJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProduct;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiInputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiOutputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductVersionMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateHolder;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.enums.ProductEnum;
import com.digiwin.athena.ai.generate.tools.t100.dto.Application;
import com.digiwin.athena.ai.generate.tools.t100.dto.LcdpPageDesign;
import com.digiwin.athena.ai.generate.tools.t100.dto.MongoConfigRequest;
import com.digiwin.athena.ai.generate.tools.t100.dto.PageDsl;
import com.digiwin.athena.ai.generate.tools.t100.dto.T100ExeccuteContext;
import com.digiwin.athena.ai.generate.tools.t100.mongo.MongoTemplateFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

@Service
public class T100GenerateToolsServiceImpl
extends CommonGenerateToolsService {
    @Autowired
    private SclProductMapper sclProductMapper;
    @Autowired
    private SclProductVersionMapper sclProductVersionMapper;
    @Autowired
    private SclModuleMapper sclModuleMapper;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclModuleJobMapper sclModuleJobMapper;
    @Autowired
    private SclApiMapper sclApiMapper;
    @Autowired
    private SclApiInputParamMapper sclApiInputParamMapper;
    @Autowired
    private SclApiOutputParamMapper sclApiOutputParamMapper;

    public boolean condition(ProductEnum productEnum) {
        return ProductEnum.T100.getCode().equals(productEnum.getCode());
    }

    public GenerateHolder execute(GenerateRequestDTO generateRequestDTO) {
        String name = generateRequestDTO.getProductNo();
        String version = generateRequestDTO.getVersion();
        SclProduct sclProduct = this.sclProductMapper.selectByName(name);
        if (sclProduct == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1", name));
        }
        SclProductVersion sclProductVersion = this.sclProductVersionMapper.selectByProductIdAndVersion(sclProduct.getId(), version);
        if (sclProductVersion == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1\u7684\u3010%s\u3011\u7248\u672c", name, version));
        }
        T100ExeccuteContext executeContext = new T100ExeccuteContext();
        executeContext.setSclProduct(sclProduct);
        executeContext.setSclProductVersion(sclProductVersion);
        MongoConfigRequest mongoConfigRequest = this.getLcdpMongoConfigRequest(generateRequestDTO);
        MongoTemplate mongoTemplate = MongoTemplateFactory.getTemplate(mongoConfigRequest);
        SclModule sclModule = this.getSclModule(mongoTemplate, executeContext);
        List<LcdpPageDesign> lcdpPageDesigns = this.getLcdpPageDesigns(mongoTemplate, executeContext);
        List<SclBusinessObject> sclBusinessObjectList = this.getSclBusinessObjectList(executeContext, lcdpPageDesigns);
        Map<String, SclBusinessObject> businessObjectMap = sclBusinessObjectList.stream().collect(Collectors.toMap(SclBusinessObject::getCode, o -> o));
        List<SclJob> sclJobList = this.getSclJobList(executeContext, lcdpPageDesigns);
        List<PageDsl> lcdpPageDsls = this.getLcdpPageDsl(mongoTemplate, executeContext, lcdpPageDesigns);
        Map<String, String> dslCode2PageDesignCodeMap = lcdpPageDsls.stream().collect(Collectors.toMap(PageDsl::getCode, PageDsl::getPageDesignCode));
        Map<String, List> dslCodeDataConnectMap = lcdpPageDsls.stream().collect(Collectors.toMap(PageDsl::getCode, o -> o.getDsl().getDataConnectors()));
        ApiConfig apiConfig = this.getApiConfig(generateRequestDTO);
        HashMap<String, ApiResponse> cacheApiMap = new HashMap<String, ApiResponse>();
        LinkedMultiValueMap apiName2PageDesignCodeMap = new LinkedMultiValueMap();
        for (Map.Entry<String, List> entry : dslCodeDataConnectMap.entrySet()) {
            Set apiNameSet = entry.getValue().stream().flatMap(o -> o.getOption().getRequest().getHeaders().stream()).filter(o -> "digi-service".equals(o.getKey())).map(o -> JSON.parseObject((String)o.getValue()).getString("name")).collect(Collectors.toSet());
            for (String apiName : apiNameSet) {
                apiName2PageDesignCodeMap.add((Object)apiName, (Object)dslCode2PageDesignCodeMap.get(entry.getKey()));
                cacheApiMap.put(apiName, this.getApiInfo(apiConfig, apiName));
            }
        }
        Map sclApiInfoHolder = this.getSclApiInfoHolder(cacheApiMap);
        this.sclModuleMapper.insert((Object)sclModule);
        this.sclBusinessObjectMapper.insert(sclBusinessObjectList);
        sclJobList.forEach(o -> o.setBusinessObjectId(((SclBusinessObject)businessObjectMap.get(o.getCode())).getId()));
        this.sclJobMapper.insert(sclJobList);
        List moduleJobs = sclJobList.stream().map(o -> {
            SclModuleJob sclModuleJob = new SclModuleJob();
            sclModuleJob.setJobId(o.getId());
            sclModuleJob.setModuleId(sclModule.getId());
            sclModuleJob.setProductVersionId(executeContext.getSclProductVersion().getId());
            return sclModuleJob;
        }).collect(Collectors.toList());
        this.sclModuleJobMapper.insert(moduleJobs);
        this.saveSclApi(businessObjectMap, apiName2PageDesignCodeMap, sclApiInfoHolder);
        return new GenerateHolder();
    }

    private List<SclBusinessObject> getSclBusinessObjectList(T100ExeccuteContext executeContext, List<LcdpPageDesign> lcdpPageDesign) {
        return lcdpPageDesign.stream().map(o -> {
            SclBusinessObject sclBusinessObject = new SclBusinessObject();
            sclBusinessObject.setId(Long.valueOf(this.getNextId()));
            sclBusinessObject.setProductVersionId(executeContext.getSclProductVersion().getId());
            sclBusinessObject.setName(o.getName());
            sclBusinessObject.setCode(o.getCode());
            return sclBusinessObject;
        }).collect(Collectors.toList());
    }

    private SclModule getSclModule(MongoTemplate mongoTemplate, T100ExeccuteContext execcuteContext) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)execcuteContext.getAppCode()));
        Application application = (Application)mongoTemplate.findOne(query, Application.class, "application");
        if (application == null) {
            throw new IllegalArgumentException(String.format("\u5f53\u524d\u6570\u636e\u5e93\u91cc\u4e0d\u5b58\u5728code\u4e3a\u3010%s\u3011\u7684\u5e94\u7528\u6570\u636e", execcuteContext.getAppCode()));
        }
        SclModule sclModule = new SclModule();
        sclModule.setId(Long.valueOf(this.getNextId()));
        sclModule.setProductVersionId(execcuteContext.getSclProductVersion().getId());
        sclModule.setCode(application.getCode());
        sclModule.setName(application.getName());
        sclModule.setDescription(application.getDescription());
        return sclModule;
    }

    private List<SclJob> getSclJobList(T100ExeccuteContext context, List<LcdpPageDesign> lcdpPageDesign) {
        return lcdpPageDesign.stream().map(o -> {
            SclJob sclJob = new SclJob();
            sclJob.setId(Long.valueOf(this.getNextId()));
            sclJob.setCode(o.getCode());
            sclJob.setName(o.getName());
            sclJob.setProductVersionId(context.getSclProductVersion().getId());
            return sclJob;
        }).collect(Collectors.toList());
    }

    private List<PageDsl> getLcdpPageDsl(MongoTemplate mongoTemplate, T100ExeccuteContext context, List<LcdpPageDesign> lcdpPageDesigns) {
        Set dslCodeSet = lcdpPageDesigns.stream().map(LcdpPageDesign::getDslCode).collect(Collectors.toSet());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(dslCodeSet));
        return mongoTemplate.find(query, PageDsl.class, "pageDsl");
    }

    private List<LcdpPageDesign> getLcdpPageDesigns(MongoTemplate mongoTemplate, T100ExeccuteContext context) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"adpApplication").is((Object)context.getAppCode()));
        return mongoTemplate.find(query, LcdpPageDesign.class, "lcdp_pageDesign");
    }

    private ApiConfig getApiConfig(GenerateRequestDTO generateRequestDTO) {
        String jsonStringInfo = generateRequestDTO.getJsonStringInfo();
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)jsonStringInfo, JSONObject.class);
        JSONObject api = jsonObject.getJSONObject("api");
        return (ApiConfig)JSON.parseObject((String)api.toJSONString(), ApiConfig.class);
    }

    private MongoConfigRequest getLcdpMongoConfigRequest(GenerateRequestDTO generateRequestDTO) {
        String jsonStringInfo = generateRequestDTO.getJsonStringInfo();
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)jsonStringInfo, JSONObject.class);
        JSONObject dsl = jsonObject.getJSONObject("dsl");
        return (MongoConfigRequest)JSON.parseObject((String)dsl.toJSONString(), MongoConfigRequest.class);
    }

    public GenerateHolder clear(GenerateRequestDTO generateRequestDTO) {
        return super.clear(generateRequestDTO);
    }
}

