/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.t100.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiConfig;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiResponse;
import com.digiwin.athena.ai.generate.tools.common.dto.SclApiInfoHolder;
import com.digiwin.athena.ai.generate.tools.common.service.CommonGenerateToolsService;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApi;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApiInputParam;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApiOutputParam;
import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntity;
import com.digiwin.athena.ai.generate.tools.db.bo.SclEntityProperty;
import com.digiwin.athena.ai.generate.tools.db.bo.SclJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclJobFunction;
import com.digiwin.athena.ai.generate.tools.db.bo.SclLayout;
import com.digiwin.athena.ai.generate.tools.db.bo.SclLayoutComponent;
import com.digiwin.athena.ai.generate.tools.db.bo.SclModule;
import com.digiwin.athena.ai.generate.tools.db.bo.SclModuleJob;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProduct;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiInputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiOutputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityPropertyMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobFunctionMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclLayoutComponentMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclLayoutMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductVersionMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateHolder;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.enums.ProductEnum;
import com.digiwin.athena.ai.generate.tools.t100.dto.ApiResponseHolder;
import com.digiwin.athena.ai.generate.tools.t100.dto.Application;
import com.digiwin.athena.ai.generate.tools.t100.dto.DataConnect;
import com.digiwin.athena.ai.generate.tools.t100.dto.Dsl;
import com.digiwin.athena.ai.generate.tools.t100.dto.LcdpPageDesign;
import com.digiwin.athena.ai.generate.tools.t100.dto.MongoConfigRequest;
import com.digiwin.athena.ai.generate.tools.t100.dto.PageDsl;
import com.digiwin.athena.ai.generate.tools.t100.dto.ParseDslTempContext;
import com.digiwin.athena.ai.generate.tools.t100.dto.T100ExecuteContext;
import com.digiwin.athena.ai.generate.tools.t100.mongo.MongoTemplateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

@Service
public class T100GenerateToolsServiceImpl
extends CommonGenerateToolsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(T100GenerateToolsServiceImpl.class);
    @Autowired
    private SclProductMapper sclProductMapper;
    @Autowired
    private SclProductVersionMapper sclProductVersionMapper;
    @Autowired
    private SclModuleMapper sclModuleMapper;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclModuleJobMapper sclModuleJobMapper;
    @Autowired
    private SclApiMapper sclApiMapper;
    @Autowired
    private SclApiInputParamMapper sclApiInputParamMapper;
    @Autowired
    private SclApiOutputParamMapper sclApiOutputParamMapper;
    @Autowired
    private SclEntityMapper sclEntityMapper;
    @Autowired
    private SclEntityPropertyMapper sclEntityPropertyMapper;
    @Autowired
    private SclLayoutMapper sclLayoutMapper;
    @Autowired
    private SclLayoutComponentMapper sclLayoutComponentMapper;
    @Autowired
    private SclJobFunctionMapper sclJobFunctionMapper;

    public boolean condition(ProductEnum productEnum) {
        return ProductEnum.T100.getCode().equals(productEnum.getCode());
    }

    public GenerateHolder execute(GenerateRequestDTO generateRequestDTO) {
        String version = generateRequestDTO.getVersion();
        String name = generateRequestDTO.getProductNo();
        SclProduct sclProduct = this.sclProductMapper.selectByName(name);
        if (sclProduct == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011 \u7684\u4ea7\u54c1", name));
        }
        SclProductVersion sclProductVersion = this.sclProductVersionMapper.selectByProductIdAndVersion(sclProduct.getId(), version);
        if (sclProductVersion == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1\u7684\u3010%s\u3011\u7248\u672c", name, version));
        }
        T100ExecuteContext executeContext = new T100ExecuteContext();
        executeContext.setSclProduct(sclProduct);
        executeContext.setSclProductVersion(sclProductVersion);
        MongoConfigRequest mongoConfigRequest = this.getLcdpMongoConfigRequest(generateRequestDTO);
        MongoTemplate mongoTemplate = MongoTemplateFactory.getTemplate(mongoConfigRequest);
        SclModule sclModule = this.getSclModule(mongoTemplate, executeContext);
        List<LcdpPageDesign> lcdpPageDesigns = this.getLcdpPageDesigns(mongoTemplate, executeContext);
        List<SclBusinessObject> sclBusinessObjectList = this.getSclBusinessObjectList(executeContext, lcdpPageDesigns);
        Map<String, SclBusinessObject> businessObjectMap = sclBusinessObjectList.stream().collect(Collectors.toMap(SclBusinessObject::getCode, o -> o));
        List<SclJob> sclJobList = this.getSclJobList(executeContext, lcdpPageDesigns);
        List<PageDsl> pageDsls = this.getLcdpPageDsl(mongoTemplate, executeContext, lcdpPageDesigns);
        Map<String, String> dslCode2PageDesignCodeMap = pageDsls.stream().collect(Collectors.toMap(PageDsl::getCode, PageDsl::getPageDesignCode));
        Map<String, List> dslCodeDataConnectMap = pageDsls.stream().collect(Collectors.toMap(PageDsl::getCode, o -> o.getDsl().getDataConnectors()));
        ApiConfig apiConfig = this.getApiConfig(generateRequestDTO);
        LinkedMultiValueMap cacheApiMap = new LinkedMultiValueMap();
        for (Map.Entry<String, List> entry : dslCodeDataConnectMap.entrySet()) {
            for (DataConnect dataConnect : entry.getValue()) {
                for (DataConnect.Option.Request.Headers header : dataConnect.getOption().getRequest().getHeaders()) {
                    List apiResponseHolders;
                    if (!"digi-service".equals(header.getKey())) continue;
                    String apiName = JSON.parseObject((String)header.getValue()).getString("name");
                    if (ApiResponseHolder.isExists(apiName, apiResponseHolders = cacheApiMap.get((Object)apiName), dslCode2PageDesignCodeMap.get(entry.getKey()), businessObjectMap, dataConnect.getName())) {
                        ApiResponseHolder.append(apiResponseHolders, dslCode2PageDesignCodeMap.get(entry.getKey()), businessObjectMap, dataConnect.getName());
                        continue;
                    }
                    ApiResponse apiInfo = this.getApiInfo(apiConfig, apiName);
                    ArrayList<ApiResponseHolder> apiResponseArrayList = new ArrayList<ApiResponseHolder>();
                    if (apiResponseHolders != null) {
                        apiResponseArrayList.addAll(apiResponseHolders);
                    }
                    ApiResponseHolder apiResponseHolder = new ApiResponseHolder();
                    apiResponseHolder.setApiResponse(apiInfo);
                    ApiResponseHolder.JobInfo jobInfo = new ApiResponseHolder.JobInfo();
                    jobInfo.setJobCode(dslCode2PageDesignCodeMap.get(entry.getKey()));
                    jobInfo.getDataconnectIds().add(dataConnect.getName());
                    jobInfo.setBusinessObjectId(businessObjectMap.get(jobInfo.getJobCode()).getId());
                    jobInfo.getDataConnectMap().put(dataConnect.getName(), dataConnect);
                    apiResponseHolder.setJobInfo(jobInfo);
                    apiResponseArrayList.add(apiResponseHolder);
                    cacheApiMap.put((Object)apiName, apiResponseArrayList);
                }
            }
        }
        LinkedMultiValueMap<String, SclApiInfoHolder> sclApiInfoHolder = this.getSclApiInfoHolder(executeContext, (LinkedMultiValueMap<String, ApiResponseHolder>)cacheApiMap);
        this.sclModuleMapper.insert((Object)sclModule);
        this.sclBusinessObjectMapper.insert(sclBusinessObjectList);
        sclJobList.forEach(o -> o.setBusinessObjectId(((SclBusinessObject)businessObjectMap.get(o.getCode())).getId()));
        this.sclJobMapper.insert(sclJobList);
        List moduleJobs = sclJobList.stream().map(o -> {
            SclModuleJob sclModuleJob = new SclModuleJob();
            sclModuleJob.setJobId(o.getId());
            sclModuleJob.setModuleId(sclModule.getId());
            sclModuleJob.setProductVersionId(executeContext.getSclProductVersion().getId());
            return sclModuleJob;
        }).collect(Collectors.toList());
        this.sclModuleJobMapper.insert(moduleJobs);
        List<SclApi> sclApis = this.saveSclApi(sclApiInfoHolder);
        executeContext.setSclApis(sclApis);
        this.saveEntity(executeContext, sclApis);
        this.parsePageDsls(executeContext, dslCode2PageDesignCodeMap, sclApiInfoHolder, sclJobList, pageDsls);
        return new GenerateHolder();
    }

    private void parsePageDsls(T100ExecuteContext executeContext, Map<String, String> dslCode2PageDesignCodeMap, LinkedMultiValueMap<String, SclApiInfoHolder> sclApiInfoHolder, List<SclJob> sclJobList, List<PageDsl> pageDsls) {
        Map<String, Long> jobCode2IdMap = sclJobList.stream().collect(Collectors.toMap(SclJob::getCode, SclJob::getId));
        pageDsls.forEach(pageDsl -> {
            List<DataConnect> dataConnectors = pageDsl.getDsl().getDataConnectors();
            Set apiNameSet = dataConnectors.stream().flatMap(o -> o.getOption().getRequest().getHeaders().stream()).filter(o -> "digi-service".equals(o.getKey())).map(o -> JSON.parseObject((String)o.getValue()).getString("name")).collect(Collectors.toSet());
            Set<String> defaultApis = dataConnectors.stream().filter(o -> {
                String runOnlyIf = o.getRunOnlyIf();
                if (runOnlyIf != null) {
                    String bool = runOnlyIf.replaceAll("\\{", "").replaceAll("}", "").trim();
                    return Boolean.getBoolean(bool);
                }
                return false;
            }).flatMap(o -> o.getOption().getRequest().getHeaders().stream()).filter(o -> "digi-service".equals(o.getKey())).map(o -> JSON.parseObject((String)o.getValue()).getString("name")).collect(Collectors.toSet());
            Set<SclApi> sclApiSets = executeContext.getSclApis().stream().filter(o -> apiNameSet.contains(o.getName())).collect(Collectors.toSet());
            ParseDslTempContext parseDslTempContext = new ParseDslTempContext(sclApiSets);
            parseDslTempContext.setDefaultApiNames(defaultApis);
            parseDslTempContext.setDoingParseJobCode((String)dslCode2PageDesignCodeMap.get(pageDsl.getCode()));
            parseDslTempContext.setDoingParseJobId((Long)jobCode2IdMap.get(dslCode2PageDesignCodeMap.get(pageDsl.getCode())));
            parseDslTempContext.setSclApiInfoHolder(sclApiInfoHolder);
            SclLayout sclLayout = new SclLayout();
            sclLayout.setCode(pageDsl.getType());
            sclLayout.setName(pageDsl.getCode());
            sclLayout.setId(Long.valueOf(this.getNextId()));
            sclLayout.setJobId((Long)jobCode2IdMap.get(dslCode2PageDesignCodeMap.get(pageDsl.getCode())));
            sclLayout.setProductVersionId(executeContext.getSclProductVersion().getId());
            Dsl dsl = pageDsl.getDsl();
            List<JSONObject> layout = dsl.getLayout();
            layout.forEach(component -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, null, (JSONObject)component));
            Set layoutIds = parseDslTempContext.getSclLayoutComponents().stream().map(SclLayoutComponent::getLayoutId).collect(Collectors.toSet());
            if (layoutIds.contains(sclLayout.getId())) {
                parseDslTempContext.getSclLayouts().add(sclLayout);
            }
            if (!parseDslTempContext.getSclLayouts().isEmpty()) {
                this.sclLayoutMapper.insert(parseDslTempContext.getSclLayouts());
            }
            if (!parseDslTempContext.getSclLayoutComponents().isEmpty()) {
                this.sclLayoutComponentMapper.insert(parseDslTempContext.getSclLayoutComponents());
            }
            if (!parseDslTempContext.getSclJobFunctions().isEmpty()) {
                this.sclJobFunctionMapper.insert(parseDslTempContext.getSclJobFunctions());
            }
        });
    }

    private void parseLayoutComponent(T100ExecuteContext executeContext, ParseDslTempContext parseDslTempContext, SclLayout sclLayout, SclLayoutComponent parent, JSONObject component) {
        if (component.containsKey((Object)"type")) {
            if ("OUTLET".equals(component.getString("type"))) {
                return;
            }
            SclLayoutComponent sclLayoutComponent = new SclLayoutComponent();
            sclLayoutComponent.setId(Long.valueOf(this.getNextId()));
            sclLayoutComponent.setCode(component.getString("id"));
            if (sclLayoutComponent.getCode() == null) {
                sclLayoutComponent.setCode(String.valueOf(sclLayoutComponent.getId()));
            }
            sclLayoutComponent.setLayoutId(sclLayout.getId());
            sclLayoutComponent.setType(component.getString("type"));
            if (component.getString("title") != null) {
                sclLayoutComponent.setDisplayName(component.getString("title"));
            }
            if (sclLayoutComponent.getDisplayName() == null) {
                sclLayoutComponent.setDisplayName(component.getString("headerName"));
            }
            if (sclLayoutComponent.getDisplayName() == null) {
                sclLayoutComponent.setDisplayName(component.getString("tableTitle"));
            }
            if (sclLayoutComponent.getDisplayName() == null) {
                sclLayoutComponent.setDisplayName(component.getString("label"));
            }
            sclLayoutComponent.setSchema(component.getString("schema"));
            sclLayoutComponent.setPath(component.getString("path"));
            sclLayoutComponent.setProductVersionId(executeContext.getSclProductVersion().getId());
            if (parent != null) {
                sclLayoutComponent.setParentId(parent.getId());
            }
            this.bindLayoutComponentApiOutputFieldId(executeContext, parseDslTempContext, sclLayoutComponent, component);
            parseDslTempContext.getSclLayoutComponents().add(sclLayoutComponent);
            if (sclLayoutComponent.getType().startsWith("BUTTON")) {
                this.parseFunction(executeContext, parseDslTempContext, sclLayout, component);
            }
            if ("MODAL".equals(component.getString("type"))) {
                JSONArray bodyGroup = component.getJSONArray("bodyGroup");
                bodyGroup.forEach(o -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, sclLayoutComponent, JSON.parseObject((String)JSON.toJSONString((Object)o))));
                JSONArray footerGroup = component.getJSONArray("footerGroup");
                footerGroup.forEach(o -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, sclLayoutComponent, JSON.parseObject((String)JSON.toJSONString((Object)o))));
            } else if ("ATHENA_TABLE".equals(component.getString("type"))) {
                JSONArray columnDefsGroup = component.getJSONArray("columnDefs");
                columnDefsGroup.forEach(o -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, sclLayoutComponent, JSON.parseObject((String)JSON.toJSONString((Object)o))));
                JSONArray slots = component.getJSONArray("slots");
                slots.forEach(o -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, sclLayoutComponent, JSON.parseObject((String)JSON.toJSONString((Object)o))));
            } else if (component.containsKey((Object)"group")) {
                JSONArray group = component.getJSONArray("group");
                group.forEach(o -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, sclLayoutComponent, JSON.parseObject((String)JSON.toJSONString((Object)o))));
            }
        } else if (component.containsKey((Object)"columns")) {
            JSONArray columnsJsonArray = component.getJSONArray("columns");
            columnsJsonArray.forEach(o -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, null, JSON.parseObject((String)JSON.toJSONString((Object)o))));
        } else if (component.containsKey((Object)"select")) {
            JSONArray columnsJsonArray = component.getJSONArray("group");
            columnsJsonArray.forEach(o -> this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayout, null, JSON.parseObject((String)JSON.toJSONString((Object)o))));
        } else if (component.containsKey((Object)"outletConfig")) {
            JSONObject outletConfig = component.getJSONObject("outletConfig");
            JSONArray group = outletConfig.getJSONArray("group");
            group.forEach(o -> {
                SclLayout sclLayoutNew = new SclLayout();
                sclLayoutNew.setCode(sclLayout.getCode());
                sclLayoutNew.setName(sclLayout.getName());
                sclLayoutNew.setId(Long.valueOf(this.getNextId()));
                sclLayoutNew.setJobId(sclLayout.getJobId());
                sclLayoutNew.setProductVersionId(executeContext.getSclProductVersion().getId());
                parseDslTempContext.getSclLayouts().add(sclLayoutNew);
                this.parseLayoutComponent(executeContext, parseDslTempContext, sclLayoutNew, null, JSON.parseObject((String)JSON.toJSONString((Object)o)));
            });
        } else {
            log.warn("\u672a\u8bc6\u522b\u7684\u7ec4\u4ef6: {}", (Object)sclLayout);
        }
    }

    private void parseFunction(T100ExecuteContext executeContext, ParseDslTempContext parseDslTempContext, SclLayout sclLayout, JSONObject component) {
        JSONObject action = component.getJSONObject("action");
        if (action == null) {
            return;
        }
        String dataConnectorId = action.getString("dataConnectorId");
        if (dataConnectorId == null || dataConnectorId.isEmpty()) {
            return;
        }
        List<SclJobFunction> sclJobFunctions = parseDslTempContext.getSclJobFunctions();
        SclApiInfoHolder doingSclApiInfoHolder = T100GenerateToolsServiceImpl.getDoingSclApiInfoHolder(parseDslTempContext, dataConnectorId);
        SclJobFunction sclJobFunction = new SclJobFunction();
        sclJobFunction.setId(Long.valueOf(this.getNextId()));
        sclJobFunction.setJobId(sclLayout.getJobId());
        sclJobFunction.setName(component.getString("title"));
        sclJobFunction.setCode(component.getString("id"));
        sclJobFunction.setDescription(sclJobFunction.getName());
        sclJobFunction.setApiId(doingSclApiInfoHolder.getSclApi().getId());
        sclJobFunction.setProductVersionId(executeContext.getSclProductVersion().getId());
        sclJobFunctions.add(sclJobFunction);
    }

    private void bindLayoutComponentApiOutputFieldId(T100ExecuteContext executeContext, ParseDslTempContext parseDslTempContext, SclLayoutComponent sclLayoutComponent, JSONObject component) {
        String doingParseApiName = parseDslTempContext.getDoingParseApiName();
        Set<SclApi> sclApiSets = parseDslTempContext.getSclApiSets();
        ArrayList<SclApi> candidateSclApis = new ArrayList<SclApi>(sclApiSets);
        if (doingParseApiName == null) {
            Set<String> defaultApiNames = parseDslTempContext.getDefaultApiNames();
            if (defaultApiNames != null) {
                List<SclApi> list = sclApiSets.stream().filter(o -> defaultApiNames.contains(o.getName())).toList();
                candidateSclApis.removeAll(list);
                candidateSclApis.addAll(0, list);
            }
        } else {
            List<SclApi> list = sclApiSets.stream().filter(o -> doingParseApiName.equals(o.getName())).toList();
            candidateSclApis.removeAll(list);
            candidateSclApis.addAll(0, list);
        }
        if ("ATHENA_TABLE".equals(sclLayoutComponent.getType())) {
            JSONObject queryInfo = component.getJSONObject("queryInfo");
            String dataconnectId = queryInfo.getString("dataConnectorId");
            LinkedMultiValueMap<String, SclApiInfoHolder> sclApiInfoHolderMap = parseDslTempContext.getSclApiInfoHolder();
            SclApiInfoHolder sclApiInfoHolder = T100GenerateToolsServiceImpl.getDoingSclApiInfoHolder(parseDslTempContext, dataconnectId);
            List sclApiOutputParams = sclApiInfoHolder.getSclApiOutputParams();
            Map sclApiOutputParamMap = sclApiOutputParams.stream().collect(Collectors.toMap(SclApiOutputParam::getId, Function.identity()));
            Set allOutParamIds = sclApiOutputParams.stream().map(SclApiOutputParam::getId).collect(Collectors.toSet());
            Set allOutParamParentIds = sclApiOutputParams.stream().map(SclApiOutputParam::getParentId).collect(Collectors.toSet());
            allOutParamIds.removeAll(allOutParamParentIds);
            HashMap<Long, String> map = new HashMap<Long, String>();
            for (Long lowId : allOutParamIds) {
                SclApiOutputParam param;
                SclApiOutputParam sclApiOutputParam = (SclApiOutputParam)sclApiOutputParamMap.get(lowId);
                Long parentId = sclApiOutputParam.getParentId();
                ArrayList<String> list = new ArrayList<String>();
                list.add(sclApiOutputParam.getName());
                while (parentId != null && (param = (SclApiOutputParam)sclApiOutputParamMap.get(parentId)) != null) {
                    list.add(param.getName());
                    parentId = param.getParentId();
                }
                map.put(lowId, String.join((CharSequence)".", list.reversed()));
            }
        }
    }

    private static SclApiInfoHolder getDoingSclApiInfoHolder(ParseDslTempContext parseDslTempContext, String dataconnectId) {
        List<SclApiInfoHolder> sclApiInfoHolders = parseDslTempContext.getSclApiInfoHolder().values().stream().flatMap(Collection::parallelStream).filter(o -> o.getDataconnectIds().contains(dataconnectId) && o.getJobCode().equals(parseDslTempContext.getDoingParseJobCode())).toList();
        if (sclApiInfoHolders.size() > 1) {
            throw new IllegalArgumentException(String.format("\u4f5c\u4e1a\u3010%s\u3011\u5b58\u5728\u4e24\u4e2a\u4e00\u6837name\u7684dataconnect", parseDslTempContext.getDoingParseJobCode()));
        }
        if (sclApiInfoHolders.isEmpty()) {
            throw new IllegalArgumentException(String.format("\u4f5c\u4e1a\u3010%s\u3011\u4e0d\u5b58\u5728name\u662f\u3010%s\u3011\u7684dataconnect", parseDslTempContext.getDoingParseJobCode(), dataconnectId));
        }
        return sclApiInfoHolders.getFirst();
    }

    private void saveEntity(T100ExecuteContext executeContext, List<SclApi> sclApis) {
        sclApis.stream().filter(o -> o.getName().contains("create")).forEach(sclApi -> {
            List sclApiInputParams = this.sclApiInputParamMapper.selectApiId(sclApi.getId());
            ArrayList<SclApiInputParam> sclApiInputParamsTops = new ArrayList<SclApiInputParam>(sclApiInputParams.stream().filter(inputParam -> inputParam.getParentId() == null || inputParam.getParentId() == 0L).toList());
            sclApiInputParams.removeAll(sclApiInputParamsTops);
            Set needTopIds = sclApiInputParams.stream().map(SclApiInputParam::getParentId).collect(Collectors.toSet());
            List<SclApiInputParam> fields = sclApiInputParamsTops.stream().filter(o -> !needTopIds.contains(o.getId())).toList();
            sclApiInputParamsTops.removeAll(fields);
            if (sclApiInputParamsTops.size() != 1) {
                log.warn("api\u5165\u53c2M\u591a\u4e2a:{}", (Object)JSON.toJSONString((Object)sclApi));
            }
            SclEntity[] topEntity = new SclEntity[1];
            this.convertEntity(executeContext, (SclApi)sclApi, null, sclApiInputParams, (List<SclApiInputParam>)sclApiInputParamsTops, topEntity);
            if (topEntity[0] != null) {
                sclApi.setEntityId(topEntity[0].getId());
                this.sclApiMapper.updateById(sclApi);
            }
        });
    }

    private void convertEntity(T100ExecuteContext executeContext, SclApi sclApi, SclEntity parentEntity, List<SclApiInputParam> sclApiInputParams, List<SclApiInputParam> entityList, SclEntity[] topEntity) {
        entityList.forEach(top -> {
            SclEntity sclEntity = new SclEntity();
            sclEntity.setId(Long.valueOf(this.getNextId()));
            sclEntity.setName(sclApi.getName().replaceAll("\\.", "_") + "_" + top.getName());
            sclEntity.setDescription(top.getDescription());
            sclEntity.setDisplayName(top.getDisplayName());
            sclEntity.setBusinessObjectId(sclApi.getBusinessObjectId());
            sclEntity.setProductVersionId(executeContext.getSclProductVersion().getId());
            if (parentEntity != null) {
                sclEntity.setParentId(parentEntity.getId());
            }
            if (topEntity[0] == null) {
                topEntity[0] = sclEntity;
            }
            this.sclEntityMapper.insert((Object)sclEntity);
            ArrayList<SclApiInputParam> nextSclApiInputParam = new ArrayList<SclApiInputParam>(sclApiInputParams.stream().filter(inputParam -> top.getId().equals(inputParam.getParentId())).toList());
            sclApiInputParams.removeAll(nextSclApiInputParam);
            Set needTopIds = sclApiInputParams.stream().map(SclApiInputParam::getParentId).collect(Collectors.toSet());
            List<SclApiInputParam> candidateFields = nextSclApiInputParam.stream().filter(o -> !needTopIds.contains(o.getId())).toList();
            List<SclEntityProperty> sclEntityProperties = this.convertApiInputParamToEntityField(executeContext, sclEntity, candidateFields);
            this.sclEntityPropertyMapper.insert(sclEntityProperties);
            nextSclApiInputParam.removeAll(candidateFields);
            this.convertEntity(executeContext, sclApi, parentEntity, sclApiInputParams, nextSclApiInputParam, topEntity);
        });
    }

    private List<SclEntityProperty> convertApiInputParamToEntityField(T100ExecuteContext executeContext, SclEntity sclEntity, List<SclApiInputParam> sclApiInputParams) {
        SclEntityProperty sclEntityPropertyId = new SclEntityProperty();
        sclEntityPropertyId.setId(Long.valueOf(this.getNextId()));
        sclEntityPropertyId.setDescription("id");
        sclEntityPropertyId.setDisplayName("id");
        sclEntityPropertyId.setProductVersionId(executeContext.getSclProductVersion().getId());
        sclEntityPropertyId.setEntityId(sclEntity.getId());
        sclEntityPropertyId.setDataType("varchar");
        sclEntityPropertyId.setIsPrimaryKey(Boolean.valueOf(true));
        ArrayList nameList = new ArrayList();
        List<SclEntityProperty> sclEntityProperties = sclApiInputParams.stream().map(o -> {
            SclEntityProperty sclEntityProperty = new SclEntityProperty();
            sclEntityProperty.setId(Long.valueOf(this.getNextId()));
            sclEntityProperty.setName(o.getName());
            nameList.add(sclEntityProperty.getName());
            sclEntityProperty.setDescription(o.getDescription());
            sclEntityProperty.setDisplayName(o.getDisplayName());
            sclEntityProperty.setProductVersionId(executeContext.getSclProductVersion().getId());
            sclEntityProperty.setEntityId(sclEntity.getId());
            sclEntityProperty.setDataType(o.getDataType());
            sclEntityProperty.setDefaultValue(o.getDefaultValue());
            sclEntityProperty.setDictInfo(o.getDictInfo());
            sclEntityProperty.setDictId(o.getDictId());
            sclEntityProperty.setIsPrimaryKey(o.getIsBusinessKey());
            sclEntityProperty.setIsRequired(o.getIsRequired());
            return sclEntityProperty;
        }).toList();
        sclEntityPropertyId.setName("id");
        ArrayList<SclEntityProperty> entityFields = new ArrayList<SclEntityProperty>();
        if (!nameList.contains("id")) {
            entityFields.add(sclEntityPropertyId);
        }
        entityFields.addAll(sclEntityProperties);
        return entityFields;
    }

    private List<SclBusinessObject> getSclBusinessObjectList(T100ExecuteContext executeContext, List<LcdpPageDesign> lcdpPageDesign) {
        return lcdpPageDesign.stream().map(o -> {
            SclBusinessObject sclBusinessObject = new SclBusinessObject();
            sclBusinessObject.setId(Long.valueOf(this.getNextId()));
            sclBusinessObject.setProductVersionId(executeContext.getSclProductVersion().getId());
            sclBusinessObject.setName(o.getName());
            sclBusinessObject.setCode(o.getCode());
            return sclBusinessObject;
        }).collect(Collectors.toList());
    }

    private SclModule getSclModule(MongoTemplate mongoTemplate, T100ExecuteContext execcuteContext) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)execcuteContext.getAppCode()));
        Application application = (Application)mongoTemplate.findOne(query, Application.class, "application");
        if (application == null) {
            throw new IllegalArgumentException(String.format("\u5f53\u524d\u6570\u636e\u5e93\u91cc\u4e0d\u5b58\u5728code\u4e3a\u3010%s\u3011\u7684\u5e94\u7528\u6570\u636e", execcuteContext.getAppCode()));
        }
        SclModule sclModule = new SclModule();
        sclModule.setId(Long.valueOf(this.getNextId()));
        sclModule.setProductVersionId(execcuteContext.getSclProductVersion().getId());
        sclModule.setCode(application.getCode());
        sclModule.setName(application.getName());
        sclModule.setDescription(application.getDescription());
        return sclModule;
    }

    private List<SclJob> getSclJobList(T100ExecuteContext context, List<LcdpPageDesign> lcdpPageDesign) {
        return lcdpPageDesign.stream().map(o -> {
            SclJob sclJob = new SclJob();
            sclJob.setId(Long.valueOf(this.getNextId()));
            sclJob.setCode(o.getCode());
            sclJob.setName(o.getName());
            sclJob.setProductVersionId(context.getSclProductVersion().getId());
            return sclJob;
        }).collect(Collectors.toList());
    }

    private List<PageDsl> getLcdpPageDsl(MongoTemplate mongoTemplate, T100ExecuteContext context, List<LcdpPageDesign> lcdpPageDesigns) {
        Set<String> dslCodeSet = Set.of("DSL_b238d502100003e8", "DSL_0af52ba1-5c91-4cd2-99b1-8a2368af5dc7", "DSL_0981554f-4ab5-4c64-91b0-f56a62cde615");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(dslCodeSet).and("type").in(new Object[]{"browse", "edit"}));
        query.fields().exclude("designTime");
        return mongoTemplate.find(query, PageDsl.class, "pageDsl");
    }

    private List<LcdpPageDesign> getLcdpPageDesigns(MongoTemplate mongoTemplate, T100ExecuteContext context) {
        Set<String> dslCodeSet = Set.of("DSL_b238d502100003e8", "DSL_0af52ba1-5c91-4cd2-99b1-8a2368af5dc7", "DSL_0981554f-4ab5-4c64-91b0-f56a62cde615");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"adpApplication").is((Object)context.getAppCode()).and("dslCode").in(dslCodeSet));
        return mongoTemplate.find(query, LcdpPageDesign.class, "lcdp_pageDesign");
    }

    private ApiConfig getApiConfig(GenerateRequestDTO generateRequestDTO) {
        String jsonStringInfo = generateRequestDTO.getJsonStringInfo();
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)jsonStringInfo, JSONObject.class);
        JSONObject api = jsonObject.getJSONObject("api");
        return (ApiConfig)JSON.parseObject((String)api.toJSONString(), ApiConfig.class);
    }

    private MongoConfigRequest getLcdpMongoConfigRequest(GenerateRequestDTO generateRequestDTO) {
        String jsonStringInfo = generateRequestDTO.getJsonStringInfo();
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)jsonStringInfo, JSONObject.class);
        JSONObject dsl = jsonObject.getJSONObject("dsl");
        return (MongoConfigRequest)JSON.parseObject((String)dsl.toJSONString(), MongoConfigRequest.class);
    }

    public GenerateHolder clear(GenerateRequestDTO generateRequestDTO) {
        return super.clear(generateRequestDTO);
    }

    private LinkedMultiValueMap<String, SclApiInfoHolder> getSclApiInfoHolder(T100ExecuteContext executeContext, LinkedMultiValueMap<String, ApiResponseHolder> cacheApiMap) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        for (Map.Entry entry : cacheApiMap.entrySet()) {
            List apiResponseHolders = (List)entry.getValue();
            List sclApiInfoHolders = apiResponseHolders.stream().filter(o1 -> {
                boolean apiExist = "000".equals(o1.getApiResponse().getResponse().getCode());
                if (!apiExist) {
                    String msg = String.format("\u4f5c\u4e1a\u3010%s\u3011\u5bf9\u5e94\u7684api:\u3010%s\u3011\u67e5\u8be2\u51fa\u9519: %s", o1.getJobInfo().getJobCode(), entry.getKey(), o1.getApiResponse().getResponse().getDescription());
                    log.error(msg);
                    throw new IllegalArgumentException(msg);
                }
                return true;
            }).map(apiResponseHolder -> {
                SclApiInfoHolder sclApiInfoHolder = new SclApiInfoHolder();
                ApiResponse apiResponse = apiResponseHolder.getApiResponse();
                SclApi sclApi = this.parseSclApi((ApiResponseHolder)apiResponseHolder);
                sclApi.setBusinessObjectId(apiResponseHolder.getJobInfo().getBusinessObjectId());
                sclApi.setProductVersionId(executeContext.getSclProductVersion().getId());
                List<SclApiInputParam> sclApiInputParams = this.parseSclApiInputParam(executeContext, sclApi, apiResponse);
                List<SclApiOutputParam> sclApiOutputParams = this.parseSclApiOutputParam(executeContext, sclApi, apiResponse);
                sclApiInfoHolder.setSclApi(sclApi);
                sclApiInfoHolder.setSclApiInputParams(sclApiInputParams);
                sclApiInfoHolder.setSclApiOutputParams(sclApiOutputParams);
                sclApiInfoHolder.setJobCode(apiResponseHolder.getJobInfo().getJobCode());
                sclApiInfoHolder.setDataconnectIds(apiResponseHolder.getJobInfo().getDataconnectIds());
                return sclApiInfoHolder;
            }).collect(Collectors.toList());
            result.put((Object)((String)entry.getKey()), sclApiInfoHolders);
        }
        return result;
    }

    private List<SclApiOutputParam> parseSclApiOutputParam(T100ExecuteContext executeContext, SclApi sclApi, ApiResponse apiResponse) {
        ApiResponse.Response response = apiResponse.getResponse();
        List responseMessageSuccessSpec = response.getResponseMessageSuccessSpec();
        if (CollectionUtils.isEmpty((Collection)responseMessageSuccessSpec)) {
            return Collections.emptyList();
        }
        return responseMessageSuccessSpec.stream().map(o -> {
            SclApiOutputParam sclApiOutputParam = new SclApiOutputParam();
            sclApiOutputParam.setId(Long.valueOf(this.getNextId()));
            sclApiOutputParam.setDescription(o.getDataDescription());
            sclApiOutputParam.setName(o.getDataName());
            sclApiOutputParam.setDisplayName(o.getDataDescription());
            sclApiOutputParam.setIsBusinessKey(Boolean.valueOf("Y".equals(o.getIsBusinessKey())));
            sclApiOutputParam.setType(o.getColumnType());
            sclApiOutputParam.setDefaultValue(o.getValue());
            sclApiOutputParam.setIsRequired(Boolean.valueOf("Y".equals(o.getIsRequired())));
            sclApiOutputParam.setIsFilterable(Boolean.valueOf("Y".equals(o.getCanFilter())));
            sclApiOutputParam.setIsSortable(Boolean.valueOf("Y".equals(o.getCanSort())));
            sclApiOutputParam.setDictInfo(o.getListEnum());
            sclApiOutputParam.setIsArray(Boolean.valueOf("Y".equals(o.getIsArray())));
            sclApiOutputParam.setDataType(!StringUtils.hasText((String)o.getDataType()) && sclApiOutputParam.getIsArray() != false ? "object" : o.getDataType());
            sclApiOutputParam.setOriginalParentId(o.getParent());
            sclApiOutputParam.setOriginalId(o.getId());
            sclApiOutputParam.setProductVersionId(executeContext.getSclProductVersion().getId());
            sclApiOutputParam.setApiId(sclApi.getId());
            return sclApiOutputParam;
        }).collect(Collectors.toList());
    }

    private List<SclApiInputParam> parseSclApiInputParam(T100ExecuteContext executeContext, SclApi sclApi, ApiResponse apiResponse) {
        ApiResponse.Response response = apiResponse.getResponse();
        List requestMessageSpec = response.getRequestMessageSpec();
        if (CollectionUtils.isEmpty((Collection)requestMessageSpec)) {
            return Collections.emptyList();
        }
        return requestMessageSpec.stream().map(o -> {
            SclApiInputParam sclApiInputParam = new SclApiInputParam();
            sclApiInputParam.setId(Long.valueOf(this.getNextId()));
            sclApiInputParam.setDescription(o.getDataDescription());
            sclApiInputParam.setName(o.getDataName());
            sclApiInputParam.setDisplayName(o.getDataDescription());
            sclApiInputParam.setIsBusinessKey(Boolean.valueOf("Y".equals(o.getIsBusinessKey())));
            sclApiInputParam.setDataType(o.getDataType());
            sclApiInputParam.setType(o.getColumnType());
            sclApiInputParam.setIsRequired(Boolean.valueOf("Y".equals(o.getIsRequired())));
            sclApiInputParam.setDefaultValue(o.getValue());
            sclApiInputParam.setIsFilterable(Boolean.valueOf("Y".equals(o.getCanFilter())));
            sclApiInputParam.setIsSortable(Boolean.valueOf("Y".equals(o.getCanSort())));
            sclApiInputParam.setDictInfo(o.getListEnum());
            sclApiInputParam.setIsArray(Boolean.valueOf("Y".equals(o.getIsArray())));
            sclApiInputParam.setOriginalParentId(o.getParent());
            sclApiInputParam.setOriginalId(o.getId());
            sclApiInputParam.setProductVersionId(executeContext.getSclProductVersion().getId());
            sclApiInputParam.setApiId(sclApi.getId());
            return sclApiInputParam;
        }).collect(Collectors.toList());
    }

    private SclApi parseSclApi(ApiResponseHolder apiResponseHolder) {
        ApiResponse apiResponse = apiResponseHolder.getApiResponse();
        ApiResponse.Response response = apiResponse.getResponse();
        SclApi sclApi = new SclApi();
        sclApi.setId(Long.valueOf(this.getNextId()));
        sclApi.setName(response.getApiName());
        sclApi.setDescription(response.getApiDescription());
        sclApi.setVersion(response.getApiVersion());
        sclApi.setMethod(response.getRequestMethod());
        sclApi.setDisplayName(response.getApiRemark());
        sclApi.setInvokeType(response.getInvokeType());
        HashMap<String, Object> script = new HashMap<String, Object>();
        script.put("id", String.valueOf(sclApi.getId()));
        script.put("convert", false);
        script.put("dataconnect", apiResponseHolder.getJobInfo().getDataConnectMap());
        sclApi.setScript(JSON.toJSONString(script));
        return sclApi;
    }

    private List<SclApi> saveSclApi(LinkedMultiValueMap<String, SclApiInfoHolder> sclApiInfoHolder) {
        List<SclApi> sclApiSet = sclApiInfoHolder.values().stream().flatMap(Collection::stream).map(SclApiInfoHolder::getSclApi).filter(o -> o.getBusinessObjectId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sclApiSet)) {
            this.sclApiMapper.insert(sclApiSet);
        }
        sclApiInfoHolder.values().forEach(api -> api.forEach(o -> {
            this.saveInputParams((SclApiInfoHolder)o);
            this.saveOutputParams((SclApiInfoHolder)o);
        }));
        return sclApiSet;
    }

    private void saveInputParams(SclApiInfoHolder sclApiInfoHolder) {
        Set sclApiInputParams = sclApiInfoHolder.getSclApiInputParams().stream().filter(o -> o.getApiId() != null).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(sclApiInputParams)) {
            Set sclApiInputParamsTop = sclApiInputParams.stream().filter(o -> o.getOriginalParentId() == null).collect(Collectors.toSet());
            this.sclApiInputParamMapper.insert(sclApiInputParamsTop);
            sclApiInputParams.removeAll(sclApiInputParamsTop);
            while (!sclApiInputParams.isEmpty()) {
                Map topOriginalIdIdMap = sclApiInputParamsTop.stream().collect(Collectors.toMap(SclApiInputParam::getOriginalId, Function.identity()));
                Set<SclApiInputParam> sclApiInputParams1 = sclApiInputParams.stream().filter(o -> topOriginalIdIdMap.containsKey(o.getOriginalParentId())).collect(Collectors.toSet());
                sclApiInputParams1.forEach(o -> o.setParentId(((SclApiInputParam)topOriginalIdIdMap.get(o.getOriginalParentId())).getId()));
                if (sclApiInputParams1.isEmpty()) break;
                this.sclApiInputParamMapper.insert(sclApiInputParams1);
                sclApiInputParamsTop = sclApiInputParams1;
                sclApiInputParams.removeAll(sclApiInputParamsTop);
            }
        }
    }

    private void saveOutputParams(SclApiInfoHolder sclApiInfoHolder) {
        Set sclApiOutputParams = sclApiInfoHolder.getSclApiOutputParams().stream().filter(o -> o.getApiId() != null).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(sclApiOutputParams)) {
            Set sclApiOutputParamsTop = sclApiOutputParams.stream().filter(o -> o.getOriginalParentId() == null).collect(Collectors.toSet());
            this.sclApiOutputParamMapper.insert(sclApiOutputParamsTop);
            sclApiOutputParams.removeAll(sclApiOutputParamsTop);
            while (!sclApiOutputParams.isEmpty()) {
                Map topOriginalIdIdMap = sclApiOutputParamsTop.stream().collect(Collectors.toMap(SclApiOutputParam::getOriginalId, Function.identity()));
                Set<SclApiOutputParam> sclApiInputParams1 = sclApiOutputParams.stream().filter(o -> topOriginalIdIdMap.containsKey(o.getOriginalParentId())).collect(Collectors.toSet());
                sclApiInputParams1.forEach(o -> o.setParentId(((SclApiOutputParam)topOriginalIdIdMap.get(o.getOriginalParentId())).getId()));
                if (sclApiInputParams1.isEmpty()) break;
                this.sclApiOutputParamMapper.insert(sclApiInputParams1);
                sclApiOutputParamsTop = sclApiInputParams1;
                sclApiOutputParams.removeAll(sclApiOutputParamsTop);
            }
        }
    }
}

