/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.agent.client.sse;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.agent.client.message.MessageConverter;
import com.digiwin.athena.ania.agent.client.message.MessageConverterFactory;
import com.digiwin.athena.ania.agent.client.sse.AgentEventSourceListener;
import com.digiwin.athena.ania.agent.context.AgentContext;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.EventSourceListenerUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.sse.EventSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class TopicEventSourceListener
extends AgentEventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(TopicEventSourceListener.class);

    public TopicEventSourceListener(SseEventParams sseEventParams, SseEventDataService sseEventDataService) {
        this.sseEventParams = sseEventParams;
        this.sseEventDataService = sseEventDataService;
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        log.info("TopicEventSourceListener.onEvent id:{},type:{},data:{}", new Object[]{id, type, data});
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            Integer agentSubType;
            JSONObject dataObj = null;
            Integer agentType = this.sseEventParams.getFusionAssistant().getAssistantType();
            MessageConverter converter = MessageConverterFactory.getConverter((Integer)agentType, agentSubType = null);
            dataObj = converter != null ? converter.convert(data) : JSONObject.parseObject((String)data);
            String sseEmitterId = this.sseEventParams.getId();
            String eventType = MapUtils.getString((Map)dataObj, (Object)"type");
            SseEventlEnum.SseEventDataTypeEnum eventDataType = SseEventlEnum.SseEventDataTypeEnum.getEventDataType((String)eventType);
            if (Objects.isNull(eventDataType)) {
                log.error("TopicEventSourceListener.onEvent EventDataType Not Supported id:{},type:{},data:{}", new Object[]{id, type, data});
                return;
            }
            EventData eventData = EventSourceListenerUtils.convertEventData((JSONObject)dataObj, (SseEventParams)this.sseEventParams);
            if (Objects.isNull(eventData)) {
                log.error("TopicEventSourceListener.onEvent convertEventData is null id:{},type:{},data:{}", new Object[]{id, type, data});
                return;
            }
            this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
            SseEmitter sseEmitter = AgentContext.getSseEmitter((String)sseEmitterId);
            if (sseEmitter == null) {
                eventSource.cancel();
                AgentContext.removeAgentEventSource((String)sseEmitterId);
                return;
            }
            try {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
                SseEventContext.setAnswer((String)sseEmitterId, (EventData)eventData);
            }
            catch (IOException e) {
                log.error("TopicEventSourceListener.onEvent is error id:{},type:{},data:{}", new Object[]{id, type, data, e});
                AgentContext.removeAgentEventSource((String)sseEmitterId);
                eventSource.cancel();
                this.chatComplete(sseEmitter);
                this.sendAnswerDone(sseEmitter, false);
            }
        }
    }
}

